/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import tigase.conf.Configurator;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsProvider;
import tigase.util.ElementUtils;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;

public class StatisticsCollector
extends AbstractComponentRegistrator<StatisticsContainer>
implements XMPPService {
    private static final Logger log = Logger.getLogger("tigase.stats.StatisticsCollector");
    private static final String STATS_XMLNS = "http://jabber.org/protocol/stats";
    private ServiceEntity serviceEntity = null;
    private Level statsLevel = Level.INFO;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "stats", "Server statistics");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "stats", "Server statistics"), new ServiceIdentity("automation", "command-node", "All statistics"), new ServiceIdentity("automation", "command-list", "Statistics retrieving commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
        try {
            StatisticsProvider sp = new StatisticsProvider(this);
            String objName = "tigase.stats:type=StatisticsProvider";
            ObjectName on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(sp, on);
            Configurator.putMXBean(objName, sp);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not install Statistics MXBean: ", ex);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void componentAdded(StatisticsContainer component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof StatisticsContainer;
    }

    @Override
    public void componentRemoved(StatisticsContainer component) {
    }

    public List<StatRecord> getAllStats() {
        return this.getAllStats(Level.ALL.intValue());
    }

    public List<StatRecord> getAllStats(int level) {
        ArrayList<StatRecord> result = new ArrayList<StatRecord>();
        for (StatisticsContainer comp : this.components.values()) {
            result.addAll(this.getComponentStats(comp.getName(), level));
        }
        return result;
    }

    public List<StatRecord> getComponentStats(String name, int level) {
        List<StatRecord> result = null;
        StatisticsContainer stats = (StatisticsContainer)this.components.get(name);
        if (stats != null && (result = stats.getStatistics()) != null) {
            Iterator<StatRecord> it = result.iterator();
            while (it.hasNext()) {
                StatRecord statRecord = it.next();
                if (statRecord.getLevel().intValue() >= level) continue;
                it.remove();
            }
        }
        return result;
    }

    public List<String> getComponentsNames() {
        return new ArrayList<String>(this.components.keySet());
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (!packet.isCommand() || packet.getType() != null && packet.getType() == StanzaType.result) {
            return;
        }
        switch (packet.getCommand()) {
            case GETSTATS: {
                log.finest("Command received: " + packet.getStringData());
                Element iq = ElementUtils.createIqQuery(packet.getElemTo(), packet.getElemFrom(), StanzaType.result, packet.getElemId(), STATS_XMLNS);
                Element query = iq.getChild("query");
                List<StatRecord> stats = this.getAllStats();
                if (stats != null && stats.size() > 0) {
                    for (StatRecord record : stats) {
                        Element item = new Element("stat");
                        item.addAttribute("name", record.getComponent() + "/" + record.getDescription());
                        item.addAttribute("units", record.getUnit());
                        item.addAttribute("value", record.getValue());
                        query.addChild((XMLNodeIfc)item);
                    }
                }
                Packet result = new Packet(iq);
                results.offer(result);
                break;
            }
            case OTHER: {
                if (packet.getStrCommand() == null) {
                    return;
                }
                String nick = JIDUtils.getNodeNick((String)packet.getTo());
                if (nick == null || !this.getName().equals(nick)) {
                    return;
                }
                Command.Action action = Command.getAction(packet);
                if (action == Command.Action.cancel) {
                    Packet result = packet.commandResult(null);
                    results.offer(result);
                    return;
                }
                log.finest("Command received: " + packet.getStringData());
                String tmp_val = Command.getFieldValue(packet, "Stats level");
                if (tmp_val != null) {
                    this.statsLevel = Level.parse(tmp_val);
                }
                List<StatRecord> stats = null;
                if (packet.getStrCommand().equals("stats")) {
                    stats = this.getAllStats(this.statsLevel.intValue());
                } else {
                    String[] spl = packet.getStrCommand().split("/");
                    stats = this.getComponentStats(spl[1], this.statsLevel.intValue());
                }
                if (stats == null || stats.size() <= 0) break;
                Packet result = packet.commandResult(Command.DataType.form);
                for (StatRecord rec : stats) {
                    if (rec.getType() == StatisticType.LIST) {
                        Command.addFieldMultiValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), rec.getListValue());
                        continue;
                    }
                    Command.addFieldValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), XMLUtils.escape((String)rec.getValue()));
                }
                Command.addFieldValue(result, "Stats level", this.statsLevel.getName(), "Stats level", new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()}, new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()});
                results.offer(result);
                break;
            }
        }
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (this.getName().equals(JIDUtils.getNodeNick((String)jid)) || this.getComponentId().equals(jid)) {
            List<Element> items = this.serviceEntity.getDiscoItems(node, jid);
            log.finest("Processing discoItems for node: " + node + ", result: " + (items == null ? null : items.toString()));
            return items;
        }
        if (node == null) {
            Element item = this.serviceEntity.getDiscoItem(null, JIDUtils.getNodeID((String)this.getName(), (String)jid));
            log.finest("Processing discoItems, result: " + (item == null ? null : item.toString()));
            return Arrays.asList(item);
        }
        return null;
    }
}

