/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Queue;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.xmppsession.AbstractAdminCommand;

public class AdminScript
extends AbstractAdminCommand {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.AdminScript");
    private String script = null;
    private String language = null;

    public void init(String id, String description, String script, String lang) {
        super.init(id, description);
        this.script = script;
        this.language = lang;
        log.info("Initialized script command, lang: " + this.language + ", script text: \n" + this.script);
    }

    @Override
    public void runCommand(Packet packet, Bindings binds, Queue<Packet> results) {
        ScriptContext context = null;
        StringWriter writer = null;
        try {
            ScriptEngineManager scriptEngineManager = (ScriptEngineManager)binds.get("scriptManager");
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(this.language);
            Bindings localBinds = scriptEngine.createBindings();
            localBinds.put("packet", (Object)packet);
            Object res = "";
            localBinds.put("result", res);
            context = scriptEngine.getContext();
            context.setBindings(localBinds, 100);
            writer = new StringWriter();
            context.setErrorWriter(writer);
            StringReader sr = new StringReader(this.script);
            res = scriptEngine.eval((Reader)sr, context);
            if (res == null && (res = localBinds.get("result")).toString().isEmpty()) {
                res = localBinds.get("packet");
            }
            if (res instanceof Packet) {
                results.offer((Packet)res);
            } else if (res instanceof Queue) {
                results.addAll((Queue)res);
            } else {
                Packet result = packet.commandResult(Command.DataType.result);
                Command.addTextField(result, "Note", "Script execution result.");
                String[] text = null;
                text = res != null ? res.toString().split("\n") : new String[]{"Script returned no results."};
                Command.addFieldMultiValue(result, "Script text", Arrays.asList(text));
                results.offer(result);
            }
        }
        catch (Exception e) {
            Packet result = packet.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Script execution error.");
            StackTraceElement[] ste = e.getStackTrace();
            String[] error = new String[ste.length + 2 + (writer != null ? writer.toString().split("\n").length : 0)];
            error[0] = e.getMessage();
            error[1] = e.toString();
            for (int i = 0; i < ste.length; ++i) {
                error[i + 2] = ste[i].toString();
            }
            if (writer != null) {
                String[] errorMsgs = writer.toString().split("\n");
                for (int i = 0; i < errorMsgs.length; ++i) {
                    error[i + 2 + ste.length] = errorMsgs[i];
                }
            }
            Command.addFieldMultiValue(result, "Script text", Arrays.asList(error));
            results.offer(result);
        }
    }
}

