/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPIOService;

public class BoshIOService
extends XMPPIOService {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshIOService");
    private UUID sid = null;
    private long rid = -1L;
    private static final String EOL = "\r\n";
    private static final String HTTP_OK_RESPONSE = "HTTP/1.1 200 OK\r\n";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: ";
    private static final String CONTENT_TYPE_LENGTH = "Content-Length: ";
    private static final String CONNECTION = "Connection: ";
    private static final String SERVER = "Server: Tigase Bosh/" + XMPPServer.getImplementationVersion();
    private String content_type = "text/xml; charset=utf-8";

    public void setContentType(String ct) {
        this.content_type = ct;
    }

    @Override
    public void writeRawData(String data) throws IOException {
        if (data != null && data.startsWith("<body")) {
            StringBuilder sb = new StringBuilder();
            sb.append(HTTP_OK_RESPONSE);
            sb.append(CONTENT_TYPE_HEADER + this.content_type + EOL);
            sb.append(CONTENT_TYPE_LENGTH + data.getBytes().length + EOL);
            sb.append("Connection: close\r\n");
            sb.append(SERVER + EOL);
            sb.append(EOL);
            sb.append(data);
            log.finest("Writing to socket:\n" + sb.toString());
            super.writeRawData(sb.toString());
        } else {
            super.writeRawData(data);
        }
    }

    public void sendErrorAndStop(Authorization errorCode, Packet packet, String errorMsg) throws IOException {
        String code = "<body type='terminate' condition='item-not-found' xmlns='http://jabber.org/protocol/httpbind'/>";
        try {
            Packet error = errorCode.getResponseMessage(packet, errorMsg, false);
            code = error.getElement().toString();
        }
        catch (PacketErrorTypeException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1 " + errorCode.getErrorCode() + " " + errorMsg + EOL);
        sb.append(CONTENT_TYPE_HEADER + this.content_type + EOL);
        sb.append(CONTENT_TYPE_LENGTH + code.getBytes().length + EOL);
        sb.append("Connection: close\r\n");
        sb.append(SERVER + EOL);
        sb.append(EOL);
        sb.append(code);
        log.finest("Writing to socket:\n" + sb.toString());
        super.writeRawData(sb.toString());
        this.stop();
    }

    public void setSid(UUID sid) {
        this.sid = sid;
    }

    public UUID getSid() {
        return this.sid;
    }

    public void setRid(long rid) {
        this.rid = rid;
    }

    public long getRid() {
        return this.rid;
    }
}

