/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.conf.Configurable;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.ReceiverEventHandler;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;

public abstract class AbstractMessageReceiver
implements StatisticsContainer,
MessageReceiver,
Configurable,
VHostListener {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private String DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 400000L).intValue();
    private static final Logger log = Logger.getLogger("tigase.abstract.AbstractMessageReceiver");
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private String defHostname = this.DEF_HOSTNAME_PROP_VAL;
    private MessageReceiver parent = null;
    private final EnumMap<Priority, LinkedBlockingQueue<Packet>> in_queues = new EnumMap(Priority.class);
    private final EnumMap<Priority, LinkedBlockingQueue<Packet>> out_queues = new EnumMap(Priority.class);
    private Priority[] pr_cache = Priority.values();
    private Timer receiverTasks = null;
    private ConcurrentHashMap<String, ReceiverTask> waitingTasks = new ConcurrentHashMap(16, 0.75f, 4);
    private Thread in_thread = null;
    private Thread out_thread = null;
    private boolean stopped = false;
    private String name = null;
    protected VHostManagerIfc vHostManager = null;
    private Set<Pattern> regexRoutings = new CopyOnWriteArraySet<Pattern>();
    private long curr_second = 0L;
    private long curr_minute = 0L;
    private long curr_hour = 0L;
    private long[] seconds = new long[60];
    private int sec_idx = 0;
    private long[] minutes = new long[60];
    private int min_idx = 0;
    private String compId = null;
    private long[] processPacketTimings = new long[100];
    private int pptIdx = 0;
    private long statReceivedMessagesOk = 0L;
    private long statSentMessagesOk = 0L;
    private long statReceivedMessagesEr = 0L;
    private long statSentMessagesEr = 0L;

    @Override
    public String getComponentId() {
        return this.compId;
    }

    @Override
    public void initializationCompleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLowerPriority(Packet packet, EnumMap<Priority, LinkedBlockingQueue<Packet>> queues) {
        boolean result = false;
        int q_num = packet.getPriority().ordinal();
        if (q_num < this.pr_cache.length - 1) {
            EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = queues;
            synchronized (enumMap) {
                result = queues.get((Object)this.pr_cache[q_num + 1]).offer(packet);
                queues.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPacketNB(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        boolean result = false;
        EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = this.in_queues;
        synchronized (enumMap) {
            result = this.in_queues.get((Object)packet.getPriority()).offer(packet);
            this.in_queues.notifyAll();
        }
        if (result) {
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        } else {
            ++this.statReceivedMessagesEr;
            this.tryLowerPriority(packet, this.in_queues);
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = this.in_queues;
            synchronized (enumMap) {
                this.in_queues.get((Object)packet.getPriority()).put(packet);
                this.in_queues.notifyAll();
            }
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        }
        catch (InterruptedException e) {
            ++this.statReceivedMessagesEr;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addOutPacketNB(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        boolean result = false;
        EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = this.out_queues;
        synchronized (enumMap) {
            result = this.out_queues.get((Object)packet.getPriority()).offer(packet);
            this.out_queues.notifyAll();
        }
        if (result) {
            ++this.statSentMessagesOk;
        } else {
            ++this.statSentMessagesEr;
            this.tryLowerPriority(packet, this.out_queues);
        }
        return result;
    }

    protected boolean addOutPacketWithTimeout(Packet packet, ReceiverEventHandler handler, long delay, TimeUnit unit) {
        new ReceiverTask(handler, delay, unit, packet);
        return this.addOutPacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addOutPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = this.out_queues;
            synchronized (enumMap) {
                this.out_queues.get((Object)packet.getPriority()).put(packet);
                this.out_queues.notifyAll();
            }
            ++this.statSentMessagesOk;
        }
        catch (InterruptedException e) {
            ++this.statSentMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    public abstract void processPacket(Packet var1);

    @Override
    public List<StatRecord> getStatistics() {
        LinkedList<StatRecord> stats = new LinkedList<StatRecord>();
        stats.add(new StatRecord(this.getName(), "Last second packets", "int", this.seconds[this.sec_idx == 0 ? 59 : this.sec_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last minute packets", "int", this.minutes[this.min_idx == 0 ? 59 : this.min_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last hour packets", "int", this.curr_hour, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MSG_RECEIVED_OK, this.statReceivedMessagesOk, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MSG_SENT_OK, this.statSentMessagesOk, Level.FINE));
        int in_queues_size = 0;
        int out_queues_size = 0;
        for (Priority queue : Priority.values()) {
            stats.add(new StatRecord(this.getName(), "In queue: " + queue.name(), "int", this.in_queues.get((Object)queue).size(), Level.FINEST));
            stats.add(new StatRecord(this.getName(), "Out queue: " + queue.name(), "int", this.out_queues.get((Object)queue).size(), Level.FINEST));
            in_queues_size += this.in_queues.get((Object)queue).size();
            out_queues_size += this.out_queues.get((Object)queue).size();
        }
        stats.add(new StatRecord(this.getName(), "Total In queues wait", "int", in_queues_size, Level.FINE));
        stats.add(new StatRecord(this.getName(), "Total Out queues wait", "int", out_queues_size, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MAX_QUEUE_SIZE, this.maxQueueSize, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.IN_QUEUE_OVERFLOW, this.statReceivedMessagesEr, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW, this.statSentMessagesEr, Level.FINE));
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        stats.add(new StatRecord(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", "long", res / (long)this.processPacketTimings.length, Level.FINEST));
        return stats;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        int queueSize = (Integer)props.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.stopThreads();
        this.setMaxQueueSize(queueSize);
        this.startThreads();
        this.defHostname = (String)props.get("def-hostname");
        this.compId = (String)props.get("component-id");
    }

    public void setMaxQueueSize(int maxQueueSize) {
        boolean initialized;
        boolean bl = initialized = this.in_queues.get((Object)Priority.SYSTEM) != null;
        if (this.maxQueueSize != maxQueueSize || !initialized) {
            this.maxQueueSize = maxQueueSize;
            LinkedBlockingQueue<Packet> queue = null;
            LinkedBlockingQueue<Packet> newQueue = null;
            for (Priority pr : Priority.values()) {
                queue = this.in_queues.get((Object)pr);
                newQueue = new LinkedBlockingQueue<Packet>(maxQueueSize);
                if (queue != null) {
                    newQueue.addAll(queue);
                }
                this.in_queues.put(pr, newQueue);
                queue = this.out_queues.get((Object)pr);
                newQueue = new LinkedBlockingQueue(maxQueueSize);
                if (queue != null) {
                    newQueue.addAll(queue);
                }
                this.out_queues.put(pr, newQueue);
            }
        }
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String queueSize = (String)params.get("--max-queue-size");
        int queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
        if (queueSize != null) {
            try {
                queueSizeInt = Integer.parseInt(queueSize);
            }
            catch (NumberFormatException e) {
                queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
            }
        }
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getMaxQueueSize(queueSizeInt));
        this.DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        defs.put("component-id", this.compId);
        return defs;
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.compId = JIDUtils.getNodeID((String)name, (String)this.defHostname);
        this.setMaxQueueSize(this.maxQueueSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void stopThreads() {
        this.stopped = true;
        try {
            if (this.in_thread != null) {
                this.in_thread.interrupt();
                while (this.in_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
            if (this.out_thread != null) {
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.in_thread = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
    }

    public synchronized void everySecond() {
        this.curr_minute -= this.seconds[this.sec_idx];
        this.seconds[this.sec_idx] = this.curr_second;
        this.curr_second = 0L;
        this.curr_minute += this.seconds[this.sec_idx];
        this.sec_idx = this.sec_idx >= 59 ? 0 : ++this.sec_idx;
    }

    public synchronized void everyMinute() {
        this.curr_hour -= this.minutes[this.min_idx];
        this.minutes[this.min_idx] = this.curr_minute;
        this.curr_hour += this.minutes[this.min_idx];
        this.min_idx = this.min_idx >= 59 ? 0 : ++this.min_idx;
    }

    private void startThreads() {
        if (this.in_thread == null || !this.in_thread.isAlive()) {
            this.stopped = false;
            this.in_thread = new Thread(new QueueListener(this.in_queues, QueueType.IN_QUEUE));
            this.in_thread.setName("in_" + this.name);
            this.in_thread.start();
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.stopped = false;
            this.out_thread = new Thread(new QueueListener(this.out_queues, QueueType.OUT_QUEUE));
            this.out_thread.setName("out_" + this.name);
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
    }

    @Override
    public void start() {
        log.finer(this.getName() + ": starting queue management threads ...");
        this.startThreads();
    }

    public void stop() {
        log.finer(this.getName() + ": stopping queue management threads ...");
        this.stopThreads();
    }

    @Override
    public String getDefHostName() {
        return this.defHostname;
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    public void addRegexRouting(String address) {
        log.fine(this.getName() + " - attempt to add regex routing: " + address);
        this.regexRoutings.add(Pattern.compile(address, 2));
        log.fine(this.getName() + " - success adding regex routing: " + address);
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (!pat.matcher(address).matches()) continue;
            log.finest(this.getName() + " matched against pattern: " + pat.toString());
            return true;
        }
        return false;
    }

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    private class ReceiverTask
    extends TimerTask {
        private ReceiverEventHandler handler = null;
        private Packet packet = null;

        private ReceiverTask(ReceiverEventHandler handler, long delay, TimeUnit unit, Packet packet) {
            this.handler = handler;
            this.packet = packet;
            AbstractMessageReceiver.this.waitingTasks.put(packet.getFrom() + packet.getId(), this);
            AbstractMessageReceiver.this.receiverTasks.schedule((TimerTask)this, unit.toMillis(delay));
        }

        @Override
        public void run() {
            this.handleTimeout();
        }

        public void handleTimeout() {
            AbstractMessageReceiver.this.waitingTasks.remove(this.packet.getFrom() + this.packet.getId());
            this.handler.timeOutExpired(this.packet);
        }

        public void handleResponse(Packet response) {
            this.cancel();
            this.handler.responseReceived(this.packet, response);
        }
    }

    private class QueueListener
    implements Runnable {
        private final EnumMap<Priority, LinkedBlockingQueue<Packet>> queues;
        private QueueType type = null;

        private QueueListener(EnumMap<Priority, LinkedBlockingQueue<Packet>> q, QueueType type) {
            this.queues = q;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Packet packet = null;
            while (!AbstractMessageReceiver.this.stopped) {
                try {
                    int queue_idx = 0;
                    do {
                        LinkedBlockingQueue<Packet> queue = this.queues.get((Object)AbstractMessageReceiver.this.pr_cache[queue_idx]);
                        for (int i = 0; i < queue_idx; ++i) {
                            if (this.queues.get((Object)AbstractMessageReceiver.this.pr_cache[i]).size() <= 0) continue;
                            queue_idx = i;
                            queue = this.queues.get((Object)AbstractMessageReceiver.this.pr_cache[queue_idx]);
                            break;
                        }
                        if ((packet = queue.poll()) != null) {
                            switch (this.type) {
                                case IN_QUEUE: {
                                    long startPPT = System.currentTimeMillis();
                                    ReceiverTask task = (ReceiverTask)AbstractMessageReceiver.this.waitingTasks.remove(packet.getTo() + packet.getId());
                                    if (task != null) {
                                        task.handleResponse(packet);
                                    } else {
                                        AbstractMessageReceiver.this.processPacket(packet);
                                    }
                                    ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[((AbstractMessageReceiver)AbstractMessageReceiver.this).pptIdx] = System.currentTimeMillis() - startPPT;
                                    if (AbstractMessageReceiver.this.pptIdx >= AbstractMessageReceiver.this.processPacketTimings.length - 1) {
                                        AbstractMessageReceiver.this.pptIdx = 0;
                                        break;
                                    }
                                    ++AbstractMessageReceiver.this.pptIdx;
                                    break;
                                }
                                case OUT_QUEUE: {
                                    if (AbstractMessageReceiver.this.parent != null) {
                                        AbstractMessageReceiver.this.parent.addPacket(packet);
                                        break;
                                    }
                                    AbstractMessageReceiver.this.addPacketNB(packet);
                                    break;
                                }
                                default: {
                                    log.severe("Unknown queue element type: " + (Object)((Object)this.type));
                                    break;
                                }
                            }
                            continue;
                        }
                        ++queue_idx;
                    } while (packet != null || queue_idx < AbstractMessageReceiver.this.pr_cache.length);
                    EnumMap<Priority, LinkedBlockingQueue<Packet>> enumMap = this.queues;
                    synchronized (enumMap) {
                        LinkedBlockingQueue<Packet> queue;
                        boolean added = false;
                        Iterator<LinkedBlockingQueue<Packet>> i$ = this.queues.values().iterator();
                        while (i$.hasNext() && !(added = (queue = i$.next()).size() > 0)) {
                        }
                        if (!added) {
                            this.queues.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "[" + AbstractMessageReceiver.this.getName() + "] Exception during packet processing: " + packet.toString(), e);
                }
            }
        }
    }

    private static enum QueueType {
        IN_QUEUE,
        OUT_QUEUE;

    }
}

