/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import tigase.io.SSLContextContainerIfc;

public abstract class TLSUtil {
    private static final Logger log = Logger.getLogger("tigase.io.TLSUtil");
    private static Map<String, SSLContextContainerIfc> sslContexts = new HashMap<String, SSLContextContainerIfc>();

    public static void configureSSLContext(String id, Map<String, String> params) {
        String sslCC_class = params.get("ssl-container-class");
        if (sslCC_class == null) {
            sslCC_class = "tigase.io.SSLContextContainer";
        }
        try {
            SSLContextContainerIfc sslCC = (SSLContextContainerIfc)Class.forName(sslCC_class).newInstance();
            sslCC.init(params);
            sslContexts.put(id, sslCC);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSL Container: " + sslCC_class, e);
        }
    }

    public static SSLContext getSSLContext(String id, String protocol, String hostname) {
        return sslContexts.get(id).getSSLContext(protocol, hostname);
    }
}

