/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import tigase.cluster.ClusteredComponent;
import tigase.server.ServiceChecker;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.util.JIDUtils;
import tigase.xmpp.XMPPIOService;

public class ClientConnectionClustered
extends ClientConnectionManager
implements ClusteredComponent {
    private static final Logger log = Logger.getLogger("tigase.cluster.ClientConnectionClustered");

    @Override
    public void nodesConnected(Set<String> node_hostnames) {
    }

    @Override
    public void nodesDisconnected(Set<String> node_hostnames) {
        log.finest("Disconnected nodes: " + node_hostnames.toString());
        Iterator<String> i$ = node_hostnames.iterator();
        while (i$.hasNext()) {
            String node;
            final String hostname = node = i$.next();
            this.doForAllServices(new ServiceChecker(){

                @Override
                public void check(XMPPIOService service, String serviceId) {
                    String dataReceiver = service.getDataReceiver();
                    log.finest("Checking service for dataReceiver: " + dataReceiver);
                    if (dataReceiver != null && JIDUtils.getNodeHost((String)dataReceiver).equals(hostname)) {
                        log.finest("Stopping service because corresponding cluster node stopped.");
                        service.stop();
                    }
                }
            });
        }
    }
}

