/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class VCardTemp
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String VCARD_KEY = "vCard";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.VCardTemp");
    private static final String XMLNS = "vcard-temp";
    private static final String ID = "vcard-temp";
    private static final String[] ELEMENTS = new String[]{"vCard", "VCARD"};
    private static final String[] XMLNSS = new String[]{"vcard-temp", "vcard-temp"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"vcard-temp"})};
    private static final SimpleParser parser = SingletonFactory.getParserInstance();

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return "vcard-temp";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null && packet.getType() != null && packet.getType() == StanzaType.get) {
            try {
                String strvCard = repo.getPublicData(JIDUtils.getNodeID((String)packet.getElemTo()), "vcard-temp", VCARD_KEY, null);
                if (strvCard != null) {
                    results.offer(this.parseXMLData(strvCard, packet));
                } else {
                    results.offer(packet.okResult((String)null, 1));
                }
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
            return;
        }
        if (session == null) {
            log.info("Session null, dropping packet: " + packet.getStringData());
            return;
        }
        try {
            String id = null;
            if (packet.getElemTo() != null) {
                id = JIDUtils.getNodeID((String)packet.getElemTo());
            }
            if (id == null || id.equals(session.getUserId())) {
                StanzaType type = packet.getType();
                switch (type) {
                    case get: {
                        try {
                            String strvCard = repo.getPublicData(session.getUserId(), "vcard-temp", VCARD_KEY, null);
                            if (strvCard != null) {
                                results.offer(this.parseXMLData(strvCard, packet));
                                break;
                            }
                            results.offer(packet.okResult((String)null, 1));
                        }
                        catch (UserNotFoundException e) {
                            results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
                        }
                        break;
                    }
                    case set: {
                        if (packet.getFrom().equals(session.getConnectionId())) {
                            Element elvCard = packet.getElement().getChild(ELEMENTS[0]);
                            if (elvCard == null) {
                                elvCard = packet.getElement().getChild(ELEMENTS[1]);
                            }
                            if (elvCard != null) {
                                log.finer("Adding vCard: " + elvCard.toString());
                                session.setPublicData("vcard-temp", VCARD_KEY, elvCard.toString());
                            } else {
                                log.finer("Removing vCard");
                                session.removePublicData("vcard-temp", VCARD_KEY);
                            }
                            results.offer(packet.okResult((String)null, 0));
                            break;
                        }
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to set vcard data.", true));
                        break;
                    }
                    case result: 
                    case error: {
                        Element elem = packet.getElement().clone();
                        Packet result = new Packet(elem);
                        result.setTo(session.getConnectionId());
                        result.setFrom(packet.getTo());
                        results.offer(result);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    }
                }
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            e.printStackTrace();
            log.warning("Received vCard request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.warning("Database problem, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 0);
        for (Element el : elems) {
            result.getElement().addChild((XMLNodeIfc)el);
        }
        return result;
    }
}

