/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class RoutingsContainer {
    private static final Logger log = Logger.getLogger("tigase.util.RoutingsContainer");
    private RoutingComputer comp = null;

    public RoutingsContainer(boolean multiMode) {
        this.comp = multiMode ? new MultiMode() : new SingleMode();
    }

    public void addRouting(String pattern, String address) {
        this.comp.addRouting(pattern, address);
    }

    public String computeRouting(String pattern) {
        return this.comp.computeRouting(pattern);
    }

    protected static class MultiMode
    implements RoutingComputer {
        private Map<Pattern, String> routings = new LinkedHashMap<Pattern, String>();
        private String def = null;

        protected MultiMode() {
        }

        @Override
        public void addRouting(String pattern, String address) {
            log.fine("Adding routing: " + pattern + " --> " + address);
            this.routings.put(Pattern.compile(pattern), address);
            if (this.def == null) {
                this.def = address;
            }
        }

        @Override
        public String computeRouting(String address) {
            if (address == null) {
                log.finer("For null address returning default routing: " + this.def);
                return this.def;
            }
            for (Map.Entry<Pattern, String> entry : this.routings.entrySet()) {
                if (!entry.getKey().matcher(address).find()) continue;
                log.finest("For address: " + address + " pattern: " + entry.getKey().pattern() + " matched.");
                return entry.getValue();
            }
            return this.def;
        }
    }

    protected static class SingleMode
    implements RoutingComputer {
        private String routing = null;

        protected SingleMode() {
        }

        @Override
        public void addRouting(String pattern, String address) {
            this.routing = address;
        }

        @Override
        public String computeRouting(String address) {
            return this.routing;
        }
    }

    protected static interface RoutingComputer {
        public void addRouting(String var1, String var2);

        public String computeRouting(String var1);
    }
}

