/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.xmppsession.AbstractAdminCommand;
import tigase.server.xmppsession.AdminScript;

public class AddScriptCommand
extends AbstractAdminCommand {
    @Override
    public void runCommand(Packet packet, Bindings binds, Queue<Packet> results) {
        String language = Command.getFieldValue(packet, "Language");
        String commandId = Command.getFieldValue(packet, "Command Id");
        String description = Command.getFieldValue(packet, "Description");
        String[] scriptText = Command.getFieldValues(packet, "Script text");
        if (this.isEmpty(language) || this.isEmpty(commandId) || this.isEmpty(description) || scriptText == null) {
            results.offer(this.prepareScriptCommand(packet, binds));
        } else {
            StringBuilder sb = new StringBuilder();
            for (String string : scriptText) {
                if (string == null) continue;
                sb.append(string + "\n");
            }
            AdminScript as = new AdminScript();
            as.init(commandId, description, sb.toString(), language);
            Map adminCommands = (Map)binds.get("adminCommands");
            adminCommands.put(as.getCommandId(), as);
            ServiceEntity serviceEntity = (ServiceEntity)binds.get("adminDisco");
            ServiceEntity item = new ServiceEntity(as.getCommandId(), "http://jabber.org/protocol/admin#" + as.getCommandId(), description);
            item.addIdentities(new ServiceIdentity("component", "generic", description), new ServiceIdentity("automation", "command-node", description));
            item.addFeatures(XMPPService.CMD_FEATURES);
            serviceEntity.addItems(item);
            Packet result = packet.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Script loaded successfuly.");
            results.offer(result);
        }
    }

    private Packet prepareScriptCommand(Packet packet, Bindings binds) {
        Packet result = packet.commandResult(Command.DataType.form);
        Command.addFieldValue(result, "Description", "Short description");
        Command.addFieldValue(result, "Command Id", "new-command");
        ScriptEngineManager scriptEngineManager = (ScriptEngineManager)binds.get("scriptManager");
        List<ScriptEngineFactory> scriptFactories = scriptEngineManager.getEngineFactories();
        if (scriptFactories != null) {
            String[] langs = new String[scriptFactories.size()];
            int idx = 0;
            String def = null;
            for (ScriptEngineFactory scriptEngineFactory : scriptFactories) {
                langs[idx++] = scriptEngineFactory.getLanguageName();
                if (!scriptEngineFactory.getLanguageName().equals("groovy")) continue;
                def = "groovy";
            }
            if (def == null) {
                def = langs[0];
            }
            Command.addFieldValue(result, "Language", def, "Language", langs, langs);
        }
        Command.addFieldMultiValue(result, "Script text", Collections.nCopies(1, ""));
        return result;
    }
}

