/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

public class BoshConnectionManager
extends ClientConnectionManager
implements BoshSessionTaskHandler {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshConnectionManager");
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_ENTRY_PROP_VAL = "sess-man@localhost";
    private static final int DEF_PORT_NO = 5280;
    private int[] PORTS = new int[]{5280};
    private long max_wait = 30L;
    private long min_polling = 10L;
    private long max_inactivity = 10L;
    private int concurrent_requests = 2;
    private int hold_requests = 1;
    private long max_pause = 10L;
    private Map<UUID, BoshSession> sessions = new LinkedHashMap<UUID, BoshSession>();
    private Timer boshTasks = new Timer("BoshTasks");

    protected BoshSession getBoshSessionTo(Packet packet) {
        UUID sid = UUID.fromString(JIDUtils.getNodeResource((String)packet.getTo()));
        return this.sessions.get(sid);
    }

    @Override
    protected void writePacketToSocket(Packet packet) {
        BoshSession session = this.getBoshSessionTo(packet);
        if (session != null) {
            LinkedList<Packet> out_results = new LinkedList<Packet>();
            session.processPacket(packet, out_results);
            this.addOutPackets(out_results, session);
        } else {
            log.info("Session does not exist for packet: " + packet.toString());
            try {
                Packet error = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "The user connection is no longer active.", true);
                this.addOutPacket(error);
            }
            catch (PacketErrorTypeException e) {
                log.finest("Ups, already error packet. Dropping it to prevent infinite loop.");
            }
            Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, "bosh-missing-1");
            command2.setFrom(packet.getTo());
            command2.setTo(packet.getFrom());
            log.fine("Sending a command to close the remote session for non-existen Bosh connection: " + command2.toString());
            this.addOutPacket(command2);
        }
    }

    @Override
    protected void processCommand(Packet packet) {
        switch (packet.getCommand()) {
            case CLOSE: {
                BoshSession session = this.getBoshSessionTo(packet);
                if (session != null) {
                    log.fine("Closing session: " + session.getSid());
                    session.close();
                    this.sessions.remove(session.getSid());
                    break;
                }
                log.info("Session does not exist for packet: " + packet.toString());
                break;
            }
            default: {
                super.processCommand(packet);
            }
        }
    }

    @Override
    protected String changeDataReceiver(Packet packet, String newAddress, String command_sessionId, XMPPIOService serv) {
        BoshSession session = this.getBoshSessionTo(packet);
        if (session != null) {
            String sessionId = session.getSessionId();
            if (sessionId.equals(command_sessionId)) {
                String old_receiver = session.getDataReceiver();
                session.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.info("Incorrect session ID, ignoring data redirect for: " + newAddress);
        }
        return null;
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService srv) {
        BoshIOService serv = (BoshIOService)srv;
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
            log.finest("Processing socket data: " + p.toString());
            String sid_str = p.getAttribute("sid");
            UUID sid = null;
            try {
                LinkedList<Packet> out_results = new LinkedList<Packet>();
                BoshSession bs = null;
                if (sid_str == null) {
                    String hostname = p.getAttribute("to");
                    if (hostname != null && this.isLocalDomain(hostname)) {
                        bs = new BoshSession(this.getDefHostName(), this.routings.computeRouting(hostname), this);
                        sid = bs.getSid();
                        this.sessions.put(sid, bs);
                        bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, out_results);
                    } else {
                        log.info("Invalid hostname. Closing invalid connection");
                        serv.sendErrorAndStop(Authorization.NOT_ALLOWED, p, "Invalid hostname.");
                    }
                } else {
                    sid = UUID.fromString(sid_str);
                    bs = this.sessions.get(sid);
                    if (bs != null) {
                        bs.processSocketPacket(p, serv, out_results);
                    } else {
                        log.info("There is no session with given SID. Closing invalid connection");
                        serv.sendErrorAndStop(Authorization.ITEM_NOT_FOUND, p, "Invalid SID");
                    }
                }
                this.addOutPackets(out_results, bs);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid, e);
            }
        }
        return null;
    }

    private void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setFrom(this.getFromAddress(bs.getSid().toString()));
            res.setTo(bs.getDataReceiver());
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    private String getFromAddress(String id) {
        return JIDUtils.getJID((String)this.getName(), (String)this.getDefHostName(), (String)id);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put("max-wait", 30L);
        props.put("min-polling", 10L);
        props.put("max-inactivity", 10L);
        props.put("concurrent-requests", 2);
        props.put("hold-requests", 1);
        props.put("max-inactivity", 10L);
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.max_wait = (Long)props.get("max-wait");
        this.min_polling = (Long)props.get("min-polling");
        this.max_inactivity = (Long)props.get("max-inactivity");
        this.concurrent_requests = (Integer)props.get("concurrent-requests");
        this.hold_requests = (Integer)props.get("hold-requests");
        this.max_pause = (Long)props.get("max-inactivity");
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    public void serviceStopped(BoshIOService service) {
        BoshSession bs;
        super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            bs.disconnected(service);
        }
    }

    @Override
    public void serviceStarted(BoshIOService service) {
        super.serviceStarted(service);
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    public void xmppStreamClosed(BoshIOService serv) {
        log.finer("Stream closed.");
    }

    @Override
    public String xmppStreamOpened(BoshIOService serv, Map<String, String> attribs) {
        log.fine("Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port as Bosh yet.");
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='1' from='" + this.getDefHostName() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<invalid-namespace xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "<text xmlns='urn:ietf:params:xml:ns:xmpp-streams' xml:lang='langcode'>" + "Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port... yet." + "</text>" + "</stream:error>" + "</stream:stream>";
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService();
    }

    @Override
    public void writeRawData(BoshIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public TimerTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs);
        this.boshTasks.schedule((TimerTask)bt, delay);
        return bt;
    }

    @Override
    public void cancelTask(TimerTask tt) {
        tt.cancel();
    }

    private class BoshTask
    extends TimerTask {
        private BoshSession bs = null;

        public BoshTask(BoshSession bs) {
            this.bs = bs;
        }

        @Override
        public void run() {
            LinkedList<Packet> out_results = new LinkedList<Packet>();
            if (this.bs.task(out_results, this)) {
                BoshConnectionManager.this.sessions.remove(this.bs.getSid());
            }
            BoshConnectionManager.this.addOutPackets(out_results, this.bs);
        }
    }
}

