/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSUtil;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.SocketReadThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ServiceChecker;
import tigase.stats.StatRecord;
import tigase.util.JIDUtils;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;

public abstract class ConnectionManager<IO extends XMPPIOService>
extends AbstractMessageReceiver
implements XMPPIOServiceListener {
    private static final Logger log = Logger.getLogger("tigase.server.ConnectionManager");
    protected static final String PORT_KEY = "port-no";
    protected static final String PROP_KEY = "connections/";
    protected static final String PORTS_PROP_KEY = "connections/ports";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    private static final String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_REMOTE_HOST_PROP_KEY = "remote-host";
    protected static final String PORT_REMOTE_HOST_PROP_VAL = "localhost";
    protected static final String TLS_PROP_KEY = "connections/tls/";
    protected static final String TLS_USE_PROP_KEY = "connections/tls/use";
    protected static final boolean TLS_USE_PROP_VAL = true;
    protected static final String TLS_REQUIRED_PROP_KEY = "connections/tls/required";
    protected static final boolean TLS_REQUIRED_PROP_VAL = false;
    protected static final String TLS_KEYS_STORE_PROP_KEY = "connections/tls/keys-store";
    protected static final String TLS_KEYS_STORE_PROP_VAL = SSLContextContainerIfc.JKS_KEYSTORE_FILE_VAL;
    protected static final String TLS_DEF_CERT_PROP_KEY = "connections/tls/def-cert-alias";
    protected static final String TLS_DEF_CERT_PROP_VAL = "default";
    protected static final String TLS_KEYS_STORE_PASSWD_PROP_KEY = "connections/tls/keys-store-password";
    protected static final String TLS_KEYS_STORE_PASSWD_PROP_VAL = "keystore";
    protected static final String TLS_TRUSTS_STORE_PASSWD_PROP_KEY = "connections/tls/trusts-store-password";
    protected static final String TLS_TRUSTS_STORE_PASSWD_PROP_VAL = "truststore";
    protected static final String TLS_TRUSTS_STORE_PROP_KEY = "connections/tls/trusts-store";
    protected static final String TLS_TRUSTS_STORE_PROP_VAL = SSLContextContainerIfc.TRUSTSTORE_FILE_VAL;
    protected static final String TLS_CONTAINER_CLASS_PROP_KEY = "connections/tls/ssl-container-class";
    protected static final String TLS_CONTAINER_CLASS_PROP_VAL = "tigase.io.SSLContextContainer";
    protected static final String TLS_SERVER_CERTS_DIR_PROP_KEY = "connections/tls/server-certs-dir";
    protected static final String TLS_SERVER_CERTS_DIR_PROP_VAL = "certs/";
    protected static final String TLS_TRUSTED_CERTS_DIR_PROP_KEY = "connections/tls/trusted-certs-dir";
    protected static final String TLS_TRUSTED_CERTS_DIR_PROP_VAL = "/etc/ssl/certs";
    protected static final String TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY = "connections/tls/allow-self-signed-certs";
    protected static final String TLS_ALLOW_SELF_SIGNED_CERTS_PROP_VAL = "true";
    protected static final String TLS_ALLOW_INVALID_CERTS_PROP_KEY = "connections/tls/allow-invalid-certs";
    protected static final String TLS_ALLOW_INVALID_CERTS_PROP_VAL = "false";
    protected static final String MAX_RECONNECTS_PROP_KEY = "max-reconnects";
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    private static SocketReadThread readThread = SocketReadThread.getInstance();
    private Timer delayedTasks = null;
    private Thread watchdog = null;
    private long watchdogRuns = 0L;
    private long watchdogTests = 0L;
    private long watchdogStopped = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private Map<String, IO> services = new ConcurrentSkipListMap<String, IO>();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    protected long connectionDelay = 2000L;
    private boolean initializationCompleted = false;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.watchdog = new Thread((Runnable)new Watchdog(), "Watchdog - " + name);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    @Override
    public void initializationCompleted() {
        this.initializationCompleted = true;
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, this.connectionDelay);
        }
        this.waitingTasks.clear();
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (this.initializationCompleted) {
            this.reconnectService(conn, this.connectionDelay);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(TLS_USE_PROP_KEY, true);
        props.put(TLS_DEF_CERT_PROP_KEY, TLS_DEF_CERT_PROP_VAL);
        props.put(TLS_KEYS_STORE_PROP_KEY, TLS_KEYS_STORE_PROP_VAL);
        props.put(TLS_KEYS_STORE_PASSWD_PROP_KEY, TLS_KEYS_STORE_PASSWD_PROP_VAL);
        props.put(TLS_TRUSTS_STORE_PROP_KEY, TLS_TRUSTS_STORE_PROP_VAL);
        props.put(TLS_TRUSTS_STORE_PASSWD_PROP_KEY, TLS_TRUSTS_STORE_PASSWD_PROP_VAL);
        props.put(TLS_SERVER_CERTS_DIR_PROP_KEY, TLS_SERVER_CERTS_DIR_PROP_VAL);
        props.put(TLS_TRUSTED_CERTS_DIR_PROP_KEY, TLS_TRUSTED_CERTS_DIR_PROP_VAL);
        props.put(TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY, TLS_ALLOW_SELF_SIGNED_CERTS_PROP_VAL);
        props.put(TLS_ALLOW_INVALID_CERTS_PROP_KEY, TLS_ALLOW_INVALID_CERTS_PROP_VAL);
        if (params.get("--ssl-container-class") != null) {
            props.put(TLS_CONTAINER_CLASS_PROP_KEY, (String)params.get("--ssl-container-class"));
        } else {
            props.put(TLS_CONTAINER_CLASS_PROP_KEY, TLS_CONTAINER_CLASS_PROP_VAL);
        }
        int ports_size = 0;
        int[] ports = (int[])params.get(this.getName() + "/" + PORTS_PROP_KEY);
        if (ports != null) {
            for (int port : ports) {
                this.putDefPortParams(props, port, SocketType.plain);
            }
            props.put(PORTS_PROP_KEY, ports);
        } else {
            int[] ssls;
            int[] plains = this.getDefPlainPorts();
            if (plains != null) {
                ports_size += plains.length;
            }
            if ((ssls = this.getDefSSLPorts()) != null) {
                ports_size += ssls.length;
            }
            if (ports_size > 0) {
                ports = new int[ports_size];
            }
            if (ports != null) {
                int i;
                int idx = 0;
                if (plains != null) {
                    idx = plains.length;
                    for (i = 0; i < idx; ++i) {
                        ports[i] = plains[i];
                        this.putDefPortParams(props, ports[i], SocketType.plain);
                    }
                }
                if (ssls != null) {
                    for (i = idx; i < idx + ssls.length; ++i) {
                        ports[i] = ssls[i - idx];
                        this.putDefPortParams(props, ports[i], SocketType.ssl);
                    }
                }
                props.put(PORTS_PROP_KEY, ports);
            }
        }
        return props;
    }

    private void putDefPortParams(Map<String, Object> props, int port, SocketType sock) {
        props.put(PROP_KEY + port + "/" + PORT_TYPE_PROP_KEY, (Object)ConnectionType.accept);
        props.put(PROP_KEY + port + "/" + PORT_SOCKET_PROP_KEY, (Object)sock);
        props.put(PROP_KEY + port + "/" + PORT_IFC_PROP_KEY, PORT_IFC_PROP_VAL);
        props.put(PROP_KEY + port + "/" + PORT_REMOTE_HOST_PROP_KEY, PORT_REMOTE_HOST_PROP_VAL);
        props.put(PROP_KEY + port + "/" + TLS_REQUIRED_PROP_KEY, false);
        Map<String, Object> extra = this.getParamsForPort(port);
        if (extra != null) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                props.put(PROP_KEY + port + "/" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener(cli);
        }
        this.pending_open.clear();
    }

    @Override
    public void release() {
        this.delayedTasks.cancel();
        this.releaseListeners();
        super.release();
    }

    @Override
    public void start() {
        super.start();
        this.delayedTasks = new Timer(this.getName() + " - delayed connections", true);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.releaseListeners();
        int[] ports = (int[])props.get(PORTS_PROP_KEY);
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(PROP_KEY + ports[i])) continue;
                    int idx = entry.getKey().lastIndexOf(47);
                    String key = entry.getKey().substring(idx + 1);
                    log.config("Adding port property key: " + key + "=" + entry.getValue());
                    port_props.put(key, entry.getValue());
                }
                port_props.put(PORT_KEY, ports[i]);
                this.addWaitingTask(port_props);
            }
        }
        if (((Boolean)props.get(TLS_USE_PROP_KEY)).booleanValue()) {
            LinkedHashMap<String, String> tls_params = new LinkedHashMap<String, String>();
            tls_params.put("ssl-container-class", (String)props.get(TLS_CONTAINER_CLASS_PROP_KEY));
            tls_params.put("def-cert-alias", (String)props.get(TLS_DEF_CERT_PROP_KEY));
            tls_params.put("keys-store", (String)props.get(TLS_KEYS_STORE_PROP_KEY));
            tls_params.put("keys-store-password", (String)props.get(TLS_KEYS_STORE_PASSWD_PROP_KEY));
            tls_params.put("trusts-store", (String)props.get(TLS_TRUSTS_STORE_PROP_KEY));
            tls_params.put("trusts-store-password", (String)props.get(TLS_TRUSTS_STORE_PASSWD_PROP_KEY));
            tls_params.put("server-certs-dir", (String)props.get(TLS_SERVER_CERTS_DIR_PROP_KEY));
            tls_params.put("trusted-certs-dir", (String)props.get(TLS_TRUSTED_CERTS_DIR_PROP_KEY));
            tls_params.put("allow-self-signed-certs", (String)props.get(TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY));
            tls_params.put("allow-invalid-certs", (String)props.get(TLS_ALLOW_INVALID_CERTS_PROP_KEY));
            TLSUtil.configureSSLContext(this.getName(), tls_params);
        }
    }

    private void startService(Map<String, Object> port_props) {
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener(cli);
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        log.finer("Reconnecting service for: " + this.getName() + ", scheduling next try in " + delay / 1000L + "secs");
        this.delayedTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                String host = (String)port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
                if (host == null) {
                    host = (String)port_props.get("remote-hostname");
                }
                int port = (Integer)port_props.get(ConnectionManager.PORT_KEY);
                log.fine("Reconnecting service for component: " + ConnectionManager.this.getName() + ", to remote host: " + host + " on port: " + port);
                ConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    protected int[] getDefPlainPorts() {
        return null;
    }

    protected int[] getDefSSLPorts() {
        return null;
    }

    protected Map<String, Object> getParamsForPort(int port) {
        return null;
    }

    @Override
    public void packetsReady(IOService s) throws IOException {
        log.finest("packetsReady called");
        XMPPIOService serv = (XMPPIOService)s;
        this.packetsReady((IO)serv);
    }

    public void packetsReady(IO serv) throws IOException {
        this.writePacketsToSocket(serv, this.processSocketData(serv));
    }

    public void writePacketsToSocket(IO serv, Queue<Packet> packets) {
        if (packets != null && packets.size() > 0) {
            Packet p = null;
            while ((p = packets.poll()) != null) {
                ((XMPPIOService)serv).addPacketToSend(p);
            }
            try {
                ((XMPPIOService)serv).processWaitingPackets();
                readThread.addSocketService((IOService)serv);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception during writing packets: ", e);
                try {
                    ((XMPPIOService)serv).stop();
                }
                catch (Exception e1) {
                    log.log(Level.WARNING, "Exception stopping XMPPIOService: ", e1);
                }
            }
        }
    }

    public boolean writePacketToSocket(IO ios, Packet p) {
        if (ios != null) {
            ((XMPPIOService)ios).addPacketToSend(p);
            try {
                ((XMPPIOService)ios).processWaitingPackets();
                readThread.addSocketService((IOService)ios);
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception during writing packets: ", e);
                try {
                    ((XMPPIOService)ios).stop();
                }
                catch (Exception e1) {
                    log.log(Level.WARNING, "Exception stopping XMPPIOService: ", e1);
                }
            }
        } else {
            log.info("Can't find service for packet: [" + p.getElemName() + "] " + p.getTo() + ", service id: " + this.getServiceId(p));
        }
        return false;
    }

    protected void writeRawData(IO ios, String data) {
        try {
            ((XMPPIOService)ios).writeRawData(data);
            readThread.addSocketService((IOService)ios);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception during writing data: " + data, e);
            try {
                ((XMPPIOService)ios).stop();
            }
            catch (Exception e1) {
                log.log(Level.WARNING, "Exception stopping XMPPIOService: ", e1);
            }
        }
    }

    protected void writePacketToSocket(Packet p) {
        log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
        log.finest("Writing packet to: " + p.getTo());
        IO ios = this.getXMPPIOService(p);
        this.writePacketToSocket(ios, p);
    }

    protected void writePacketToSocket(Packet p, String serviceId) {
        log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
        log.finest("Writing packet to: " + p.getTo());
        IO ios = this.getXMPPIOService(serviceId);
        this.writePacketToSocket(ios, p);
    }

    protected IO getXMPPIOService(String serviceId) {
        return (IO)((XMPPIOService)this.services.get(serviceId));
    }

    protected IO getXMPPIOService(Packet p) {
        return (IO)((XMPPIOService)this.services.get(this.getServiceId(p)));
    }

    @Override
    public void processPacket(Packet packet) {
        this.writePacketToSocket(packet);
    }

    public abstract Queue<Packet> processSocketData(IO var1);

    @Override
    public void serviceStopped(IOService s) {
        XMPPIOService ios = (XMPPIOService)s;
        this.serviceStopped((IO)ios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStopped(IO service) {
        IO IO = service;
        synchronized (IO) {
            XMPPIOService serv;
            String id = this.getUniqueId(service);
            log.finer("[[" + this.getName() + "]] Connection stopped: " + id);
            XMPPIOService xMPPIOService = serv = id != null ? (XMPPIOService)this.services.get(id) : null;
            if (serv == service) {
                this.services.remove(id);
            } else if (id != null) {
                log.warning("[[" + this.getName() + "]] Attempt to stop incorrect service: " + id);
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted(IO service) {
        Map<String, IO> map = this.services;
        synchronized (map) {
            String id = this.getUniqueId(service);
            log.finer("[[" + this.getName() + "]] Connection started: " + id);
            XMPPIOService serv = (XMPPIOService)this.services.get(id);
            if (serv != null) {
                if (serv == service) {
                    log.warning(this.getName() + ": That would explain a lot, adding the same service twice, ID: " + id);
                } else {
                    log.warning(this.getName() + ": Attempt to add different service with the same ID: " + id);
                    serv.stop();
                }
            }
            this.services.put(id, service);
        }
    }

    protected String getUniqueId(IO serv) {
        return ((IOService)serv).getUniqueId();
    }

    protected String getServiceId(Packet packet) {
        return JIDUtils.getNodeResource((String)packet.getTo());
    }

    @Override
    public void streamClosed(XMPPIOService s) {
        XMPPIOService serv = s;
        this.xmppStreamClosed(serv);
    }

    public abstract void xmppStreamClosed(IO var1);

    @Override
    public String streamOpened(XMPPIOService s, Map<String, String> attribs) {
        XMPPIOService serv = s;
        return this.xmppStreamOpened(serv, attribs);
    }

    public abstract String xmppStreamOpened(IO var1, Map<String, String> var2);

    protected int countIOServices() {
        return this.services.size();
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        stats.add(new StatRecord(this.getName(), "Open connections", "int", this.services.size(), Level.FINE));
        stats.add(new StatRecord(this.getName(), "Watchdog runs", "long", this.watchdogRuns, Level.FINE));
        stats.add(new StatRecord(this.getName(), "Watchdog tests", "long", this.watchdogTests, Level.FINE));
        stats.add(new StatRecord(this.getName(), "Watchdog stopped", "long", this.watchdogStopped, Level.FINE));
        return stats;
    }

    protected abstract IO getXMPPIOServiceInstance();

    protected void doForAllServices(ServiceChecker checker) {
        for (XMPPIOService service : this.services.values()) {
            checker.check(service, this.getUniqueId(service));
        }
    }

    protected abstract long getMaxInactiveTime();

    private class Watchdog
    implements Runnable {
        private Watchdog() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(600000L);
                        ++ConnectionManager.this.watchdogRuns;
                        ConnectionManager.this.doForAllServices(new ServiceChecker(){

                            @Override
                            public void check(XMPPIOService service, String serviceId) {
                                long curr_time = System.currentTimeMillis();
                                long lastTransfer = service.getLastTransferTime();
                                try {
                                    if (curr_time - lastTransfer >= ConnectionManager.this.getMaxInactiveTime()) {
                                        log.info(ConnectionManager.this.getName() + ": Max inactive time exceeded, stopping: " + serviceId);
                                        ++ConnectionManager.this.watchdogStopped;
                                        service.stop();
                                    } else if (curr_time - lastTransfer >= 1740000L) {
                                        service.writeRawData(" ");
                                        ++ConnectionManager.this.watchdogTests;
                                    }
                                }
                                catch (Exception e) {
                                    try {
                                        if (service != null) {
                                            log.info(ConnectionManager.this.getName() + "Found dead connection, stopping: " + serviceId);
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.stop();
                                        }
                                    }
                                    catch (Exception ignore) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        private ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        @Override
        public int getPort() {
            return (Integer)this.port_props.get(ConnectionManager.PORT_KEY);
        }

        @Override
        public String[] getIfcs() {
            return (String[])this.port_props.get(ConnectionManager.PORT_IFC_PROP_KEY);
        }

        @Override
        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(ConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(ConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf(type);
        }

        public SocketType getSocketType() {
            return SocketType.valueOf(this.port_props.get(ConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        @Override
        public void accept(SocketChannel sc) {
            Object serv = ConnectionManager.this.getXMPPIOServiceInstance();
            ((IOService)serv).setSSLId(ConnectionManager.this.getName());
            ((XMPPIOService)serv).setIOServiceListener(ConnectionManager.this);
            ((IOService)serv).setSessionData(this.port_props);
            try {
                ((IOService)serv).accept(sc);
                if (this.getSocketType() == SocketType.ssl) {
                    ((IOService)serv).startSSL(false);
                }
                ConnectionManager.this.serviceStarted(serv);
                readThread.addSocketService((IOService)serv);
            }
            catch (SocketException e) {
                int recon;
                log.log(Level.FINEST, "Problem reconnecting the service: ", e);
                Integer reconnects = (Integer)this.port_props.get(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
                if (reconnects != null && (recon = reconnects.intValue()) != 0) {
                    this.port_props.put(ConnectionManager.MAX_RECONNECTS_PROP_KEY, --recon);
                    ConnectionManager.this.reconnectService(this.port_props, ConnectionManager.this.connectionDelay);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not accept connection.", e);
                ((XMPPIOService)serv).stop();
            }
        }
    }
}

