/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;

public enum Command {
    STREAM_OPENED,
    STREAM_CLOSED,
    STARTTLS,
    GETFEATURES,
    GETDISCO,
    CLOSE,
    GETSTATS,
    USER_STATUS,
    BROADCAST_TO_ONLINE,
    BROADCAST_TO_ALL,
    REDIRECT,
    VHOSTS_RELOAD,
    VHOSTS_UPDATE,
    VHOSTS_REMOVE,
    OTHER;

    private static final Logger log;
    public static final String XMLNS = "http://jabber.org/protocol/commands";
    public static final String COMMAND_EL = "command";

    public static Command valueof(String cmd) {
        try {
            return Command.valueOf(cmd);
        }
        catch (Exception e) {
            return OTHER;
        }
    }

    public Packet getPacket(String from, String to, StanzaType type, String id) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), null);
        return new Packet(elem);
    }

    public Packet getPacket(String from, String to, StanzaType type, String id, DataType data_type) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), data_type);
        return new Packet(elem);
    }

    private static Element addDataForm(Element command2, DataType data_type) {
        Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", data_type.name()});
        command2.addChild((XMLNodeIfc)x);
        return x;
    }

    private static void setStatusEl(Element iq, Status status) {
        Element command2 = iq.getChild(COMMAND_EL);
        command2.setAttribute("status", status.name());
    }

    private static void addActionEl(Element iq, Action action) {
        Element command2 = iq.getChild(COMMAND_EL);
        Element actions = command2.getChild("actions");
        if (actions == null) {
            actions = new Element("actions", new String[]{Action.execute.toString()}, new String[]{action.toString()});
            command2.addChild((XMLNodeIfc)actions);
        }
        actions.addChild((XMLNodeIfc)new Element(action.toString()));
    }

    private static Element createCommandEl(String from, String to, StanzaType type, String id, String node, DataType data_type) {
        Element iq = new Element("iq", new String[]{"type", "id"}, new String[]{type.toString(), id});
        if (from != null) {
            iq.setAttribute("from", from);
        }
        if (to != null) {
            iq.setAttribute("to", to);
        }
        Element command2 = new Element(COMMAND_EL, new String[]{"xmlns", "node"}, new String[]{XMLNS, node});
        iq.addChild((XMLNodeIfc)command2);
        if (data_type != null) {
            Command.addDataForm(command2, data_type);
            if (data_type == DataType.result) {
                Command.setStatusEl(iq, Status.completed);
            }
            if (data_type == DataType.form) {
                Command.setStatusEl(iq, Status.executing);
                Command.addActionEl(iq, Action.complete);
            }
        }
        return iq;
    }

    public static Element createIqCommand(String from, String to, StanzaType type, String id, String node, DataType data_type) {
        Element iq = Command.createCommandEl(from, to, type, id, node, data_type);
        return iq;
    }

    public static void setStatus(Packet packet, Status status) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.setAttribute("status", status.toString());
    }

    public static void addAction(Packet packet, Action action) {
        Command.addActionEl(packet.getElement(), action);
    }

    public static Action getAction(Packet packet) {
        String action = packet.getElement().getAttribute("/iq/command", "action");
        try {
            return Action.valueOf(action);
        }
        catch (Exception e) {
            return Action.other;
        }
    }

    public static void addNote(Packet packet, String note) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element notes = command2.getChild("note");
        if (notes == null) {
            notes = new Element("note", new String[]{"type"}, new String[]{"info"});
            command2.addChild((XMLNodeIfc)notes);
        }
        notes.setCData(XMLUtils.escape((String)note));
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new Element[]{new Element("value", XMLUtils.escape((String)f_value))}, new String[]{"var"}, new String[]{XMLUtils.escape((String)f_name)});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldMultiValue(Packet packet, String f_name, List<String> f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        if (f_value != null && f_value.size() > 0) {
            Element field = new Element("field", new String[]{"var", "type"}, new String[]{XMLUtils.escape((String)f_name), "text-multi"});
            for (String val : f_value) {
                Element value = new Element("value", XMLUtils.escape((String)val));
                field.addChild((XMLNodeIfc)value);
            }
            x.addChild((XMLNodeIfc)field);
        }
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new Element[]{new Element("value", XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), "list-single", XMLUtils.escape((String)label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element("value", XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Packet packet, String f_name, String[] f_values, String label, String[] labels, String[] options) {
        int i;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), "list-multi", XMLUtils.escape((String)label)});
        for (i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element("value", XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        for (i = 0; i < f_values.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("value", XMLUtils.escape((String)f_values[i])));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new Element[]{new Element("value", XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), type, XMLUtils.escape((String)label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element("value", XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addTextField(Packet packet, String t_name, String t_value) {
        Command.addFieldValue(packet, t_name, t_value, "fixed");
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new Element[]{new Element("value", XMLUtils.escape((String)f_value))}, new String[]{"var", "type"}, new String[]{XMLUtils.escape((String)f_name), type});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type, String label) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element("field", new Element[]{new Element("value", XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), type, XMLUtils.escape((String)label)});
        x.addChild((XMLNodeIfc)field);
    }

    public static void setData(Packet packet, Element data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.addChild((XMLNodeIfc)data);
    }

    public static void setData(Packet packet, List<Element> data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.addChildren(data);
    }

    public static String getFieldValue(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                String value;
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name) || (value = child.getChildCData("/field/value")) == null) continue;
                return XMLUtils.unescape((String)value);
            }
        }
        return null;
    }

    public static String[] getFieldValues(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name)) continue;
                LinkedList<String> values = new LinkedList<String>();
                List val_children = child.getChildren();
                for (Element val_child : val_children) {
                    String value;
                    if (!val_child.getName().equals("value") || (value = val_child.getCData()) == null) continue;
                    values.add(XMLUtils.unescape((String)value));
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean removeFieldValue(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name)) continue;
                return x.removeChild(child);
            }
        }
        return false;
    }

    public static String getFieldValue(Packet packet, String f_name, boolean debug) {
        Element iq = packet.getElement();
        log.info("Command iq: " + iq.toString());
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        log.info("Command command: " + command2.toString());
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            log.info("Command x: NULL");
            return null;
        }
        log.info("Command x: " + x.toString());
        List children = x.getChildren();
        for (Element child : children) {
            log.info("Command form child: " + child.toString());
            if (child.getName().equals("field") && child.getAttribute("var").equals(f_name)) {
                String value = child.getChildCData("/field/value");
                log.info("Command found: field=" + f_name + ", value=" + value);
                if (value == null) continue;
                return XMLUtils.unescape((String)value);
            }
            log.info("Command not found: field=" + f_name + ", value=" + child.getChildCData("/field/value"));
        }
        return null;
    }

    public static List<Element> getData(Packet packet) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        return command2.getChildren();
    }

    public static Element getData(Packet packet, String el_name, String xmlns) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        return command2.getChild(el_name, xmlns);
    }

    static {
        log = Logger.getLogger("tigase.server.Command");
    }

    public static enum DataType {
        result,
        form,
        submit;

    }

    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete,
        other;

    }

    public static enum Status {
        executing,
        completed,
        canceled,
        other;

    }
}

