/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.conf.Configurable;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;

public abstract class AbstractMessageReceiver
implements StatisticsContainer,
MessageReceiver,
Configurable,
VHostListener {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private String DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 100000L).intValue();
    private static final Logger log = Logger.getLogger("tigase.abstract.AbstractMessageReceiver");
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private String defHostname = this.DEF_HOSTNAME_PROP_VAL;
    private MessageReceiver parent = null;
    private LinkedBlockingQueue<Packet> in_queue = new LinkedBlockingQueue(this.maxQueueSize);
    private LinkedBlockingQueue<Packet> out_queue = new LinkedBlockingQueue(this.maxQueueSize);
    private Timer receiverTasks = null;
    private Thread in_thread = null;
    private Thread out_thread = null;
    private boolean stopped = false;
    private String name = null;
    protected VHostManagerIfc vHostManager = null;
    private Set<Pattern> regexRoutings = new CopyOnWriteArraySet<Pattern>();
    private long curr_second = 0L;
    private long curr_minute = 0L;
    private long curr_hour = 0L;
    private long[] seconds = new long[60];
    private int sec_idx = 0;
    private long[] minutes = new long[60];
    private int min_idx = 0;
    private String compId = null;
    private long[] processPacketTimings = new long[100];
    private int pptIdx = 0;
    private long statReceivedMessagesOk = 0L;
    private long statSentMessagesOk = 0L;
    private long statReceivedMessagesEr = 0L;
    private long statSentMessagesEr = 0L;

    @Override
    public String getComponentId() {
        return this.compId;
    }

    @Override
    public void initializationCompleted() {
    }

    @Override
    public boolean addPacketNB(Packet packet) {
        boolean result;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        if (result = this.in_queue.offer(packet)) {
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        } else {
            ++this.statReceivedMessagesEr;
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            this.in_queue.put(packet);
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        }
        catch (InterruptedException e) {
            ++this.statReceivedMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        boolean result;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        if (result = this.out_queue.offer(packet)) {
            ++this.statSentMessagesOk;
        } else {
            ++this.statSentMessagesEr;
        }
        return result;
    }

    protected boolean addOutPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            this.out_queue.put(packet);
            ++this.statSentMessagesOk;
        }
        catch (InterruptedException e) {
            ++this.statSentMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    public abstract void processPacket(Packet var1);

    @Override
    public List<StatRecord> getStatistics() {
        LinkedList<StatRecord> stats = new LinkedList<StatRecord>();
        stats.add(new StatRecord(this.getName(), "Last second packets", "int", this.seconds[this.sec_idx == 0 ? 59 : this.sec_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last minute packets", "int", this.minutes[this.min_idx == 0 ? 59 : this.min_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last hour packets", "int", this.curr_hour, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MSG_RECEIVED_OK, this.statReceivedMessagesOk, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MSG_SENT_OK, this.statSentMessagesOk, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.QUEUE_WAITING, this.in_queue.size() + this.out_queue.size(), Level.FINEST));
        stats.add(new StatRecord(this.getName(), StatisticType.MAX_QUEUE_SIZE, this.maxQueueSize, Level.FINEST));
        stats.add(new StatRecord(this.getName(), StatisticType.IN_QUEUE_OVERFLOW, this.statReceivedMessagesEr, Level.FINEST));
        stats.add(new StatRecord(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW, this.statSentMessagesEr, Level.FINEST));
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        stats.add(new StatRecord(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", "long", res / (long)this.processPacketTimings.length, Level.FINEST));
        return stats;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        int queueSize = (Integer)props.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.setMaxQueueSize(queueSize);
        this.defHostname = (String)props.get("def-hostname");
        this.compId = (String)props.get("component-id");
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (this.maxQueueSize != maxQueueSize) {
            LinkedBlockingQueue<Packet> newQueue;
            this.stopThreads();
            this.maxQueueSize = maxQueueSize;
            if (this.in_queue != null) {
                newQueue = new LinkedBlockingQueue<Packet>(maxQueueSize);
                newQueue.addAll(this.in_queue);
                this.in_queue = newQueue;
            }
            if (this.out_queue != null) {
                newQueue = new LinkedBlockingQueue(maxQueueSize);
                newQueue.addAll(this.out_queue);
                this.out_queue = newQueue;
            }
            this.startThreads();
        }
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String queueSize = (String)params.get("--max-queue-size");
        int queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
        if (queueSize != null) {
            try {
                queueSizeInt = Integer.parseInt(queueSize);
            }
            catch (NumberFormatException e) {
                queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
            }
        }
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getMaxQueueSize(queueSizeInt));
        this.DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        defs.put("component-id", this.compId);
        return defs;
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.compId = JIDUtils.getNodeID((String)name, (String)this.defHostname);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void stopThreads() {
        this.stopped = true;
        try {
            if (this.in_thread != null) {
                this.in_thread.interrupt();
                while (this.in_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
            if (this.out_thread != null) {
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.in_thread = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
    }

    public synchronized void everySecond() {
        this.curr_minute -= this.seconds[this.sec_idx];
        this.seconds[this.sec_idx] = this.curr_second;
        this.curr_second = 0L;
        this.curr_minute += this.seconds[this.sec_idx];
        this.sec_idx = this.sec_idx >= 59 ? 0 : ++this.sec_idx;
    }

    public synchronized void everyMinute() {
        this.curr_hour -= this.minutes[this.min_idx];
        this.minutes[this.min_idx] = this.curr_minute;
        this.curr_hour += this.minutes[this.min_idx];
        this.min_idx = this.min_idx >= 59 ? 0 : ++this.min_idx;
    }

    private void startThreads() {
        if (this.in_thread == null || !this.in_thread.isAlive()) {
            this.stopped = false;
            this.in_thread = new Thread(new QueueListener(this.in_queue, QueueType.IN_QUEUE));
            this.in_thread.setName("in_" + this.name);
            this.in_thread.start();
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.stopped = false;
            this.out_thread = new Thread(new QueueListener(this.out_queue, QueueType.OUT_QUEUE));
            this.out_thread.setName("out_" + this.name);
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
    }

    @Override
    public void start() {
        log.finer(this.getName() + ": starting queue management threads ...");
        this.startThreads();
    }

    public void stop() {
        log.finer(this.getName() + ": stopping queue management threads ...");
        this.stopThreads();
    }

    @Override
    public String getDefHostName() {
        return this.defHostname;
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    public void addRegexRouting(String address) {
        log.fine(this.getName() + " - attempt to add regex routing: " + address);
        this.regexRoutings.add(Pattern.compile(address, 2));
        log.fine(this.getName() + " - success adding regex routing: " + address);
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (!pat.matcher(address).matches()) continue;
            log.finest(this.getName() + " matched against pattern: " + pat.toString());
            return true;
        }
        return false;
    }

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    private class QueueListener
    implements Runnable {
        private LinkedBlockingQueue<Packet> queue = null;
        private QueueType type = null;

        private QueueListener(LinkedBlockingQueue<Packet> q, QueueType type) {
            this.queue = q;
            this.type = type;
        }

        @Override
        public void run() {
            Packet packet = null;
            block7: while (!AbstractMessageReceiver.this.stopped) {
                try {
                    packet = this.queue.take();
                    switch (this.type) {
                        case IN_QUEUE: {
                            long startPPT = System.currentTimeMillis();
                            AbstractMessageReceiver.this.processPacket(packet);
                            ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[((AbstractMessageReceiver)AbstractMessageReceiver.this).pptIdx] = System.currentTimeMillis() - startPPT;
                            if (AbstractMessageReceiver.this.pptIdx >= AbstractMessageReceiver.this.processPacketTimings.length - 1) {
                                AbstractMessageReceiver.this.pptIdx = 0;
                                continue block7;
                            }
                            ++AbstractMessageReceiver.this.pptIdx;
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            if (AbstractMessageReceiver.this.parent != null) {
                                AbstractMessageReceiver.this.parent.addPacket(packet);
                                continue block7;
                            }
                            AbstractMessageReceiver.this.addPacketNB(packet);
                            continue block7;
                        }
                    }
                    log.severe("Unknown queue element type: " + (Object)((Object)this.type));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "[" + AbstractMessageReceiver.this.getName() + "] Exception during packet processing: " + packet.toString(), e);
                }
            }
        }
    }

    private static enum QueueType {
        IN_QUEUE,
        OUT_QUEUE;

    }
}

