/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.io.SSLContextContainerIfc;

public class SSLContextContainer
implements SSLContextContainerIfc {
    private static final Logger log = Logger.getLogger("tigase.io.SSLContextContainer");
    private SecureRandom secureRandom = null;
    private Map<String, SSLContext> sslContexts = new HashMap<String, SSLContext>();
    private Map<String, KeyManagerFactory> kmfs = new HashMap<String, KeyManagerFactory>();
    private TrustManagerFactory tmf = null;
    private String def_cert_alias = null;

    @Override
    public void init(Map<String, String> params) {
        String k_store = params.get("keys-store");
        String k_passwd = params.get("keys-store-password");
        String t_store = params.get("trusts-store");
        String t_passwd = params.get("trusts-store-password");
        this.init(k_store, k_passwd, t_store, t_passwd);
    }

    @Override
    public void addCertificates(Map<String, String> params) {
        this.init(params);
    }

    private void init(String k_store, String k_passwd, String t_store, String t_passwd) {
        try {
            if (k_store != null && k_passwd != null) {
                KeyStore keys = KeyStore.getInstance("JKS");
                char[] keys_password = k_passwd.toCharArray();
                keys.load(new FileInputStream(k_store), keys_password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(keys, keys_password);
                this.kmfs.put(null, kmf);
                Enumeration<String> aliases = keys.aliases();
                ArrayList<String> certlist = null;
                if (aliases != null) {
                    certlist = new ArrayList<String>();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!keys.isCertificateEntry(alias)) continue;
                        certlist.add(alias);
                    }
                }
                aliases = keys.aliases();
                KeyStore.PasswordProtection pass_param = new KeyStore.PasswordProtection(keys_password);
                if (aliases != null) {
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!keys.isKeyEntry(alias)) continue;
                        KeyStore.Entry entry = keys.getEntry(alias, pass_param);
                        KeyStore alias_keys = KeyStore.getInstance("JKS");
                        alias_keys.load(null, keys_password);
                        if (certlist != null) {
                            for (String certal : certlist) {
                                alias_keys.setCertificateEntry(certal, keys.getCertificate(certal));
                            }
                        }
                        alias_keys.setEntry(alias, entry, pass_param);
                        kmf = KeyManagerFactory.getInstance("SunX509");
                        kmf.init(alias_keys, keys_password);
                        this.kmfs.put(alias, kmf);
                    }
                }
            }
            if (t_store != null && t_passwd != null) {
                KeyStore trusts = KeyStore.getInstance("JKS");
                char[] trusts_password = t_passwd.toCharArray();
                trusts.load(new FileInputStream(t_store), trusts_password);
                this.tmf = TrustManagerFactory.getInstance("SunX509");
                this.tmf.init(trusts);
            }
            this.secureRandom = new SecureRandom();
            this.secureRandom.nextInt();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSL library", e);
        }
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname) {
        String map_key;
        SSLContext sslContext;
        if (hostname == null) {
            hostname = this.def_cert_alias;
        }
        if ((sslContext = this.sslContexts.get(map_key = hostname + protocol)) == null) {
            try {
                sslContext = SSLContext.getInstance(protocol);
                KeyManagerFactory kmf = this.kmfs.get(hostname);
                if (kmf == null) {
                    kmf = this.kmfs.get(this.def_cert_alias);
                }
                if (kmf != null && this.tmf != null) {
                    sslContext.init(kmf.getKeyManagers(), this.tmf.getTrustManagers(), this.secureRandom);
                } else {
                    if (kmf == null) {
                        log.warning("No certificate found for host: " + hostname);
                    }
                    sslContext.init(kmf != null ? kmf.getKeyManagers() : null, new X509TrustManager[]{new FakeTrustManager()}, this.secureRandom);
                }
                this.sslContexts.put(map_key, sslContext);
                log.config("Created SSL context for: " + sslContext.getProtocol());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not initialize SSLContext", e);
                sslContext = null;
            }
        }
        return sslContext;
    }

    private static class FakeTrustManager
    implements X509TrustManager {
        private X509Certificate[] acceptedIssuers = null;

        public FakeTrustManager(X509Certificate[] ai) {
            this.acceptedIssuers = ai;
        }

        public FakeTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.acceptedIssuers;
        }
    }
}

