/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.Provider;
import java.security.Security;
import java.util.Set;
import java.util.logging.Logger;

public class TigaseSaslProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger("tigase.auth.TigaseSaslProvider");
    private static final String MY_NAME = "tigase.sasl";
    private static final double VERSION = 1.0;
    private static final String INFO = "This is tigase provider (provides Tigase server specific mechanisms)";

    public TigaseSaslProvider() {
        super(MY_NAME, 1.0, INFO);
        this.putService(new Provider.Service(this, "SaslServerFactory", "PLAIN", "tigase.auth.TigaseSaslServerFactory", null, null));
        this.putService(new Provider.Service(this, "SaslServerFactory", "ANONYMOUS", "tigase.auth.TigaseSaslServerFactory", null, null));
    }

    public static void main(String[] args) throws Exception {
        Provider[] provs;
        Security.insertProviderAt(new TigaseSaslProvider(), 6);
        for (Provider prov : provs = Security.getProviders()) {
            System.out.println("Provider: " + prov.getName());
            System.out.println(prov.getInfo());
            Set<Provider.Service> servs = prov.getServices();
            if (servs == null) continue;
            for (Provider.Service serv : servs) {
                System.out.println("   Service: type=" + serv.getType() + ", alg=" + serv.getAlgorithm() + ", prov=" + serv.getProvider().getName() + ", class=" + serv.getClassName());
            }
        }
    }
}

