/*  Tigase Jabber/XMPP Server
 *  Copyright (C) 2004-2008 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1070 $
 * Last modified by $Author: kobit $
 * $Date: 2008-06-21 23:14:29 +0100 (Sat, 21 Jun 2008) $
 */
package tigase.cluster;

import java.util.Set;
import java.util.logging.Logger;
import java.util.logging.Level;

import tigase.server.ServiceChecker;
import tigase.xmpp.XMPPIOService;
import tigase.util.JIDUtils;
import tigase.server.xmppclient.ClientConnectionManager;

/**
 * Describe class ClientConnectionClustered here.
 *
 *
 * Created: Sat Jun 21 22:23:18 2008
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1070 $
 */
public class ClientConnectionClustered extends ClientConnectionManager
	implements ClusteredComponent {

  /**
   * Variable <code>log</code> is a class logger.
   */
  private static final Logger log =
    Logger.getLogger("tigase.cluster.ClientConnectionClustered");

	public void nodesConnected(Set<String> node_hostnames) {}

	public void nodesDisconnected(Set<String> node_hostnames) {
		log.finest("Disconnected nodes: " + node_hostnames.toString());
		for (String node: node_hostnames) {
			final String hostname = node;
			doForAllServices(new ServiceChecker() {
					public void check(final XMPPIOService service, final String serviceId) {
						String dataReceiver = service.getDataReceiver();
						log.finest("Checking service for dataReceiver: " + dataReceiver);
						if (dataReceiver != null
							&& JIDUtils.getNodeHost(dataReceiver).equals(hostname)) {
							log.finest("Stopping service because corresponding cluster node stopped.");
							service.stop();
						}
					}
				});
		}
	}

}
