/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.Roster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;

public class RosterFlat
extends RosterAbstract {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterFlat");
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final int maxRosterSize = new Long(Runtime.getRuntime().maxMemory() / 250000L).intValue();

    public static void parseRoster(String roster_str, Map<String, RosterElement> roster) {
        block1: {
            Element elem;
            RosterElement relem;
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, roster_str.toCharArray(), 0, roster_str.length());
            Queue elems = domHandler.getParsedElements();
            if (elems == null || elems.size() <= 0) break block1;
            Iterator i$ = elems.iterator();
            while (i$.hasNext() && RosterFlat.addBuddy(relem = new RosterElement(elem = (Element)i$.next()), roster)) {
            }
        }
    }

    private Map<String, RosterElement> loadUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedHashMap<String, RosterElement> roster = new LinkedHashMap<String, RosterElement>();
        session.putCommonSessionData("roster", roster);
        String roster_str = session.getData(null, "roster", null);
        log.finest("Loaded user roster: " + roster_str);
        if (roster_str != null && !roster_str.isEmpty()) {
            RosterFlat.parseRoster(roster_str, roster);
        } else {
            Roster oldRoster = new Roster();
            String[] buddies = oldRoster.getBuddies(session);
            if (buddies != null && buddies.length > 0) {
                for (String buddy : buddies) {
                    String name = oldRoster.getBuddyName(session, buddy);
                    RosterAbstract.SubscriptionType subscr = oldRoster.getBuddySubscription(session, buddy);
                    String[] groups = oldRoster.getBuddyGroups(session, buddy);
                    RosterElement relem = new RosterElement(buddy, name, groups);
                    relem.setSubscription(subscr);
                    if (!RosterFlat.addBuddy(relem, roster)) break;
                }
                this.saveUserRoster(session);
            }
        }
        return roster;
    }

    private static boolean addBuddy(RosterElement relem, Map<String, RosterElement> roster) {
        if (roster.size() < maxRosterSize) {
            roster.put(relem.getJid(), relem);
            return true;
        }
        return false;
    }

    private void saveUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        StringBuilder sb = new StringBuilder();
        for (RosterElement relem : roster.values()) {
            sb.append(relem.getRosterElement().toString());
        }
        log.finest("Saving user roster: " + sb.toString());
        session.setData(null, "roster", sb.toString());
    }

    private Map<String, RosterElement> getUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = (Map<String, RosterElement>)session.getCommonSessionData("roster");
        if (roster == null) {
            roster = this.loadUserRoster(session);
        }
        return roster;
    }

    private RosterElement getRosterElement(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        return roster.get(JIDUtils.getNodeID((String)buddy));
    }

    @Override
    public String[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        return roster.keySet().toArray(new String[0]);
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getName();
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, String buddy, String name) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            log.finest("Setting name: '" + name + "' for buddy: " + buddy);
            relem.setName(name);
            this.saveUserRoster(session);
        } else {
            log.warning("Setting buddy name for non-existen contact: " + buddy);
        }
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.setSubscription(subscription);
            this.saveUserRoster(session);
        } else {
            log.warning("Missing roster contact for subscription set: " + buddy);
        }
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getSubscription();
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, String jid) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        roster.remove(jid);
        this.saveUserRoster(session);
        return true;
    }

    @Override
    public void addBuddy(XMPPResourceConnection session, String jid, String name, String[] groups) throws NotAuthorizedException, TigaseDBException {
        String buddy = JIDUtils.getNodeID((String)jid);
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            relem = new RosterElement(buddy, name, groups);
            Map<String, RosterElement> roster = this.getUserRoster(session);
            if (!RosterFlat.addBuddy(relem, roster)) {
                throw new TigaseDBException("Too many elements in the user roster.");
            }
            this.saveUserRoster(session);
            log.finest("Added buddy to roster: " + jid);
        } else {
            relem.setName(name);
            relem.setGroups(groups);
            this.saveUserRoster(session);
            log.finest("Updated buddy in roster: " + jid);
        }
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getGroups();
    }

    @Override
    public boolean containsBuddy(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        return this.getRosterElement(session, buddy) != null;
    }

    @Override
    public boolean addBuddyGroup(XMPPResourceConnection session, String buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.addGroups(groups);
            return true;
        }
        return false;
    }
}

