/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.Queue;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.RepoRosterTask;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;

public class PubSubTestsTask
extends RepoRosterTask {
    private static final String TASK_TYPE = "PubSub tests";
    private static final String TASK_HELP = "This is a PubSub component testing task. Only for testing and only to be run by an admnistrator.";
    private long delay = 2000L;
    private Element conf = new Element("x", new Element[]{new Element("field", new Element[]{new Element("value", "http://jabber.org/protocol/pubsub#node_config")}, new String[]{"var", "type"}, new String[]{"FORM_TYPE", "hidden"}), new Element("field", new Element[]{new Element("value", "0")}, new String[]{"var"}, new String[]{"pubsub#notify_sub_aff_state"})}, new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
    private boolean stop = false;
    private String[] last_nodes = null;

    private boolean memoryLow() {
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return new Long(heap.getUsed()).doubleValue() / new Long(heap.getMax()).doubleValue() > 0.7;
    }

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    @Override
    public Map<String, PropertyItem> getDefaultParams() {
        Map<String, PropertyItem> defs = super.getDefaultParams();
        defs.put("description", new PropertyItem("description", "Description", "PubSub Testing Task"));
        defs.put("message-type", new PropertyItem("message-type", "Message type", PropertyConstants.MessageType.NORMAL));
        defs.put("online-users-only", new PropertyItem("online-users-only", "Send to online users only", false));
        defs.put("replace-sender", new PropertyItem("replace-sender", "Replace sender address", PropertyConstants.SenderAddress.LEAVE));
        defs.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", PropertyConstants.SubscrRestrictions.MODERATED));
        return defs;
    }

    private String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        return "Available commands are:\n" + sb.toString();
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCData("/message/body");
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private int[] parseNumbers(String[] args, int pos, int num) {
        int[] res = new int[num];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = Integer.parseInt(args[i + pos]);
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return res;
    }

    private Element createPubSubEl(String from, String id, String node, String pubsub_call, String xmlns) {
        Element elem = new Element("iq", new Element[]{new Element("pubsub", new Element[]{new Element(pubsub_call, new String[]{"node"}, new String[]{node})}, new String[]{"xmlns"}, new String[]{xmlns})}, new String[]{"type", "from", "to", "id"}, new String[]{"set", from, "pubsub." + this.local_domain, id});
        return elem;
    }

    private void addSubscriptionsForNode(String from, String node, int subscr) {
        int j = 0;
        Element el = this.createPubSubEl(from, "ids-" + ++j, node, "subscriptions", "http://jabber.org/protocol/pubsub#owner");
        for (int i = 0; i < subscr; ++i) {
            Element subs = new Element("subscription", new String[]{"jid", "subscription"}, new String[]{"frank-" + i + "@" + this.local_domain, "subscribed"});
            el.findChild("/iq/pubsub/subscriptions").addChild((XMLNodeIfc)subs);
            if (i % 100 != 0) continue;
            this.addOutPacket(new Packet(el));
            el = this.createPubSubEl(from, "ids-" + ++j, node, "subscriptions", "http://jabber.org/protocol/pubsub#owner");
        }
        this.addOutPacket(new Packet(el));
    }

    private void addSubscriptionsForNodes(String from, String[] nodes, int subscr) {
        for (String node : nodes) {
            this.addSubscriptionsForNode(from, node, subscr);
        }
    }

    private String[] createNodes(String from, int ... nums) {
        String[] nodes = new String[nums[0]];
        for (int i = 0; i < nums[0] && !this.stop; ++i) {
            String node;
            nodes[i] = node = "node-" + i;
            Element el = this.createPubSubEl(from, "id-" + i, node, "create", "http://jabber.org/protocol/pubsub");
            el.findChild("/iq/pubsub").addChild((XMLNodeIfc)new Element("configure"));
            el.findChild("/iq/pubsub/configure").addChild((XMLNodeIfc)this.conf);
            this.addOutPacket(new Packet(el));
            if (nums.length > 1 && nums[1] > 0) {
                this.addSubscriptionsForNode(from, node, nums[1]);
            }
            while (this.memoryLow()) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (Exception e) {}
            }
        }
        this.stop = false;
        return nodes;
    }

    private void runInThread(final Runnable job, final Packet packet) {
        Thread thr = new Thread(){

            @Override
            public void run() {
                job.run();
                PubSubTestsTask.this.addOutPacket(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Generation of the test data completed.", "PubSub testing task", null));
            }
        };
        thr.setName("pubsub-test-job");
        thr.start();
    }

    private void runCommand(final Packet packet, Queue<Packet> results) {
        String body = packet.getElemCData("/message/body");
        final String[] body_split = body.split("\\s");
        command comm = command.valueOf(body_split[0].substring(2));
        switch (comm) {
            case help: {
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, this.commandsHelp(), "Commands description", null));
                break;
            }
            case setdelay: {
                int[] pars = this.parseNumbers(body_split, 1, 1);
                if (pars == null) break;
                this.delay = pars[0];
                break;
            }
            case newnodes: {
                final int[] pars = this.parseNumbers(body_split, 1, 1);
                if (pars != null) {
                    this.addOutPacket(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Task accepted, processing...", "PubSub testing task", null));
                    this.runInThread(new Runnable(){

                        @Override
                        public void run() {
                            PubSubTestsTask.access$002(PubSubTestsTask.this, PubSubTestsTask.this.createNodes(packet.getElemFrom(), pars));
                        }
                    }, packet);
                    break;
                }
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null));
                return;
            }
            case newsubscr: {
                if (this.last_nodes != null) {
                    final int[] pars = this.parseNumbers(body_split, 2, 1);
                    if (pars != null) {
                        this.addOutPacket(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Task accepted, processing...", "PubSub testing task", null));
                        this.runInThread(new Runnable(){

                            @Override
                            public void run() {
                                PubSubTestsTask.this.addSubscriptionsForNode(packet.getElemFrom(), body_split[1], pars[0]);
                            }
                        }, packet);
                        break;
                    }
                    results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null));
                    return;
                }
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "There are no pubsub nodes created yet.", "PubSub testing task", null));
                return;
            }
            case newnodessubscr: {
                final int[] pars = this.parseNumbers(body_split, 1, 2);
                if (pars != null) {
                    this.addOutPacket(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Task accepted, processing...", "PubSub testing task", null));
                    this.runInThread(new Runnable(){

                        @Override
                        public void run() {
                            PubSubTestsTask.access$002(PubSubTestsTask.this, PubSubTestsTask.this.createNodes(packet.getElemFrom(), pars));
                        }
                    }, packet);
                    break;
                }
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null));
                return;
            }
            case stop: {
                this.stop = true;
            }
        }
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        }
    }

    static /* synthetic */ String[] access$002(PubSubTestsTask x0, String[] x1) {
        x0.last_nodes = x1;
        return x1;
    }

    private static enum command {
        help(" - Displays help info."),
        newnodes(" N - Create N nodes in the pubsub."),
        newsubscr(" node-name N - create N subscriptions for a given node name."),
        newnodessubscr(" N M -  create N nodes with M subscriptions each."),
        setdelay(" N - set the delay between sending node creation packet."),
        stop(" - Stops the current packets generation.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

