/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class BoshSessionCache {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshSessionCache");
    public static final String DEF_ID = "";
    public static final String ROSTER_ID = "bosh-roster";
    public static final String RESOURCE_BIND_ID = "bosh-resource-bind";
    public static final String MESSAGE_ID = "bosh-message";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private Map<String, List<Element>> id_cache = new LinkedHashMap<String, List<Element>>();
    private Map<String, Element> jid_presence = new LinkedHashMap<String, Element>();
    protected Map<String, Long> jid_msg_start = new LinkedHashMap<String, Long>();

    public void set(String id, List<Element> data) {
        if (id == null) {
            id = DEF_ID;
        }
        ArrayList<Element> cached_data = new ArrayList<Element>();
        this.id_cache.put(id, cached_data);
        cached_data.addAll(data);
        log.finest("SET, id = " + id + ", DATA: " + data.toString());
    }

    public void add(String id, List<Element> data) {
        List<Element> cached_data;
        if (id == null) {
            id = DEF_ID;
        }
        if ((cached_data = this.id_cache.get(id)) == null) {
            cached_data = new ArrayList<Element>();
            this.id_cache.put(id, cached_data);
        }
        cached_data.addAll(data);
        log.finest("ADD, id = " + id + ", DATA: " + data.toString());
    }

    public List<Element> remove(String id) {
        if (id == null) {
            id = DEF_ID;
        }
        List<Element> data = this.id_cache.remove(id);
        log.finest("REMOVED, id = " + id + ", DATA: " + data.toString());
        return data;
    }

    public List<Element> get(String id) {
        if (id == null) {
            id = DEF_ID;
        }
        List<Element> data = this.id_cache.get(id);
        log.finest("GET, id = " + id + ", DATA: " + data.toString());
        return data;
    }

    public List<Element> getAll() {
        ArrayList<Element> result = new ArrayList<Element>();
        for (List<Element> cache_data : this.id_cache.values()) {
            result.addAll(cache_data);
        }
        result.addAll(this.jid_presence.values());
        log.finest("GET_ALL, DATA: " + ((Object)result).toString());
        return result;
    }

    public void addPresence(Element presence) {
        String from = presence.getAttribute("from");
        this.jid_presence.put(from, presence);
        log.finest("ADD_PRESENCE, from = " + from + ", PRESENCE: " + presence.toString());
    }

    public List<Element> getAllPresences() {
        return new ArrayList<Element>(this.jid_presence.values());
    }

    public List<Element> getPresence(String ... from) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String f : from) {
            Element presence = this.jid_presence.get(f);
            if (presence == null) continue;
            result.add(presence);
        }
        return result;
    }

    public void addRoster(Element roster) {
        this.add(ROSTER_ID, Arrays.asList(roster));
        log.finest("ADD_ROSTER, ROSTER: " + roster.toString());
    }

    private long getMsgStartTime(String jid) {
        Long start_time = this.jid_msg_start.get(jid);
        if (start_time == null) {
            start_time = System.currentTimeMillis() / 1000L;
            this.jid_msg_start.put(jid, start_time);
        }
        return start_time;
    }

    private Element createMessageHistory(String jid) {
        return new Element("iq", new Element[]{new Element("chat", new String[]{"xmlns", "with", "start"}, new String[]{"urn:xmpp:tmp:archive", jid, sdf.format(new Date())})}, new String[]{"type", "id"}, new String[]{"result", DEF_ID + System.currentTimeMillis()});
    }

    private void addMsgBody(String jid, String direction, Element body) {
        long start_time = this.getMsgStartTime(jid);
        List<Element> msg_history_l = this.id_cache.get(MESSAGE_ID + jid);
        Element msg_history = null;
        if (msg_history == null) {
            msg_history = this.createMessageHistory(jid);
            this.add(MESSAGE_ID + jid, Arrays.asList(msg_history));
        } else {
            msg_history = msg_history_l.get(0);
        }
        long current_secs = System.currentTimeMillis() / 1000L - start_time;
        msg_history.findChild("/iq/chat").addChild((XMLNodeIfc)new Element(direction, new Element[]{body}, new String[]{"secs"}, new String[]{DEF_ID + current_secs}));
    }

    public void addFromMessage(Element message) {
        Element body = message.findChild("/message/body");
        if (body == null) {
            return;
        }
        String jid = message.getAttribute("from");
        this.addMsgBody(jid, "from", body);
    }

    public void addToMessage(Element message) {
        Element body = message.findChild("/message/body");
        if (body == null) {
            return;
        }
        String jid = message.getAttribute("to");
        this.addMsgBody(jid, "to", body);
    }
}

