/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.ElementUtils;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public abstract class ServiceDiscovery
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.ServiceDiscovery");
    private static final String ID = "disco";
    private static final String[] ELEMENTS = new String[]{"query", "query", "query"};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#info"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#items"})};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            String nodeId = null;
            String nodeNick = null;
            if (packet.getElemTo() != null) {
                nodeId = JIDUtils.getNodeID((String)packet.getElemTo());
                nodeNick = JIDUtils.getNodeNick((String)packet.getElemTo());
            }
            if (packet.isCommand()) {
                if (packet.getCommand() == Command.GETDISCO && packet.getType() == StanzaType.result) {
                    Element query = Command.getData(packet, "query", null);
                    Element iq = ElementUtils.createIqQuery(session.getDomain(), session.getJID(), StanzaType.result, packet.getElemId(), query);
                    Packet result = new Packet(iq);
                    result.setTo(session.getConnectionId());
                    result.getElement().setAttribute("from", Command.getFieldValue(packet, "jid"));
                    results.offer(result);
                    return;
                }
                return;
            }
            if (nodeId == null || nodeId.equals("") || nodeNick == null && nodeId.endsWith(session.getDomain())) {
                Element query = packet.getElement().getChild("query");
                Packet discoCommand = Command.GETDISCO.getPacket(session.getJID(), session.getDomain(), StanzaType.get, packet.getElemId(), "submit");
                Command.addFieldValue(discoCommand, "xmlns", query.getXMLNS());
                Command.addFieldValue(discoCommand, "jid", packet.getElemTo());
                if (query.getAttribute("node") != null) {
                    Command.addFieldValue(discoCommand, "node", query.getAttribute("node"));
                }
                results.offer(discoCommand);
                return;
            }
            if (nodeId.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received stats request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

