/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.ElementUtils;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqStats
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqStats");
    private static final String XMLNS = "http://jabber.org/protocol/stats";
    private static final String ID = "http://jabber.org/protocol/stats";
    private static final String[] ELEMENTS = new String[]{"query", "command"};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/stats", "http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/stats"})};

    @Override
    public String id() {
        return "http://jabber.org/protocol/stats";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            String id;
            log.finest("Received packet: " + packet.getStringData());
            if (packet.isCommand()) {
                if (packet.getCommand() == Command.GETSTATS && packet.getType() == StanzaType.result) {
                    Element iq = ElementUtils.createIqQuery(session.getDomain(), session.getJID(), StanzaType.result, packet.getElemId(), "http://jabber.org/protocol/stats");
                    Element query = iq.getChild("query");
                    Element stats = Command.getData(packet, "statistics", null);
                    query.addChildren(stats.getChildren());
                    Packet result = new Packet(iq);
                    result.setTo(session.getConnectionId(packet.getElemTo()));
                    results.offer(result);
                    log.finest("Sending result: " + result.getStringData());
                    return;
                }
                return;
            }
            String string = id = packet.getElemTo() != null ? JIDUtils.getNodeID((String)packet.getElemTo()) : null;
            if (id == null || id.equals("") || id.equalsIgnoreCase(session.getDomain())) {
                Packet result = Command.GETSTATS.getPacket(packet.getElemFrom(), session.getDomain(), StanzaType.get, packet.getElemId());
                results.offer(result);
                log.finest("Sending result: " + result.getStringData());
                return;
            }
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
                log.finest("Sending result: " + result.getStringData());
            } else {
                Element el_res = packet.getElement().clone();
                Packet result = new Packet(el_res);
                results.offer(result);
                log.finest("Sending result: " + result.getStringData());
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received stats request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

