/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.JIDUtils;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class XMPPSession {
    private static Logger log = Logger.getLogger("tigase.xmpp.XMPPSession");
    private String username = null;
    private ArrayList<XMPPResourceConnection> activeResources = new ArrayList();
    private long creationTime = 0L;

    public XMPPSession(String username) {
        this.username = username;
        this.creationTime = System.currentTimeMillis();
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public void streamClosed(XMPPResourceConnection conn) {
        this.removeResourceConnection(conn);
    }

    public String getUserName() {
        return this.username;
    }

    public List<XMPPResourceConnection> getActiveResources() {
        return (List)this.activeResources.clone();
    }

    public int getActiveResourcesSize() {
        return this.activeResources.size();
    }

    public void resourceSet(XMPPResourceConnection conn) {
        this.activeResources.remove(conn);
        String cur_res = conn.getResource();
        XMPPResourceConnection old_conn = this.getResourceForResource(cur_res);
        this.activeResources.add(conn);
        if (old_conn != null) {
            log.finest("Found old resource connection for username : " + this.username + ", id: " + old_conn.getConnectionId());
            try {
                old_conn.logout();
            }
            catch (Exception e) {
                log.log(Level.INFO, "Exception during closing old connection, ignoring.", e);
            }
            this.removeResourceConnection(old_conn);
        }
    }

    public void addResourceConnection(XMPPResourceConnection conn) {
        log.finest("Adding resource connection for username : " + this.username + ", id: " + conn.getConnectionId());
        XMPPResourceConnection old_res = this.getResourceForResource(conn.getResource());
        if (old_res != conn) {
            if (old_res != null) {
                log.finest("Found old resource connection, id: " + old_res.getConnectionId());
                this.removeResourceConnection(old_res);
                try {
                    old_res.logout();
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception during closing old connection, ignoring.", e);
                }
            }
            this.activeResources.add(conn);
            conn.setParentSession(this);
            log.finest("Number of active resources is: " + this.activeResources.size());
            if (this.activeResources.size() > 1) {
                int i = 0;
                for (XMPPResourceConnection res : this.activeResources) {
                    log.finest("RES " + ++i + ": " + res.getResource() + ", " + res.getConnectionId());
                }
            }
        }
    }

    public void removeResourceConnection(XMPPResourceConnection conn) {
        this.activeResources.remove(conn);
        conn.setParentSession(null);
    }

    public String[] getJIDs() throws NotAuthorizedException {
        String[] result = new String[this.activeResources.size()];
        int idx = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            result[idx++] = conn.getJID();
        }
        return result;
    }

    public XMPPResourceConnection getResourceForResource(String resource) {
        if (resource != null && resource.length() > 0) {
            for (XMPPResourceConnection conn : this.activeResources) {
                log.finest("Resource checking: " + conn.getResource());
                if (!resource.equalsIgnoreCase(conn.getResource())) continue;
                return conn;
            }
        }
        return null;
    }

    public XMPPResourceConnection getResourceForConnectionId(String connectionId) {
        for (XMPPResourceConnection conn : this.activeResources) {
            if (!connectionId.equals(conn.getConnectionId())) continue;
            return conn;
        }
        return null;
    }

    public XMPPResourceConnection getOldestConnection() {
        if (this.activeResources.size() > 0) {
            XMPPResourceConnection result = this.activeResources.get(0);
            for (XMPPResourceConnection conn : this.activeResources) {
                if (result.getCreationTime() <= conn.getCreationTime()) continue;
                result = conn;
            }
            return result;
        }
        log.info("XMPPSession with no connections for user: " + this.username);
        return null;
    }

    public XMPPResourceConnection getResourceForJID(String jid) {
        String resource = JIDUtils.getNodeResource((String)jid);
        return this.getResourceForResource(resource);
    }

    public XMPPResourceConnection getResourceConnection(String jid) {
        log.finest("Called for: " + jid);
        if (this.activeResources.size() == 0) {
            return null;
        }
        if (this.activeResources.size() == 1) {
            XMPPResourceConnection result = this.activeResources.get(0);
            log.finest("Only 1 active resource: " + result.getResource());
            return result;
        }
        XMPPResourceConnection conn = this.getResourceForJID(jid);
        if (conn != null) {
            log.finest("Number of resources: " + this.activeResources.size() + ", got resource for jid: " + jid);
            return conn;
        }
        ArrayList<XMPPResourceConnection> al = new ArrayList<XMPPResourceConnection>();
        al.add(this.activeResources.get(0));
        int highest_priority = ((XMPPResourceConnection)al.get(0)).getPriority();
        for (int i = 1; i < this.activeResources.size(); ++i) {
            XMPPResourceConnection conn_tmp = this.activeResources.get(i);
            if (conn_tmp.getPriority() == highest_priority) {
                al.add(conn_tmp);
                continue;
            }
            if (conn_tmp.getPriority() <= highest_priority) continue;
            al.clear();
            al.add(conn_tmp);
            highest_priority = conn_tmp.getPriority();
        }
        if (al.size() == 1) {
            return (XMPPResourceConnection)al.get(0);
        }
        XMPPResourceConnection conn_last = (XMPPResourceConnection)al.get(0);
        long time = conn_last.getLastAccessed();
        for (int i = 1; i < al.size(); ++i) {
            if (((XMPPResourceConnection)al.get(i)).getLastAccessed() <= time) continue;
            conn_last = (XMPPResourceConnection)al.get(i);
            time = conn_last.getLastAccessed();
        }
        return conn_last;
    }
}

