/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.RepositoryFactory;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VhostConfigRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class VHostJDBCRepository
extends VhostConfigRepository {
    private static final Logger log = Logger.getLogger("tigase.vhosts.VHostJDBCRepository");
    public static final String VHOST_REPO_CLASS_PROP_KEY = "vhost-repo-class";
    public static final String VHOST_REPO_URI_PROP_KEY = "vhost-repo-uri";
    private String vhost_user = "vhost-manager";
    private String vhost_list_pkey = "vhosts-lists";
    private UserRepository repo = null;

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        String repo_class = "tigase.db.jdbc.JDBCRepository";
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db") != null) {
            repo_class = (String)params.get("--user-db");
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(VHOST_REPO_CLASS_PROP_KEY, repo_class);
        defs.put(VHOST_REPO_URI_PROP_KEY, repo_uri);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        String repo_class = (String)properties.get(VHOST_REPO_CLASS_PROP_KEY);
        String repo_uri = (String)properties.get(VHOST_REPO_URI_PROP_KEY);
        try {
            this.repo = RepositoryFactory.getUserRepository(this.vhost_user, repo_class, repo_uri, null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize VHost repository", e);
            this.repo = null;
        }
        if (this.repo != null) {
            try {
                this.repo.addUser(this.vhost_user);
            }
            catch (UserExistsException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem with adding 'vhost-manager' user to the database", e);
            }
            this.reload();
        }
    }

    @Override
    public void reload() {
        super.reload();
        try {
            String vhosts_list = this.repo.getData(this.vhost_user, this.vhost_list_pkey);
            if (vhosts_list != null && !vhosts_list.isEmpty()) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                SimpleParser parser = SingletonFactory.getParserInstance();
                parser.parse((SimpleHandler)domHandler, vhosts_list.toCharArray(), 0, vhosts_list.length());
                Queue elems = domHandler.getParsedElements();
                if (elems != null && elems.size() > 0) {
                    for (Element elem : elems) {
                        VHostItem item = new VHostItem(elem);
                        this.vhosts.put(item.getVhost(), item);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Problem with loading VHosts list from the database.", ex);
        }
    }

    @Override
    public void store() {
        super.store();
        StringBuilder sb = new StringBuilder();
        for (VHostItem vhost : this.vhosts.values()) {
            sb.append(vhost.toXML().toString());
        }
        try {
            this.repo.setData(this.vhost_user, this.vhost_list_pkey, sb.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing VHosts list in the repository", e);
        }
    }
}

