/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.util.ElementUtils;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;

public class StatisticsCollector
extends AbstractComponentRegistrator<StatisticsContainer>
implements XMPPService {
    private static final Logger log = Logger.getLogger("tigase.stats.StatisticsCollector");
    private static final String STATS_XMLNS = "http://jabber.org/protocol/stats";
    private ServiceEntity serviceEntity = null;
    private Level statsLevel = Level.INFO;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "stats", "Server statistics");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "stats", "Server statistics"), new ServiceIdentity("automation", "command-node", "All statistics"), new ServiceIdentity("automation", "command-list", "Statistics retrieving commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
    }

    @Override
    public void componentAdded(StatisticsContainer component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof StatisticsContainer;
    }

    @Override
    public void componentRemoved(StatisticsContainer component) {
    }

    private List<StatRecord> getAllStats() {
        ArrayList<StatRecord> result = new ArrayList<StatRecord>();
        for (StatisticsContainer comp : this.components.values()) {
            result.addAll(comp.getStatistics());
        }
        return result;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (!packet.isCommand() || packet.getType() != null && packet.getType() == StanzaType.result) {
            return;
        }
        switch (packet.getCommand()) {
            case GETSTATS: {
                log.finest("Command received: " + packet.getStringData());
                Element iq = ElementUtils.createIqQuery(packet.getElemTo(), packet.getElemFrom(), StanzaType.result, packet.getElemId(), STATS_XMLNS);
                Element query = iq.getChild("query");
                List<StatRecord> stats = this.getAllStats();
                if (stats != null && stats.size() > 0) {
                    for (StatRecord record : stats) {
                        Element item = new Element("stat");
                        item.addAttribute("name", record.getComponent() + "/" + record.getDescription());
                        item.addAttribute("units", record.getUnit());
                        item.addAttribute("value", record.getValue());
                        query.addChild(item);
                    }
                }
                Packet result = new Packet(iq);
                results.offer(result);
                break;
            }
            case OTHER: {
                if (packet.getStrCommand() == null) {
                    return;
                }
                String nick = JIDUtils.getNodeNick((String)packet.getTo());
                if (nick == null || !this.getName().equals(nick)) {
                    return;
                }
                Command.Action action = Command.getAction(packet);
                if (action == Command.Action.cancel) {
                    Packet result = packet.commandResult(null);
                    results.offer(result);
                    return;
                }
                log.finest("Command received: " + packet.getStringData());
                List<StatRecord> stats = null;
                if (packet.getStrCommand().equals("stats")) {
                    stats = this.getAllStats();
                } else {
                    String[] spl = packet.getStrCommand().split("/");
                    stats = ((StatisticsContainer)this.getComponent(spl[1])).getStatistics();
                }
                String tmp_val = Command.getFieldValue(packet, "Stats level");
                if (tmp_val != null) {
                    this.statsLevel = Level.parse(tmp_val);
                }
                if (stats == null || stats.size() <= 0) break;
                Packet result = packet.commandResult("result");
                Command.setStatus(result, Command.Status.executing);
                Command.addAction(result, Command.Action.next);
                for (StatRecord rec : stats) {
                    if (rec.getLevel().intValue() < this.statsLevel.intValue()) continue;
                    if (rec.getType() == StatisticType.LIST) {
                        Command.addFieldMultiValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), rec.getListValue());
                        continue;
                    }
                    Command.addFieldValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), XMLUtils.escape((String)rec.getValue()));
                }
                Command.addFieldValue(result, "Stats level", this.statsLevel.getName(), "Stats level", new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()}, new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()});
                results.offer(result);
                break;
            }
        }
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (this.getName().equals(JIDUtils.getNodeNick((String)jid)) || this.getComponentId().equals(jid)) {
            List<Element> items = this.serviceEntity.getDiscoItems(node, jid);
            log.finest("Processing discoItems for node: " + node + ", result: " + (items == null ? null : items.toString()));
            return items;
        }
        Element item = this.serviceEntity.getDiscoItem(null, JIDUtils.getNodeID((String)this.getName(), (String)jid));
        log.finest("Processing discoItems, result: " + (item == null ? null : item.toString()));
        return Arrays.asList(item);
    }
}

