/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Map;
import tigase.util.DNSResolver;

public class SessionManagerConfig {
    public static final String USER_REPO_CLASS_PROP_KEY = "user-repo-class";
    public static final String USER_REPO_URL_PROP_KEY = "user-repo-url";
    public static final String USER_REPO_PARAMS_NODE = "user-repo-params";
    public static final String AUTH_REPO_CLASS_PROP_KEY = "auth-repo-class";
    public static final String AUTH_REPO_URL_PROP_KEY = "auth-repo-url";
    public static final String AUTH_REPO_PARAMS_NODE = "auth-repo-params";
    public static final String PLUGINS_PROP_KEY = "plugins";
    public static final String PLUGINS_CONF_PROP_KEY = "plugins-conf";
    private static final String[] PLUGINS_NO_REG_PROP_VAL = new String[]{"jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "msgoffline", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping"};
    private static final String[] PLUGINS_TEST_PROP_VAL = new String[]{"jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping"};
    private static final String[] PLUGINS_FULL_PROP_VAL = new String[]{"jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "msgoffline", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping"};
    private static String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ANONYMOUS_DOMAINS_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] TRUSTED_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] CLUSTER_NODES_PROP_VAL = new String[]{"sess-man@localhost"};

    public static void getDefaults(Map<String, Object> props, Map<String, Object> params) {
        int i;
        boolean full_comps = true;
        String user_repo_class = "tigase.db.jdbc.JDBCRepository";
        String user_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        String auth_repo_class = "tigase.db.jdbc.JDBCRepository";
        String auth_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db") != null) {
            if (params.get("--user-db").equals("mysql")) {
                user_repo_class = "tigase.db.jdbc.JDBCRepository";
                user_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            } else if (params.get("--user-db").equals("pgsql")) {
                user_repo_class = "tigase.db.jdbc.JDBCRepository";
                user_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
            } else if (params.get("--user-db").equals("derby")) {
                user_repo_class = "tigase.db.jdbc.JDBCRepository";
                user_repo_url = "jdbc:derby:tigase-derbydb;create=true";
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:derby:tigase-derbydb;create=true";
            } else {
                user_repo_class = (String)params.get("--user-db");
                auth_repo_class = (String)params.get("--user-db");
            }
        }
        if (params.get("--user-db-uri") != null) {
            auth_repo_url = user_repo_url = (String)params.get("--user-db-uri");
        }
        if (params.get("--auth-db") != null) {
            if (params.get("--auth-db").equals("mysql")) {
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            } else if (params.get("--auth-db").equals("pgsql")) {
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
            } else if (params.get("--auth-db").equals("tigase-custom-auth") || params.get("--auth-db").equals("custom-auth") || params.get("--auth-db").equals("tigase-custom")) {
                auth_repo_class = "tigase.db.jdbc.TigaseCustomAuth";
            } else if (params.get("--auth-db").equals("tigase-auth")) {
                auth_repo_class = "tigase.db.jdbc.TigaseAuth";
            } else if (params.get("--auth-db").equals("drupal")) {
                auth_repo_class = "tigase.db.jdbc.DrupalAuth";
                auth_repo_url = "jdbc:mysql://localhost/drupal?user=root&password=mypass";
                user_repo_url = user_repo_url + "&autoCreateUser=true";
                full_comps = false;
            } else if (params.get("--auth-db").equals("libresource")) {
                auth_repo_class = "tigase.db.jdbc.LibreSourceAuth";
                auth_repo_url = "jdbc:postgresql://localhost/libresource?user=demo";
                user_repo_url = user_repo_url + "&autoCreateUser=true";
                full_comps = false;
            } else {
                auth_repo_class = (String)params.get("--auth-db");
            }
        }
        if (params.get("--auth-db-uri") != null) {
            auth_repo_url = (String)params.get("--auth-db-uri");
        }
        props.put(USER_REPO_CLASS_PROP_KEY, user_repo_class);
        props.put(USER_REPO_URL_PROP_KEY, user_repo_url);
        props.put("user-repo-params/param-1", "value-1");
        props.put(AUTH_REPO_CLASS_PROP_KEY, auth_repo_class);
        props.put(AUTH_REPO_URL_PROP_KEY, auth_repo_url);
        props.put("auth-repo-params/param-1", "value-1");
        String str_plugins = (String)params.get("--sm-plugins");
        if (str_plugins != null) {
            props.put(PLUGINS_PROP_KEY, str_plugins.split(","));
        } else if (((Boolean)params.get("--test")).booleanValue()) {
            props.put(PLUGINS_PROP_KEY, PLUGINS_TEST_PROP_VAL);
        } else if (full_comps) {
            props.put(PLUGINS_PROP_KEY, PLUGINS_FULL_PROP_VAL);
        } else {
            props.put(PLUGINS_PROP_KEY, PLUGINS_NO_REG_PROP_VAL);
        }
        if (params.get("--virt-hosts") != null) {
            HOSTNAMES_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
            ANONYMOUS_DOMAINS_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
        } else {
            HOSTNAMES_PROP_VAL = DNSResolver.getDefHostNames();
            ANONYMOUS_DOMAINS_PROP_VAL = DNSResolver.getDefHostNames();
        }
        if (params.get("--admins") != null) {
            ADMINS_PROP_VAL = ((String)params.get("--admins")).split(",");
        } else {
            ADMINS_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (i = 0; i < ADMINS_PROP_VAL.length; ++i) {
                SessionManagerConfig.ADMINS_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("admins", ADMINS_PROP_VAL);
        if (params.get("--trusted") != null) {
            TRUSTED_PROP_VAL = ((String)params.get("--trusted")).split(",");
        } else {
            TRUSTED_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (i = 0; i < TRUSTED_PROP_VAL.length; ++i) {
                SessionManagerConfig.TRUSTED_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("trusted", TRUSTED_PROP_VAL);
    }
}

