/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppserver.ConnectionHandlerIfc;
import tigase.server.xmppserver.ServerConnections;
import tigase.stats.StatRecord;
import tigase.util.Algorithms;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

public class ServerConnectionManager
extends ConnectionManager<XMPPIOService>
implements ConnectionHandlerIfc {
    private static final Logger log = Logger.getLogger("tigase.server.xmppserver.ServerConnectionManager");
    private static final String XMLNS_DB_ATT = "xmlns:db";
    private static final String XMLNS_DB_VAL = "jabber:server:dialback";
    private static final String RESULT_EL_NAME = "result";
    private static final String DB_RESULT_EL_NAME = "db:result";
    private static final String VERIFY_EL_NAME = "verify";
    private static final String DB_VERIFY_EL_NAME = "db:verify";
    public static final String MAX_PACKET_WAITING_TIME_PROP_KEY = "max-packet-waiting-time";
    public static final long MAX_PACKET_WAITING_TIME_PROP_VAL = 420000L;
    private long maxPacketWaitingTime = 420000L;
    private Map<String, ServerConnections> connectionsByLocalRemote = new ConcurrentSkipListMap<String, ServerConnections>();
    private ConcurrentSkipListMap<String, XMPPIOService> incoming = new ConcurrentSkipListMap();
    private Timer connectionWatchdog = new Timer();

    protected ServerConnections getServerConnections(String cid) {
        return this.connectionsByLocalRemote.get(cid);
    }

    protected ServerConnections removeServerConnections(String cid) {
        return this.connectionsByLocalRemote.remove(cid);
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (!packet.isCommand() || !this.processCommand(packet)) {
            if (packet.getElemTo() == null) {
                log.warning("Missing 'to' attribute, ignoring packet..." + packet.toString() + "\n This most likely happens due to missconfiguration of components domain names.");
                return;
            }
            if (packet.getElemFrom() == null) {
                log.warning("Missing 'from' attribute, ignoring packet..." + packet.toString());
                return;
            }
            String to_hostname = JIDUtils.getNodeHost((String)packet.getElemTo());
            if (this.isLocalDomainOrComponent(to_hostname)) {
                log.finest("Packet addresses to localhost, I am not processing it: " + packet.getStringData());
                try {
                    this.addOutPacket(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "S2S - not delivered. Server missconfiguration.", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
                return;
            }
            String from_hostname = JIDUtils.getNodeHost((String)packet.getElemFrom());
            if (to_hostname.equals(from_hostname)) {
                log.warning("Dropping incorrect packet - from_hostname == to_hostname: " + packet.toString());
                return;
            }
            String cid = this.getConnectionId(packet);
            log.finest("Connection ID is: " + cid);
            ServerConnections serv_conn = this.getServerConnections(cid);
            if (serv_conn == null || !serv_conn.sendPacket(packet) && serv_conn.needsConnection()) {
                log.finest("Couldn't send packet, creating a new connection.");
                this.createServerConnection(cid, packet, serv_conn);
            } else {
                log.finest("Packet seems to be sent correctly: " + packet.toString());
            }
        }
    }

    private ServerConnections createNewServerConnections(String cid, Packet packet) {
        ServerConnections conns = new ServerConnections(this, cid);
        if (packet != null) {
            if (packet.getElement().getXMLNS() == XMLNS_DB_VAL) {
                conns.addControlPacket(packet);
            } else {
                conns.addDataPacket(packet);
            }
        }
        this.connectionsByLocalRemote.put(cid, conns);
        return conns;
    }

    private void createServerConnection(String cid, Packet packet, ServerConnections serv_conn) {
        String remotehost;
        String localhost;
        ServerConnections conns = serv_conn;
        if (conns == null) {
            conns = this.createNewServerConnections(cid, packet);
        }
        if (this.openNewServerConnection(localhost = JIDUtils.getNodeNick((String)cid), remotehost = JIDUtils.getNodeHost((String)cid))) {
            conns.setConnecting();
            this.connectionWatchdog.schedule((TimerTask)new ConnectionWatchdogTask(conns, localhost, remotehost), 120000L);
            log.finest("Connecting a new s2s service: " + cid);
        } else {
            log.finest("Couldn't open a new s2s service: (UknownHost??) " + cid);
            Queue<Packet> waitingPackets = conns.getWaitingPackets();
            Packet p = null;
            while ((p = waitingPackets.poll()) != null) {
                if (p.getElement().getXMLNS() == XMLNS_DB_VAL) continue;
                try {
                    this.addOutPacket(Authorization.REMOTE_SERVER_NOT_FOUND.getResponseMessage(p, "S2S - destination host not found", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet: " + p.toString() + " processing exception: " + e);
                }
            }
            conns.stopAll();
        }
    }

    private boolean openNewServerConnection(String localhost, String remotehost) {
        try {
            String ipAddress = DNSResolver.getHostSRV_IP((String)remotehost);
            TreeMap<String, Object> port_props = new TreeMap<String, Object>();
            port_props.put("remote-ip", ipAddress);
            port_props.put("local-hostname", localhost);
            port_props.put("remote-hostname", remotehost);
            port_props.put("ifc", new String[]{ipAddress});
            port_props.put("socket", (Object)SocketType.plain);
            port_props.put("type", (Object)ConnectionType.connect);
            port_props.put("port-no", 5269);
            String cid = this.getConnectionId(localhost, remotehost);
            port_props.put("cid", cid);
            log.finest("STARTING new connection: " + cid);
            this.addWaitingTask(port_props);
            return true;
        }
        catch (UnknownHostException e) {
            log.info("UnknownHostException for host: " + remotehost);
            return false;
        }
    }

    private String getConnectionId(String localhost, String remotehost) {
        return JIDUtils.getJID((String)localhost, (String)remotehost, null);
    }

    private String getConnectionId(Packet packet) {
        return JIDUtils.getJID((String)JIDUtils.getNodeHost((String)packet.getElemFrom()), (String)JIDUtils.getNodeHost((String)packet.getElemTo()), null);
    }

    private String getConnectionId(XMPPIOService service) {
        String local_hostname = (String)service.getSessionData().get("local-hostname");
        String remote_hostname = (String)service.getSessionData().get("remote-hostname");
        String cid = this.getConnectionId(local_hostname, remote_hostname != null ? remote_hostname : "NULL");
        return cid;
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        while ((p = packets.poll()) != null) {
            if (p.getElement().getXMLNS() == null) {
                p.getElement().setXMLNS("jabber:client");
            }
            log.finest("Processing socket data: " + p.toString());
            if (p.getElement().getXMLNS() == XMLNS_DB_VAL) {
                this.processDialback(p, serv);
                continue;
            }
            if (p.getElemName() == "error") {
                this.processStreamError(p, serv);
                return null;
            }
            if (this.checkPacket(p, serv)) {
                log.finest("Adding packet out: " + p.getStringData());
                this.addOutPacket(p);
                continue;
            }
            return null;
        }
        return null;
    }

    private void bouncePacketsBack(Authorization author, String cid) {
        ServerConnections serv_conns = this.getServerConnections(cid);
        if (serv_conns != null) {
            Queue<Packet> waiting = serv_conns.getWaitingPackets();
            Packet p = null;
            while ((p = waiting.poll()) != null) {
                log.finest("Sending packet back: " + p.getStringData());
                try {
                    this.addOutPacket(author.getResponseMessage(p, "S2S - not delivered", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
            }
        } else {
            log.warning("No ServerConnections for cid: " + cid);
        }
    }

    private void processStreamError(Packet packet, XMPPIOService serv) {
        Authorization author = Authorization.RECIPIENT_UNAVAILABLE;
        if (packet.getElement().getChild("host-unknown") != null) {
            author = Authorization.REMOTE_SERVER_NOT_FOUND;
        }
        String cid = this.getConnectionId(serv);
        this.bouncePacketsBack(author, cid);
        serv.stop();
    }

    private boolean checkPacket(Packet packet, XMPPIOService serv) {
        String packet_from = packet.getElemFrom();
        String packet_to = packet.getElemTo();
        if (packet_from == null || packet_to == null) {
            this.generateStreamError("improper-addressing", serv);
            return false;
        }
        String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
        if (!JIDUtils.getNodeHost((String)packet_from).equals(remote_hostname)) {
            log.finer("Invalid hostname from the remote server, expected: " + remote_hostname);
            this.generateStreamError("invalid-from", serv);
            return false;
        }
        String local_hostname = (String)serv.getSessionData().get("local-hostname");
        if (!JIDUtils.getNodeHost((String)packet_to).equals(local_hostname)) {
            log.finer("Invalid hostname of the local server, expected: " + local_hostname);
            this.generateStreamError("host-unknown", serv);
            return false;
        }
        String cid = this.getConnectionId(serv);
        String session_id = (String)serv.getSessionData().get("sessionID");
        if (!this.isIncomingValid(session_id)) {
            log.info("Incoming connection hasn't been validated");
            return false;
        }
        return true;
    }

    public boolean isIncomingValid(String session_id) {
        if (session_id == null) {
            return false;
        }
        XMPPIOService serv = this.incoming.get(session_id);
        if (serv == null || serv.getSessionData().get("valid") == null) {
            return false;
        }
        return (Boolean)serv.getSessionData().get("valid");
    }

    private boolean processCommand(Packet packet) {
        switch (packet.getCommand()) {
            case STARTTLS: {
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                break;
            }
        }
        return false;
    }

    @Override
    public String xmppStreamOpened(XMPPIOService serv, Map<String, String> attribs) {
        log.finer("Stream opened: " + attribs.toString());
        switch (serv.connectionType()) {
            case connect: {
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                String cid = this.getConnectionId(local_hostname, remote_hostname);
                log.finest("Stream opened for: " + cid);
                ServerConnections serv_conns = this.getServerConnections(cid);
                if (serv_conns == null) {
                    serv_conns = this.createNewServerConnections(cid, null);
                }
                serv_conns.addOutgoing(serv);
                log.finest("Counters: ioservices: " + this.countIOServices() + ", s2s connections: " + this.countOpenConnections());
                String remote_id = attribs.get("id");
                serv.getSessionData().put("sessionID", remote_id);
                String uuid = UUID.randomUUID().toString();
                String key = null;
                try {
                    key = Algorithms.hexDigest((String)remote_id, (String)uuid, (String)"SHA");
                }
                catch (NoSuchAlgorithmException e) {
                    key = uuid;
                }
                serv_conns.putDBKey(remote_id, key);
                Element elem = new Element(DB_RESULT_EL_NAME, key, new String[]{"from", "to", XMLNS_DB_ATT}, new String[]{local_hostname, remote_hostname, XMLNS_DB_VAL});
                serv_conns.addControlPacket(new Packet(elem));
                serv_conns.sendAllControlPackets();
                return null;
            }
            case accept: {
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                String cid = this.getConnectionId(local_hostname != null ? local_hostname : "NULL", remote_hostname != null ? remote_hostname : "NULL");
                log.finest("Stream opened for: " + cid);
                if (remote_hostname != null) {
                    log.fine("Opening stream for already established connection...., trying to turn on TLS????");
                }
                String id = UUID.randomUUID().toString();
                serv.getSessionData().put("sessionID", id);
                this.incoming.put(id, serv);
                return "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback' id='" + id + "'" + ">";
            }
        }
        log.severe("Warning, program shouldn't reach that point.");
        return null;
    }

    @Override
    public void xmppStreamClosed(XMPPIOService serv) {
        log.finer("Stream closed: " + this.getConnectionId(serv));
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(MAX_PACKET_WAITING_TIME_PROP_KEY, 420000L);
        return props;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5269};
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.maxPacketWaitingTime = (Long)props.get(MAX_PACKET_WAITING_TIME_PROP_KEY);
    }

    @Override
    public void serviceStarted(XMPPIOService serv) {
        super.serviceStarted(serv);
        log.finest("s2s connection opened: " + serv.getRemoteAddress() + ", type: " + serv.connectionType().toString() + ", id=" + serv.getUniqueId());
        switch (serv.connectionType()) {
            case connect: {
                String data = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback'>";
                log.finest("cid: " + (String)serv.getSessionData().get("cid") + ", sending: " + data);
                serv.xmppStreamOpen(data);
                break;
            }
        }
    }

    private int countOpenConnections() {
        int open_s2s_connections = this.incoming.size();
        for (Map.Entry<String, ServerConnections> entry : this.connectionsByLocalRemote.entrySet()) {
            ServerConnections conn = entry.getValue();
            if (!conn.isOutgoingConnected()) continue;
            ++open_s2s_connections;
        }
        return open_s2s_connections;
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        int waiting_packets = 0;
        int open_s2s_connections = this.incoming.size();
        int connected_servers = 0;
        int server_connections_instances = this.connectionsByLocalRemote.size();
        for (Map.Entry<String, ServerConnections> entry : this.connectionsByLocalRemote.entrySet()) {
            ServerConnections conn = entry.getValue();
            waiting_packets += conn.getWaitingPackets().size();
            if (conn.isOutgoingConnected()) {
                ++open_s2s_connections;
                ++connected_servers;
            }
            log.finest("s2s instance: " + entry.getKey() + ", waitingQueue: " + conn.getWaitingPackets().size() + ", outgoingIsNull(): " + conn.outgoingIsNull() + ", outgoingActive: " + conn.isOutgoingConnected() + ", OutgoingState: " + conn.getOutgoingState().toString() + ", db_keys.size(): " + conn.getDBKeysSize());
        }
        stats.add(new StatRecord(this.getName(), "Open s2s connections", "int", open_s2s_connections, Level.INFO));
        stats.add(new StatRecord(this.getName(), "Packets queued", "int", waiting_packets, Level.INFO));
        stats.add(new StatRecord(this.getName(), "Connected servers", "int", connected_servers, Level.FINE));
        stats.add(new StatRecord(this.getName(), "Connection instances", "int", server_connections_instances, Level.FINER));
        return stats;
    }

    @Override
    public void serviceStopped(XMPPIOService serv) {
        super.serviceStopped(serv);
        switch (serv.connectionType()) {
            case connect: {
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                if (remote_hostname == null) {
                    log.info("remote-hostname is NULL, local-hostname: " + local_hostname + ", local address: " + serv.getLocalAddress() + ", remote address: " + serv.getRemoteAddress());
                    break;
                }
                String cid = this.getConnectionId(local_hostname, remote_hostname);
                ServerConnections serv_conns = this.getServerConnections(cid);
                if (serv_conns == null) {
                    log.warning("There is no ServerConnections for stopped service: " + serv.getUniqueId() + ", cid: " + cid);
                    log.finest("Counters: ioservices: " + this.countIOServices() + ", s2s connections: " + this.countOpenConnections());
                    return;
                }
                serv_conns.serviceStopped(serv);
                Queue<Packet> waiting = serv_conns.getWaitingPackets();
                if (waiting.size() <= 0) break;
                if (serv_conns.waitingTime() > this.maxPacketWaitingTime) {
                    this.bouncePacketsBack(Authorization.REMOTE_SERVER_TIMEOUT, cid);
                    break;
                }
                this.createServerConnection(cid, null, serv_conns);
                break;
            }
            case accept: {
                String session_id = (String)serv.getSessionData().get("sessionID");
                if (session_id != null) {
                    XMPPIOService rem = this.incoming.remove(session_id);
                    if (rem == null) {
                        log.fine("No service with given SESSION_ID: " + session_id);
                        break;
                    }
                    log.finer("Connection removed: " + session_id);
                    break;
                }
                log.fine("session_id is null, didn't remove the connection");
                break;
            }
            default: {
                log.severe("Warning, program shouldn't reach that point.");
            }
        }
        log.finest("Counters: ioservices: " + this.countIOServices() + ", s2s connections: " + this.countOpenConnections());
    }

    private void generateStreamError(String error_el, XMPPIOService serv) {
        Element error = new Element("stream:error", new Element[]{new Element(error_el, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-streams"})}, null, null);
        try {
            this.writeRawData(serv, error.toString());
            serv.stop();
        }
        catch (Exception e) {
            serv.forceStop();
        }
    }

    public synchronized void processDialback(Packet packet, XMPPIOService serv) {
        Element elem;
        String serv_cid;
        log.finest("DIALBACK - " + packet.getStringData());
        String local_hostname = JIDUtils.getNodeHost((String)packet.getElemTo());
        if (!this.isLocalDomainOrComponent(local_hostname)) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        String remote_hostname = JIDUtils.getNodeHost((String)packet.getElemFrom());
        if (this.isLocalDomainOrComponent(remote_hostname)) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        String cid = this.getConnectionId(local_hostname, remote_hostname);
        ServerConnections serv_conns = this.getServerConnections(cid);
        String session_id = (String)serv.getSessionData().get("sessionID");
        String serv_local_hostname = (String)serv.getSessionData().get("local-hostname");
        String serv_remote_hostname = (String)serv.getSessionData().get("remote-hostname");
        String string = serv_cid = serv_remote_hostname == null ? null : this.getConnectionId(serv_local_hostname, serv_remote_hostname);
        if (serv_cid != null && !cid.equals(serv_cid)) {
            log.info("Somebody tries to reuse connection? old_cid: " + serv_cid + ", new_cid: " + cid);
        }
        if (packet.getElemName() == RESULT_EL_NAME || packet.getElemName() == DB_RESULT_EL_NAME) {
            if (packet.getType() == null) {
                if (packet.getElemCData() != null) {
                    String db_key = packet.getElemCData();
                    elem = new Element(DB_VERIFY_EL_NAME, db_key, new String[]{"id", "to", "from", XMLNS_DB_ATT}, new String[]{session_id, remote_hostname, local_hostname, XMLNS_DB_VAL});
                    Packet result = new Packet(elem);
                    if (serv_conns == null) {
                        serv_conns = this.createNewServerConnections(cid, null);
                    }
                    serv.getSessionData().put("remote-hostname", remote_hostname);
                    serv.getSessionData().put("local-hostname", local_hostname);
                    log.finest("cid: " + cid + ", sessionId: " + session_id + ", Counters: ioservices: " + this.countIOServices() + ", s2s connections: " + this.countOpenConnections());
                    if (!serv_conns.sendControlPacket(result) && serv_conns.needsConnection()) {
                        this.createServerConnection(cid, result, serv_conns);
                    }
                } else {
                    log.finer("Incorrect diablack packet: " + packet.getStringData());
                    this.bouncePacketsBack(Authorization.SERVICE_UNAVAILABLE, cid);
                    this.generateStreamError("bad-format", serv);
                }
            } else {
                switch (packet.getType()) {
                    case valid: {
                        log.finer("Connection: " + cid + " is valid, adding to available services.");
                        serv_conns.handleDialbackSuccess();
                        break;
                    }
                    default: {
                        log.finer("Connection: " + cid + " is invalid!! Stopping...");
                        serv_conns.handleDialbackFailure();
                    }
                }
            }
        }
        if (packet.getElemName() == VERIFY_EL_NAME || packet.getElemName() == DB_VERIFY_EL_NAME) {
            if (packet.getElemId() != null) {
                String forkey_session_id = packet.getElemId();
                if (packet.getType() == null) {
                    if (packet.getElemId() != null && packet.getElemCData() != null) {
                        String db_key = packet.getElemCData();
                        String local_key = this.getLocalDBKey(cid, db_key, forkey_session_id, session_id);
                        if (local_key == null) {
                            log.fine("db key is not availablefor session ID: " + forkey_session_id + ", key for validation: " + db_key);
                        } else {
                            log.fine("Local key for cid=" + cid + " is " + local_key);
                            this.sendVerifyResult(local_hostname, remote_hostname, forkey_session_id, db_key.equals(local_key), serv_conns, session_id);
                        }
                    }
                } else {
                    elem = new Element(DB_RESULT_EL_NAME, new String[]{"type", "to", "from", XMLNS_DB_ATT}, new String[]{packet.getType().toString(), remote_hostname, local_hostname, XMLNS_DB_VAL});
                    this.sendToIncoming(forkey_session_id, new Packet(elem));
                    this.validateIncoming(forkey_session_id, packet.getType() == StanzaType.valid);
                }
            } else {
                log.finer("Incorrect diablack packet: " + packet.getStringData());
                this.bouncePacketsBack(Authorization.SERVICE_UNAVAILABLE, cid);
                this.generateStreamError("bad-format", serv);
            }
        }
    }

    public boolean sendToIncoming(String session_id, Packet packet) {
        XMPPIOService serv = this.incoming.get(session_id);
        if (serv != null) {
            log.finest("Sending to incoming connectin: " + session_id + " packet: " + packet.toString());
            return this.writePacketToSocket(serv, packet);
        }
        log.finer("Trying to send packet: " + packet.toString() + " to nonexisten connection with sessionId: " + session_id);
        return false;
    }

    public void validateIncoming(String session_id, boolean valid) {
        XMPPIOService serv = this.incoming.get(session_id);
        if (serv != null) {
            serv.getSessionData().put("valid", valid);
            if (!valid) {
                serv.stop();
            }
        }
    }

    protected String getLocalDBKey(String cid, String key, String forkey_sessionId, String asking_sessionId) {
        ServerConnections serv_conns = this.getServerConnections(cid);
        return serv_conns == null ? null : serv_conns.getDBKey(forkey_sessionId);
    }

    protected void sendVerifyResult(String from, String to, String forkey_sessionId, boolean valid, ServerConnections serv_conns, String asking_sessionId) {
        String type = valid ? "valid" : "invalid";
        Element result_el = new Element(DB_VERIFY_EL_NAME, new String[]{"from", "to", "id", "type", XMLNS_DB_ATT}, new String[]{from, to, forkey_sessionId, type, XMLNS_DB_VAL});
        Packet result = new Packet(result_el);
        if (!this.sendToIncoming(asking_sessionId, result)) {
            log.warning("Can not send verification packet back: " + result.toString());
        }
    }

    @Override
    protected long getMaxInactiveTime() {
        return 900000L;
    }

    @Override
    protected XMPPIOService getXMPPIOServiceInstance() {
        return new XMPPIOService();
    }

    private class ConnectionWatchdogTask
    extends TimerTask {
        private ServerConnections conns = null;
        private String localhost = null;
        private String remotehost = null;

        private ConnectionWatchdogTask(ServerConnections conns, String localhost, String remotehost) {
            this.conns = conns;
            this.localhost = localhost;
            this.remotehost = remotehost;
        }

        @Override
        public void run() {
            if (this.conns.getOutgoingState() == ServerConnections.OutgoingState.CONNECTING) {
                log.finest("Connecting timeout expired, still connecting: " + this.conns.getCID());
                Queue<Packet> waiting = this.conns.getWaitingPackets();
                if (waiting.size() > 0) {
                    if (this.conns.waitingTime() > ServerConnectionManager.this.maxPacketWaitingTime) {
                        log.finest("Max packets waiting time expired, sending all back: " + this.conns.getCID());
                        this.conns.stopAll();
                        ServerConnectionManager.this.bouncePacketsBack(Authorization.REMOTE_SERVER_TIMEOUT, this.conns.getCID());
                    } else {
                        log.finest("Reconnecting: " + this.conns.getCID());
                        ServerConnectionManager.this.createServerConnection(this.conns.getCID(), null, this.conns);
                    }
                } else {
                    this.conns.stopAll();
                    log.finest("No packets waiting in queue, giving up: " + this.conns.getCID());
                }
            } else {
                log.finest("Connecting timeout expired: " + this.conns.getCID() + ", connection state is: " + (Object)((Object)this.conns.getOutgoingState()));
            }
        }
    }
}

