/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.RepoRosterTask;
import tigase.server.sreceiver.sysmon.ResourceMonitorIfc;
import tigase.util.ClassUtil;
import tigase.xmpp.StanzaType;

public class SystemMonitorTask
extends RepoRosterTask {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.sysmon.SystemMonitorTask");
    private static final String TASK_TYPE = "System Monitor";
    private static final String TASK_HELP = "This is a system monitor task. It monitors system resources usage and sends notifications to subscribed users. It allos responds to your messages with a simple reply message. This is to ensure the monitor works.";
    private static final String MONITORS_CLASSES_PROP_KEY = "Monitor implementations";
    private static final String WARNING_TRESHOLD_PROP_KEY = "Warning treshold";
    private String[] all_monitors = null;
    private String[] selected_monitors = null;
    private Map<String, ResourceMonitorIfc> monitors = new LinkedHashMap<String, ResourceMonitorIfc>();
    private double warning_treshold = 0.9;
    private Timer tasks = null;

    public SystemMonitorTask() {
        try {
            Set mons = ClassUtil.getImplementations(ResourceMonitorIfc.class);
            this.all_monitors = new String[mons.size()];
            int idx = 0;
            for (ResourceMonitorIfc monitor : mons) {
                this.all_monitors[idx++] = monitor.getClass().getName();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can't load resource monitors implementations", ex);
            this.all_monitors = new String[2];
            this.all_monitors[0] = "tigase.server.sreceiver.sysmon.CPUMonitor";
            this.all_monitors[1] = "tigase.server.sreceiver.sysmon.MemMonitor";
        }
    }

    protected void sendPacketsOut(Queue<Packet> input) {
        LinkedList<Packet> results = new LinkedList<Packet>();
        for (Packet packet : input) {
            if (packet.getElemName() == "message" || packet.getElemTo() == null || packet.getElemTo().isEmpty()) {
                super.processMessage(packet, results);
                continue;
            }
            results.add(packet);
        }
        for (Packet packet : results) {
            this.addOutPacket(packet);
        }
    }

    protected void sendPacketOut(Packet input) {
        LinkedList<Packet> results = new LinkedList<Packet>();
        if (input.getElemName() == "message" || input.getElemTo() == null || input.getElemTo().isEmpty()) {
            super.processMessage(input, results);
        } else {
            results.add(input);
        }
        for (Packet packet : results) {
            this.addOutPacket(packet);
        }
    }

    private void monitor10Secs() {
        LinkedList<Packet> results = new LinkedList<Packet>();
        for (ResourceMonitorIfc monitor : this.monitors.values()) {
            monitor.check10Secs(results);
        }
        this.sendPacketsOut(results);
    }

    private void monitor1Min() {
        LinkedList<Packet> results = new LinkedList<Packet>();
        for (ResourceMonitorIfc monitor : this.monitors.values()) {
            monitor.check1Min(results);
        }
        this.sendPacketsOut(results);
    }

    private void monitor1Hour() {
        LinkedList<Packet> results = new LinkedList<Packet>();
        for (ResourceMonitorIfc monitor : this.monitors.values()) {
            monitor.check1Hour(results);
        }
        this.sendPacketsOut(results);
    }

    private void monitor1Day() {
        LinkedList<Packet> results = new LinkedList<Packet>();
        for (ResourceMonitorIfc monitor : this.monitors.values()) {
            monitor.check1Day(results);
        }
        this.sendPacketsOut(results);
    }

    @Override
    public void init(Queue<Packet> results) {
        super.init(results);
        this.tasks = new Timer("SystemMonitorTask", true);
        this.tasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SystemMonitorTask.this.monitor10Secs();
            }
        }, 10000L, 10000L);
        this.tasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SystemMonitorTask.this.monitor1Min();
            }
        }, 60000L, 60000L);
        this.tasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SystemMonitorTask.this.monitor1Hour();
            }
        }, 3600000L, 3600000L);
        this.tasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SystemMonitorTask.this.monitor1Day();
            }
        }, 86400000L, 86400000L);
    }

    @Override
    public void destroy(Queue<Packet> results) {
        this.tasks.cancel();
        this.tasks = null;
        super.destroy(results);
    }

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    private String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        for (ResourceMonitorIfc monitor : this.monitors.values()) {
            sb.append(monitor.commandsHelp());
        }
        return "Available commands are:\n" + sb.toString();
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCData("/message/body");
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private ResourceMonitorIfc monitorForCommand(Packet packet) {
        String body = packet.getElemCData("/message/body");
        if (body != null) {
            for (ResourceMonitorIfc monitor : this.monitors.values()) {
                if (!monitor.isMonitorCommand(body)) continue;
                return monitor;
            }
        }
        return null;
    }

    @Override
    public void setParams(Map<String, Object> map) {
        super.setParams(map);
        String treshold = (String)map.get(WARNING_TRESHOLD_PROP_KEY);
        try {
            double tresh;
            this.warning_treshold = tresh = Double.parseDouble(treshold);
        }
        catch (Exception e) {
            log.warning("Incorrect warning treshold, using default" + treshold);
        }
        String[] mons = null;
        try {
            mons = (String[])map.get(MONITORS_CLASSES_PROP_KEY);
        }
        catch (Exception e) {
            log.warning("Incorrect monitors list: " + map.get(MONITORS_CLASSES_PROP_KEY));
            mons = this.all_monitors;
        }
        if (mons != null) {
            this.selected_monitors = mons;
            this.monitors.clear();
            for (String string : mons) {
                try {
                    ResourceMonitorIfc resMon = (ResourceMonitorIfc)Class.forName(string).newInstance();
                    String monJid = this.getJID() + "/" + resMon.getClass().getSimpleName();
                    resMon.init(monJid, this.warning_treshold, this);
                    this.monitors.put(monJid, resMon);
                    log.config("Loaded resource monitor: " + monJid);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Can't instantiate resource monitor: " + string, ex);
                }
            }
        }
    }

    @Override
    public Map<String, PropertyItem> getParams() {
        Map<String, PropertyItem> props = super.getParams();
        props.put(MONITORS_CLASSES_PROP_KEY, new PropertyItem(MONITORS_CLASSES_PROP_KEY, MONITORS_CLASSES_PROP_KEY, this.selected_monitors, this.all_monitors, "List of system monitors available for use"));
        props.put(WARNING_TRESHOLD_PROP_KEY, new PropertyItem(WARNING_TRESHOLD_PROP_KEY, WARNING_TRESHOLD_PROP_KEY, this.warning_treshold));
        return props;
    }

    @Override
    public Map<String, PropertyItem> getDefaultParams() {
        Map<String, PropertyItem> defs = super.getDefaultParams();
        defs.put("description", new PropertyItem("description", "Description", "System Monitor Task"));
        defs.put("message-type", new PropertyItem("message-type", "Message type", PropertyConstants.MessageType.NORMAL));
        defs.put("online-users-only", new PropertyItem("online-users-only", "Send to online users only", false));
        defs.put("replace-sender", new PropertyItem("replace-sender", "Replace sender address", PropertyConstants.SenderAddress.REPLACE_SRECV));
        defs.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", PropertyConstants.SubscrRestrictions.MODERATED));
        defs.put(MONITORS_CLASSES_PROP_KEY, new PropertyItem(MONITORS_CLASSES_PROP_KEY, MONITORS_CLASSES_PROP_KEY, this.all_monitors, this.all_monitors, "List of system monitors available for use"));
        defs.put(WARNING_TRESHOLD_PROP_KEY, new PropertyItem(WARNING_TRESHOLD_PROP_KEY, WARNING_TRESHOLD_PROP_KEY, this.warning_treshold));
        return defs;
    }

    private void runCommand(Packet packet, Queue<Packet> results) {
        String body = packet.getElemCData("/message/body");
        String[] body_split = body.split("\\s");
        command comm = command.valueOf(body_split[0].substring(2));
        switch (comm) {
            case help: {
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, this.commandsHelp(), "Commands description", null));
                break;
            }
            case state: {
                StringBuilder sb = new StringBuilder("\n");
                for (ResourceMonitorIfc resmon : this.monitors.values()) {
                    sb.append(resmon.getClass().getSimpleName() + ":\n");
                    sb.append(resmon.getState() + "\n");
                }
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, sb.toString(), "Monitors State", null));
                break;
            }
            case treshold: {
                if (body_split.length > 1) {
                    boolean correct = false;
                    try {
                        double newtreshold = Double.parseDouble(body_split[1]);
                        if (newtreshold > 0.0 && newtreshold < 1.0) {
                            this.warning_treshold = newtreshold;
                            for (Map.Entry<String, ResourceMonitorIfc> resmon : this.monitors.entrySet()) {
                                resmon.getValue().init(resmon.getKey(), this.warning_treshold, this);
                            }
                            correct = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (correct) {
                        results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "New treshold set to: " + this.warning_treshold + "\n", "Threshold command.", null));
                        break;
                    }
                    results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Incorrect treshold givenm using the old treshold: " + this.warning_treshold + "\n" + "Correct treshold is a float point number 0 < N < 1.", "Threshold command.", null));
                    break;
                }
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, "Current treshold value is: " + this.warning_treshold, "Threshold command.", null));
            }
        }
    }

    private void runMonitorCommand(ResourceMonitorIfc monitor, Packet packet, Queue<Packet> results) {
        String body = packet.getElemCData("/message/body");
        String[] body_split = body.split("\\s");
        String result = monitor.runCommand(body_split);
        if (result == null) {
            result = "Monitor " + monitor.getClass().getSimpleName() + " command was run but returned no results.";
        }
        results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, result, monitor.getClass().getSimpleName() + " command.", null));
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        } else {
            ResourceMonitorIfc monitor = this.monitorForCommand(packet);
            if (monitor != null) {
                this.runMonitorCommand(monitor, packet, results);
            } else {
                String body = packet.getElemCData("/message/body");
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.normal, "This is response to your message: [" + body + "]", "Response", null));
            }
        }
    }

    private static enum command {
        help(" - Displays help info."),
        state(" - Displays current state from all monitors."),
        treshold(" [0.NN] - sets/displays current treshold value.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

