/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;

public class MemMonitor
extends AbstractMonitor
implements NotificationListener {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.sysmon.MemMonitor");
    private MemoryMXBean memoryMXBean = null;

    @Override
    public void init(String jid, double treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)this.memoryMXBean);
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memPools) {
            try {
                emitter.removeNotificationListener(this, null, memoryPoolMXBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            MemoryUsage memUsage = memoryPoolMXBean.getUsage();
            if (memUsage != null) {
                if (memoryPoolMXBean.isUsageThresholdSupported()) {
                    emitter.addNotificationListener(this, null, memoryPoolMXBean);
                    long memUsageTreshold = new Double(new Long(memUsage.getMax()).doubleValue() * treshold).longValue();
                    memoryPoolMXBean.setUsageThreshold(memUsageTreshold);
                    log.config("Setting treshold: " + memUsageTreshold + " for memory pool: " + memoryPoolMXBean.getName() + ", type: " + memoryPoolMXBean.getType().toString() + ", memMax: " + memUsage.getMax() + ", memUsed: " + memUsage.getUsed() + ", config treeshold: " + treshold);
                    if (memUsage.getUsed() <= memUsageTreshold) continue;
                    Notification not = new Notification("java.management.memory.threshold.exceeded", this, 1L);
                    this.handleNotification(not, memoryPoolMXBean);
                    continue;
                }
                log.config("Memory pool name: " + memoryPoolMXBean.getName() + ", type: " + memoryPoolMXBean.getType().toString() + " usage threshold is not supported.");
                continue;
            }
            log.config("Memory pool name: " + memoryPoolMXBean.getName() + ", type: " + memoryPoolMXBean.getType().toString() + " is invalid.");
        }
    }

    @Override
    public void handleNotification(Notification note, Object handback) {
        if (note.getType().equals("java.management.memory.threshold.exceeded")) {
            log.info("Usage threshold exceeded, sending notification.");
            NumberFormat format = NumberFormat.getIntegerInstance();
            if (format instanceof DecimalFormat) {
                DecimalFormat decf = (DecimalFormat)format;
                decf.applyPattern(decf.toPattern() + " KB");
            }
            MemoryPoolMXBean memoryPoolMXBean = (MemoryPoolMXBean)handback;
            String message = "Threshold " + format.format(memoryPoolMXBean.getUsageThreshold() / 1024L) + " for memory pool: " + memoryPoolMXBean.getName() + ", type: " + memoryPoolMXBean.getType().toString() + " exceeded.";
            this.sendWarningOut(message, handback);
        }
    }

    @Override
    public String getState() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        if (format instanceof DecimalFormat) {
            DecimalFormat decf = (DecimalFormat)format;
            decf.applyPattern(decf.toPattern() + " KB");
        }
        NumberFormat formp = NumberFormat.getPercentInstance();
        formp.setMaximumFractionDigits(2);
        StringBuilder sb = new StringBuilder();
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memPools) {
            MemoryUsage memUsage = memoryPoolMXBean.getUsage();
            if (memUsage == null || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
            sb.append("Memory pool: " + memoryPoolMXBean.getName() + ", type: " + memoryPoolMXBean.getType().toString() + ", usage: " + format.format(memUsage.getUsed() / 1024L) + " of " + format.format(memUsage.getMax() / 1024L) + " - " + formp.format(new Long(memUsage.getUsed()).doubleValue() / new Long(memUsage.getMax()).doubleValue()) + ", treshold: " + format.format(memoryPoolMXBean.getUsageThreshold() / 1024L) + "\n");
        }
        return sb.toString();
    }
}

