/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.Queue;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;

public class CPUMonitor
extends AbstractMonitor {
    private int historySize = 100;
    private long lastCPUUsage = 0L;
    private double[] cpuUsage = new double[this.historySize];
    private int cpuUsageIdx = 0;
    private double[] loadAverage = new double[this.historySize];
    private int loadAverageIdx = 0;
    private ThreadMXBean thBean = null;
    private OperatingSystemMXBean osBean = null;
    private NumberFormat format = NumberFormat.getPercentInstance();

    @Override
    public void init(String jid, double treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.thBean = ManagementFactory.getThreadMXBean();
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.format.setMaximumFractionDigits(2);
    }

    @Override
    public void check10Secs(Queue<Packet> results) {
        long cpuTime = 0L;
        for (long thid : this.thBean.getAllThreadIds()) {
            cpuTime += this.thBean.getThreadCpuTime(thid);
        }
        long tmpCPU = this.lastCPUUsage;
        this.lastCPUUsage = cpuTime;
        double totalUsage = new Long(cpuTime -= tmpCPU).doubleValue() / 1000000.0 / new Long(10000L).doubleValue();
        this.cpuUsageIdx = this.setValueInArr(this.cpuUsage, this.cpuUsageIdx, totalUsage);
        this.loadAverageIdx = this.setValueInArr(this.loadAverage, this.loadAverageIdx, this.osBean.getSystemLoadAverage());
        if (totalUsage > this.treshold && this.recentCpu(6) > this.treshold) {
            this.prepareWarning("High CPU usage in last minute: " + this.format.format(this.recentCpu(6)), results, this);
        } else {
            this.prepareCalmDown("CPU usage is now low again: " + this.format.format(totalUsage), results, this);
        }
    }

    private double recentCpu(int histCheck) {
        double recentCpu = 0.0;
        int idx = this.cpuUsageIdx;
        for (int i = 0; i < histCheck; ++i) {
            if ((idx -= i) < 0) {
                idx = this.cpuUsage.length - 1;
            }
            recentCpu += this.cpuUsage[idx];
        }
        return recentCpu / (double)histCheck;
    }

    @Override
    public String getState() {
        int idx = this.cpuUsageIdx - 1;
        if (idx < 0) {
            idx = this.cpuUsage.length - 1;
        }
        NumberFormat formd = NumberFormat.getNumberInstance();
        formd.setMaximumFractionDigits(4);
        return "Current CPU usage is: " + this.format.format(this.cpuUsage[idx]) + ", Last minute CPU usage is: " + this.format.format(this.recentCpu(6)) + ", Load average is: " + formd.format(this.loadAverage[idx]) + "\n";
    }
}

