/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.ReceiverTaskIfc;
import tigase.server.sreceiver.RosterItem;
import tigase.server.sreceiver.StanzaReceiverIfc;
import tigase.server.sreceiver.TaskCommons;
import tigase.stats.StatRecord;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public abstract class AbstractReceiverTask
implements ReceiverTaskIfc {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.AbstractReceiverTask");
    private String jid = null;
    private String name = null;
    private String local_domain = null;
    private String description = null;
    private Map<String, PropertyItem> props = null;
    private PropertyConstants.SubscrRestrictions subsc_restr = PropertyConstants.SUBSCR_RESTRICTIONS_PROP_VAL;
    private PropertyConstants.SenderRestrictions send_restr = PropertyConstants.ALLOWED_SENDERS_PROP_VAL;
    private PropertyConstants.MessageType message_type = PropertyConstants.MESSAGE_TYPE_PROP_VAL;
    private boolean send_to_online_only = PropertyConstants.ONLINE_ONLY_PROP_VAL;
    private PropertyConstants.SenderAddress replace_sender_address = PropertyConstants.REPLACE_SENDER_PROP_VAL;
    private Pattern subscr_restr_regex = Pattern.compile(".*");
    private String owner = "admin@localhost";
    private String[] admins = new String[0];
    private StanzaReceiverIfc srecv = null;
    private long packets_received = 0L;
    private long packets_sent = 0L;
    private Map<String, RosterItem> roster = new HashMap<String, RosterItem>();

    @Override
    public void setStanzaReceiver(StanzaReceiverIfc srecv) {
        this.srecv = srecv;
    }

    protected boolean addOutPacket(Packet packet) {
        return this.srecv.addOutPacket(packet);
    }

    @Override
    public ReceiverTaskIfc getInstance() {
        try {
            return (ReceiverTaskIfc)this.getClass().newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't instantiate receiver task: " + this.getClass().getName(), e);
            return null;
        }
    }

    @Override
    public void setJID(String jid) {
        this.jid = jid;
        log.fine("JID set to: " + this.jid);
        int idx = jid.indexOf(".");
        this.local_domain = jid.substring(idx + 1);
        log.fine("Local domain set to: " + this.local_domain);
        this.name = JIDUtils.getNodeNick((String)jid);
    }

    @Override
    public String getJID() {
        return this.jid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isAllowedToSubscribe(String buddy) {
        boolean result = false;
        switch (this.subsc_restr) {
            case LOCAL: {
                String buddy_domain = JIDUtils.getNodeHost((String)buddy);
                if (!buddy_domain.equals(this.local_domain)) break;
                result = true;
                break;
            }
            case REGEX: {
                result = this.subscr_restr_regex.matcher(buddy).matches();
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    public boolean isAllowedToPost(String buddy) {
        boolean result = false;
        RosterItem ri = this.getRosterItem(buddy);
        switch (this.send_restr) {
            case SUBSCRIBED: {
                result = ri != null && ri.isSubscribed() && ri.isModerationAccepted();
                break;
            }
            case OWNER: {
                result = ri != null && ri.isOwner();
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    public void addToRoster(RosterItem ri) {
        this.roster.put(ri.getJid(), ri);
    }

    public RosterItem addToRoster(String jid) {
        String id = JIDUtils.getNodeID((String)jid);
        RosterItem ri = new RosterItem(id);
        if (id.equals(this.owner)) {
            ri.setOwner(true);
        }
        if (this.subsc_restr != PropertyConstants.SubscrRestrictions.MODERATED) {
            ri.setModerationAccepted(true);
        }
        this.addToRoster(ri);
        return ri;
    }

    public RosterItem removeFromRoster(String jid) {
        return this.roster.remove(JIDUtils.getNodeID((String)jid));
    }

    public RosterItem getRosterItem(String jid) {
        return this.roster.get(JIDUtils.getNodeID((String)jid));
    }

    public void setRosterItemOnline(RosterItem ri, boolean online) {
        ri.setOnline(online);
    }

    public void setRosterItemAdmin(RosterItem ri, boolean admin) {
        ri.setAdmin(admin);
    }

    public void setRosterItemOwner(RosterItem ri, boolean owner) {
        ri.setOwner(owner);
    }

    public void setRosterItemSubscribed(RosterItem ri, boolean subscribed) {
        log.fine(this.getJID() + ": " + "Updating subscription for " + ri.getJid() + " to " + subscribed);
        ri.setSubscribed(subscribed);
    }

    @Override
    public void setRosterItemModerationAccepted(RosterItem ri, boolean accepted) {
        ri.setModerationAccepted(accepted);
    }

    public void addNewSubscribers(Queue<Packet> results, String ... new_subscr) {
        for (String buddy : new_subscr) {
            Packet presence = null;
            if (this.isAllowedToSubscribe(buddy)) {
                if (this.getRosterItem(buddy) == null) {
                    this.addToRoster(buddy);
                }
                log.info(this.getJID() + ": " + "Adding buddy to roster: " + buddy);
                presence = TaskCommons.getPresence(buddy, this.jid, StanzaType.subscribe, JIDUtils.getNodeNick((String)this.jid), null);
            } else {
                log.info(this.getJID() + ": " + "Not allowed to subscribe, rejecting: " + buddy);
                presence = TaskCommons.getPresence(buddy, this.jid, StanzaType.unsubscribed);
            }
            log.finest(this.getJID() + ": " + "Sending back: " + presence.toString());
            results.offer(presence);
        }
    }

    @Override
    public void removeSubscribers(Queue<Packet> results, String ... subscr) {
        for (String buddy : subscr) {
            RosterItem ri = this.removeFromRoster(buddy);
            if (ri == null) continue;
            log.info(this.getJID() + ": " + "Removing buddy from roster: " + buddy);
            results.offer(TaskCommons.getPresence(buddy, this.jid, StanzaType.unsubscribed));
        }
    }

    @Override
    public void setParams(Map<String, Object> map) {
        String tmp;
        if (this.props == null) {
            this.props = new TreeMap<String, PropertyItem>();
        }
        if (map.get("description") != null) {
            this.description = (String)map.get("description");
            this.props.put("description", new PropertyItem("description", "Description", this.description));
        }
        if (map.get("subscription-restr-regex") != null) {
            this.subscr_restr_regex = Pattern.compile((String)map.get("subscription-restr-regex"));
            this.props.put("subscription-restr-regex", new PropertyItem("subscription-restr-regex", "Subscription restrictions regex", this.subscr_restr_regex));
        }
        if ((tmp = (String)map.get("subscription-restr")) != null) {
            this.subsc_restr = PropertyConstants.SubscrRestrictions.valueOf(tmp);
            this.props.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", this.subsc_restr));
        }
        if ((tmp = (String)map.get("allowed-senders")) != null) {
            this.send_restr = PropertyConstants.SenderRestrictions.valueOf(tmp);
            this.props.put("allowed-senders", new PropertyItem("allowed-senders", "Allowed senders", this.send_restr));
        }
        if ((tmp = (String)map.get("message-type")) != null) {
            this.message_type = PropertyConstants.MessageType.valueOf(tmp);
            this.props.put("message-type", new PropertyItem("message-type", "Message type", this.message_type));
        }
        if (map.get("online-users-only") != null) {
            this.send_to_online_only = TaskCommons.parseBool(map.get("online-users-only"));
            this.props.put("online-users-only", new PropertyItem("online-users-only", "Send to online users only", this.send_to_online_only));
        }
        if ((tmp = (String)map.get("replace-sender")) != null) {
            this.replace_sender_address = PropertyConstants.SenderAddress.valueOf(tmp);
            this.props.put("replace-sender", new PropertyItem("replace-sender", "Replace sender address", this.replace_sender_address));
        }
        if ((tmp = (String)map.get("task-owner")) != null && tmp.length() > 0) {
            this.owner = tmp.trim();
            RosterItem ri = this.getRosterItem(this.owner);
            if (ri == null) {
                ri = this.addToRoster(this.owner);
            }
            this.setRosterItemOwner(ri, true);
            this.setRosterItemAdmin(ri, true);
            this.setRosterItemModerationAccepted(ri, true);
            this.props.put("task-owner", new PropertyItem("task-owner", "Owner", this.owner));
        }
        if (this.props.get("task-owner") == null) {
            this.props.put("task-owner", new PropertyItem("task-owner", "Owner", ""));
        }
        if ((tmp = (String)map.get("task-admins")) != null && tmp.length() > 0) {
            for (String admin : this.admins = tmp.split(",")) {
                RosterItem ri = this.getRosterItem(admin.trim());
                if (ri == null) {
                    ri = this.addToRoster(admin.trim());
                }
                this.setRosterItemAdmin(ri, true);
                this.setRosterItemModerationAccepted(ri, true);
            }
            this.props.put("task-admins", new PropertyItem("task-admins", "Administrators", tmp));
        }
        if (this.props.get("task-admins") == null) {
            this.props.put("task-admins", new PropertyItem("task-admins", "Administrators", ""));
        }
    }

    @Override
    public Map<String, PropertyItem> getParams() {
        return this.props;
    }

    @Override
    public Map<String, PropertyItem> getDefaultParams() {
        TreeMap<String, PropertyItem> defs = new TreeMap<String, PropertyItem>();
        defs.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", PropertyConstants.SUBSCR_RESTRICTIONS_PROP_VAL));
        defs.put("message-type", new PropertyItem("message-type", "Message type", PropertyConstants.MESSAGE_TYPE_PROP_VAL));
        defs.put("allowed-senders", new PropertyItem("allowed-senders", "Allowed senders", PropertyConstants.ALLOWED_SENDERS_PROP_VAL));
        defs.put("subscription-restr-regex", new PropertyItem("subscription-restr-regex", "Subscription restrictions regex", ".*"));
        defs.put("online-users-only", new PropertyItem("online-users-only", "Send to online users only", PropertyConstants.ONLINE_ONLY_PROP_VAL));
        defs.put("replace-sender", new PropertyItem("replace-sender", "Replace sender address", PropertyConstants.REPLACE_SENDER_PROP_VAL));
        defs.put("allowed-senders-list", new PropertyItem("allowed-senders-list", "List of users allowed to post", ""));
        defs.put("description", new PropertyItem("description", "Description", "News distribution task"));
        defs.put("task-admins", new PropertyItem("task-admins", "Administrators", ""));
        defs.put("task-owner", new PropertyItem("task-owner", "Owner", "admin@localhost"));
        return defs;
    }

    @Override
    public void init(Queue<Packet> results) {
        for (RosterItem ri : this.roster.values()) {
            Packet presence = null;
            presence = ri.isSubscribed() ? TaskCommons.getPresence(ri.getJid(), this.jid, StanzaType.available, null, this.getDescription()) : TaskCommons.getPresence(ri.getJid(), this.jid, StanzaType.subscribe, JIDUtils.getNodeNick((String)this.jid), null);
            results.offer(presence);
        }
    }

    @Override
    public void destroy(Queue<Packet> results) {
        for (RosterItem ri : this.roster.values()) {
            Packet presence = TaskCommons.getPresence(ri.getJid(), this.jid, StanzaType.unsubscribe);
            results.offer(presence);
            presence = TaskCommons.getPresence(ri.getJid(), this.jid, StanzaType.unsubscribed);
            results.offer(presence);
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        ++this.packets_received;
        log.finest(this.getJID() + ": " + "Processing packet: " + packet.toString());
        if (packet.getType() == StanzaType.error) {
            log.fine("Ignoring error stanza: " + packet.toString());
            return;
        }
        if (packet.getElemName().equals("presence")) {
            this.processPresence(packet, results);
        }
        if (packet.getElemName().equals("message")) {
            if (this.isAllowedToPost(JIDUtils.getNodeID((String)packet.getElemFrom()))) {
                this.processMessage(packet, results);
            } else {
                try {
                    results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You are not allowed to post a message.", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
            }
        }
        this.packets_sent += (long)results.size();
    }

    private void processPresence(Packet packet, Queue<Packet> results) {
        StanzaType presence_type = StanzaType.available;
        if (packet.getType() != null) {
            presence_type = packet.getType();
        }
        RosterItem ri = this.getRosterItem(packet.getElemFrom());
        switch (presence_type) {
            case available: 
            case probe: {
                if (ri == null) break;
                this.setRosterItemOnline(ri, true);
                results.offer(TaskCommons.getPresence(packet.getElemFrom(), this.jid, StanzaType.available, null, this.getDescription()));
                break;
            }
            case unavailable: {
                if (ri == null) break;
                this.setRosterItemOnline(ri, false);
                break;
            }
            case subscribe: {
                this.addNewSubscribers(results, packet.getElemFrom());
                results.offer(TaskCommons.getPresence(packet.getElemFrom(), this.jid, StanzaType.subscribed));
                break;
            }
            case subscribed: {
                if (ri == null) break;
                this.setRosterItemSubscribed(ri, true);
                results.offer(TaskCommons.getPresence(packet.getElemFrom(), this.jid, StanzaType.available, null, this.getDescription()));
                if (ri.isModerationAccepted()) break;
                results.offer(TaskCommons.getMessage(packet.getElemFrom(), this.jid, StanzaType.headline, "You are now subscribed to " + this.getJID() + ".\n\n" + "Your subscription, however awaits moderation.\n\n" + "Once your subscription is approved next message\n" + "will be sent confirming your membership."));
                break;
            }
            case unsubscribe: 
            case unsubscribed: {
                this.removeSubscribers(results, packet.getElemFrom());
                break;
            }
        }
    }

    protected void processMessage(Packet packet, Queue<Packet> results) {
        for (RosterItem ri : this.roster.values()) {
            if (!ri.isSubscribed() || !ri.isModerationAccepted() || this.send_to_online_only && !ri.isOnline() || JIDUtils.getNodeID((String)packet.getElemFrom()).equals(ri.getJid())) continue;
            Element message = packet.getElement().clone();
            Element body = message.getChild("body");
            if (body == null) {
                return;
            }
            message.setAttribute("to", ri.getJid());
            message.setAttribute("type", this.message_type.toString().toLowerCase());
            switch (this.replace_sender_address) {
                case REPLACE: {
                    String old_from = message.getAttribute("from");
                    message.setAttribute("from", this.jid);
                    String cdata = body.getCData();
                    body.setCData(old_from + " sends:\n\n" + cdata);
                    break;
                }
                case REMOVE: {
                    message.setAttribute("from", this.jid);
                    break;
                }
                case REPLACE_SRECV: {
                    String old_from = message.getAttribute("from");
                    message.setAttribute("from", JIDUtils.getJID((String)this.srecv.getName(), (String)this.local_domain, (String)this.name));
                    String cdata = body.getCData();
                    body.setCData(old_from + " sends for installation at " + this.srecv.getDefHostName() + ":\n\n" + cdata);
                    break;
                }
            }
            results.offer(new Packet(message));
        }
    }

    @Override
    public List<StatRecord> getStats() {
        LinkedList<StatRecord> stats = new LinkedList<StatRecord>();
        stats.add(new StatRecord(this.getJID(), "Roster size", "int", this.roster.size(), Level.INFO));
        stats.add(new StatRecord(this.getJID(), "Packets received", "long", this.packets_received, Level.INFO));
        stats.add(new StatRecord(this.getJID(), "Packets sent", "long", this.packets_sent, Level.INFO));
        int moderation_needed = 0;
        for (RosterItem ri : this.roster.values()) {
            moderation_needed += ri.isModerationAccepted() ? 0 : 1;
        }
        stats.add(new StatRecord(this.getJID(), "Awaiting moderation", "int", moderation_needed, Level.INFO));
        return stats;
    }

    @Override
    public boolean isAdmin(String jid) {
        RosterItem ri = this.getRosterItem(jid);
        return ri != null && (ri.isAdmin() || ri.isOwner());
    }

    @Override
    public Map<String, RosterItem> getRoster() {
        return this.roster;
    }
}

