/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.ComponentRegistrator;
import tigase.server.DisableDisco;
import tigase.server.MessageReceiver;
import tigase.server.MessageRouterConfig;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.stats.StatRecord;
import tigase.util.JIDUtils;
import tigase.util.UpdatesChecker;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class MessageRouter
extends AbstractMessageReceiver {
    public static final String INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    public static final String ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private static final Logger log = Logger.getLogger("tigase.server.MessageRouter");
    private String disco_name = "Tigase";
    private boolean disco_show_version = true;
    private ComponentRegistrator config = null;
    private ServiceEntity serviceEntity = null;
    private UpdatesChecker updates_checker = null;
    private Map<String, XMPPService> xmppServices = new ConcurrentSkipListMap<String, XMPPService>();
    private Map<String, ServerComponent> components = new ConcurrentSkipListMap<String, ServerComponent>();
    private Map<String, ServerComponent> components_byId = new ConcurrentSkipListMap<String, ServerComponent>();
    private Map<String, ComponentRegistrator> registrators = new ConcurrentSkipListMap<String, ComponentRegistrator>();
    private Map<String, MessageReceiver> receivers = new ConcurrentSkipListMap<String, MessageReceiver>();
    private boolean inProperties = false;

    public void processPacketMR(Packet packet, Queue<Packet> results) {
        if (packet.getPermissions() != Permissions.ADMIN) {
            try {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true);
                results.offer(res);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        log.finest("Command received: " + packet.getStringData());
        switch (packet.getCommand()) {
            case OTHER: {
                String[] spl;
                String cmd;
                if (packet.getStrCommand() == null || !packet.getStrCommand().startsWith("controll/") || !(cmd = (spl = packet.getStrCommand().split("/"))[1]).equals("stop")) break;
                Packet result = packet.commandResult("result");
                results.offer(result);
                new Timer("Stopping...", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 2000L);
                break;
            }
        }
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    private ServerComponent[] getServerComponentsForRegex(String id) {
        LinkedHashSet<MessageReceiver> comps = new LinkedHashSet<MessageReceiver>();
        for (MessageReceiver mr : this.receivers.values()) {
            if (!mr.isInRegexRoutings(id)) continue;
            log.finest("Found receiver: " + mr.getName());
            comps.add(mr);
        }
        if (comps.size() > 0) {
            return comps.toArray(new ServerComponent[comps.size()]);
        }
        return null;
    }

    private ServerComponent getLocalComponent(String jid) {
        ServerComponent comp = this.components_byId.get(jid);
        if (comp != null) {
            return comp;
        }
        String host = JIDUtils.getNodeHost((String)jid);
        String nick = JIDUtils.getNodeNick((String)jid);
        if (nick != null && (comp = this.components.get(nick)) != null && (this.isLocalDomain(host) || host.equals(this.getDefHostName()))) {
            return comp;
        }
        int idx = host.indexOf(46);
        if (idx > 0) {
            String cmpName = host.substring(0, idx);
            String basename = host.substring(idx + 1);
            if (comp == null) {
                comp = this.components.get(cmpName);
            }
            if (comp != null && (this.isLocalDomain(basename) || basename.equals(this.getDefHostName()))) {
                return comp;
            }
        }
        return null;
    }

    @Override
    public void processPacket(Packet packet) {
        ServerComponent comp;
        if (packet.getTo() == null) {
            log.warning("Packet with TO attribute set to NULL: " + packet.getStringData());
            return;
        }
        if (packet.getTo() == "NULL") {
            log.info("NULL routing, it is normal if server doesn't know how to process packet: " + packet.toString());
            try {
                Packet error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                this.addOutPacketNB(error);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (packet.getType() == StanzaType.error && packet.getFrom() != null && packet.getFrom().equals(packet.getTo()) || packet.getFrom() == "NULL" && packet.getElemFrom() != null && packet.getElemFrom().equals(packet.getTo())) {
            log.warning("Possible infinite loop, dropping packet: " + packet.toString());
            return;
        }
        ServerComponent serverComponent = comp = packet.getElemTo() == null ? null : this.getLocalComponent(packet.getElemTo());
        if (packet.isServiceDisco() && packet.getType() != null && packet.getType() == StanzaType.get && (comp != null && !(comp instanceof DisableDisco) || this.isLocalDomain(packet.getElemTo()))) {
            log.finest("Processing disco query by: " + this.getComponentId());
            LinkedList<Packet> results = new LinkedList<Packet>();
            this.processDiscoQuery(packet, results);
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        String id = JIDUtils.getNodeID((String)packet.getTo());
        comp = this.getLocalComponent(id);
        if (comp != null) {
            log.finest("Packet is processing by: " + comp.getComponentId());
            LinkedList<Packet> results = new LinkedList<Packet>();
            if (comp == this) {
                this.processPacketMR(packet, results);
            } else {
                comp.processPacket(packet, results);
            }
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        String host = JIDUtils.getNodeHost((String)packet.getTo());
        ServerComponent[] comps = this.getComponentsForLocalDomain(host);
        if (comps == null) {
            comps = this.getServerComponentsForRegex(id);
        }
        if (comps == null && !this.isLocalDomain(host)) {
            comps = this.getComponentsForNonLocalDomain(host);
        }
        if (comps != null) {
            LinkedList<Packet> results = new LinkedList<Packet>();
            for (ServerComponent serverComponent2 : comps) {
                log.finest("Packet processed by: " + serverComponent2.getComponentId());
                serverComponent2.processPacket(packet, results);
                if (results.size() <= 0) continue;
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
        } else {
            log.finest("There is no component for the packet, sending it back");
            try {
                this.addOutPacketNB(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "There is no service found to process your request.", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Can't process packet to local domain, dropping..." + packet.toString());
            }
        }
    }

    private ServerComponent[] getComponentsForLocalDomain(String domain) {
        return this.vHostManager.getComponentsForLocalDomain(domain);
    }

    private ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        return this.vHostManager.getComponentsForNonLocalDomain(domain);
    }

    public void setConfig(ComponentRegistrator config) {
        this.components.put(this.getName(), this);
        this.config = config;
        this.addRegistrator(config);
    }

    public void addRegistrator(ComponentRegistrator registr) {
        log.info("Adding registrator: " + registr.getClass().getSimpleName());
        this.registrators.put(registr.getName(), registr);
        this.addComponent(registr);
        for (ServerComponent comp : this.components.values()) {
            registr.addComponent(comp);
        }
    }

    public void addRouter(MessageReceiver receiver) {
        log.info("Adding receiver: " + receiver.getClass().getSimpleName());
        this.addComponent(receiver);
        this.receivers.put(receiver.getName(), receiver);
    }

    public void addComponent(ServerComponent component) {
        log.info("Adding component: " + component.getClass().getSimpleName());
        for (ComponentRegistrator registr : this.registrators.values()) {
            if (registr == component) continue;
            log.finer("Adding: " + component.getName() + " component to " + registr.getName() + " registrator.");
            registr.addComponent(component);
        }
        this.components.put(component.getName(), component);
        this.components_byId.put(component.getComponentId(), component);
        if (component instanceof XMPPService) {
            this.xmppServices.put(component.getName(), (XMPPService)component);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        MessageRouterConfig.getDefaults(defs, params, this.getName());
        return defs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, Object> props) {
        if (this.inProperties) {
            return;
        }
        this.inProperties = true;
        this.disco_name = (String)props.get("disco-name");
        this.disco_show_version = (Boolean)props.get("disco-show-version");
        this.serviceEntity = new ServiceEntity("Tigase", "server", "Session manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("server", "im", this.disco_name + (this.disco_show_version ? " ver. " + XMPPServer.getImplementationVersion() : "")));
        this.serviceEntity.addFeatures(XMPPService.DEF_FEATURES);
        try {
            String[] msgrcv_names;
            String[] reg_names;
            super.setProperties(props);
            Map<String, ComponentRegistrator> tmp_reg = this.registrators;
            Map<String, MessageReceiver> tmp_rec = this.receivers;
            this.components = new TreeMap<String, ServerComponent>();
            this.registrators = new TreeMap<String, ComponentRegistrator>();
            this.receivers = new TreeMap<String, MessageReceiver>();
            this.setConfig(this.config);
            MessageRouterConfig conf = new MessageRouterConfig(props);
            for (String name : reg_names = conf.getRegistrNames()) {
                ComponentRegistrator cr = tmp_reg.remove(name);
                String cls_name = (String)props.get("components/registrators/" + name + ".class");
                try {
                    if (cr == null || !cr.getClass().getName().equals(cls_name)) {
                        if (cr != null) {
                            cr.release();
                        }
                        cr = conf.getRegistrInstance(name);
                        cr.setName(name);
                    }
                    this.addRegistrator(cr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (ComponentRegistrator cr : tmp_reg.values()) {
                cr.release();
            }
            tmp_reg.clear();
            for (String name : msgrcv_names = conf.getMsgRcvNames()) {
                log.finer("Loading and registering message receiver: " + name);
                ServerComponent mr = tmp_rec.remove(name);
                String cls_name = (String)props.get("components/msg-receivers/" + name + ".class");
                try {
                    if (mr == null || !mr.getClass().getName().equals(cls_name)) {
                        if (mr != null) {
                            mr.release();
                        }
                        mr = conf.getMsgRcvInstance(name);
                        mr.setName(name);
                        if (mr instanceof MessageReceiver) {
                            ((MessageReceiver)mr).setParent(this);
                            ((MessageReceiver)mr).start();
                        }
                    }
                    if (mr instanceof MessageReceiver) {
                        this.addRouter((MessageReceiver)mr);
                        continue;
                    }
                    this.addComponent(mr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (MessageReceiver mr : tmp_rec.values()) {
                mr.release();
            }
            tmp_rec.clear();
            if (((Boolean)props.get("updates-checking")).booleanValue()) {
                this.installUpdatesChecker((Long)props.get("updates-checking-interval"));
            } else {
                this.stopUpdatesChecker();
            }
        }
        finally {
            this.inProperties = false;
        }
        for (ServerComponent comp : this.components.values()) {
            log.info("Initialization completed.");
            comp.initializationCompleted();
        }
    }

    private void stopUpdatesChecker() {
        if (this.updates_checker != null) {
            this.updates_checker.interrupt();
            this.updates_checker = null;
        }
    }

    private void installUpdatesChecker(long interval) {
        this.stopUpdatesChecker();
        this.updates_checker = new UpdatesChecker(interval, this, "This is automated message generated by updates checking module.\n You can disable this function changing configuration option: '/" + this.getName() + "/" + "updates-checking" + "' or adjust" + " updates checking interval time changing option: " + "'/" + this.getName() + "/" + "updates-checking-interval" + "' which" + " now set to " + interval + " days.");
        this.updates_checker.start();
    }

    private void processDiscoQuery(Packet packet, Queue<Packet> results) {
        String jid = packet.getElemTo();
        String nick = JIDUtils.getNodeNick((String)jid);
        String node = packet.getAttribute("/iq/query", "node");
        Element query = packet.getElement().getChild("query").clone();
        if (packet.isXMLNS("/iq/query", INFO_XMLNS)) {
            if (this.isLocalDomain(jid)) {
                query = this.getDiscoInfo(node, jid);
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    List<Element> features = xMPPService.getDiscoFeatures();
                    if (features == null) continue;
                    query.addChildren(features);
                }
            } else {
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    Element resp = xMPPService.getDiscoInfo(node, jid);
                    if (resp == null) continue;
                    query = resp;
                    break;
                }
            }
        }
        if (packet.isXMLNS("/iq/query", ITEMS_XMLNS)) {
            boolean localDomain = this.isLocalDomain(jid);
            if (localDomain) {
                for (XMPPService comp : this.xmppServices.values()) {
                    List<Element> items = comp.getDiscoItems(node, jid);
                    log.finest("DiscoItems processed by: " + comp.getComponentId() + ", items: " + (items == null ? null : items.toString()));
                    if (items == null || items.size() <= 0) continue;
                    query.addChildren(items);
                }
            } else {
                ServerComponent serverComponent = this.getLocalComponent(packet.getElemTo());
                if (serverComponent != null && serverComponent instanceof XMPPService) {
                    List<Element> items = ((XMPPService)serverComponent).getDiscoItems(node, jid);
                    log.finest("DiscoItems processed by: " + serverComponent.getComponentId() + ", items: " + (items == null ? null : items.toString()));
                    if (items != null && items.size() > 0) {
                        query.addChildren(items);
                    }
                }
            }
        }
        results.offer(packet.okResult(query, 0));
    }

    public Element getDiscoInfo(String node, String jid) {
        Element query = this.serviceEntity.getDiscoInfo(null);
        log.finest("Returing disco-info: " + query.toString());
        return query;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        return null;
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        long days = uptime / 86400000L;
        long hours = (uptime - days * 24L * 3600000L) / 3600000L;
        long minutes = (uptime - (days * 24L * 3600000L + hours * 3600000L)) / 60000L;
        long seconds = (uptime - (days * 24L * 3600000L + hours * 3600000L + minutes * 60000L)) / 1000L;
        stats.add(new StatRecord(this.getName(), "Uptime", "time", "" + (days > 0L ? days + " day, " : "") + (hours > 0L ? hours + " hour, " : "") + (minutes > 0L ? minutes + " min, " : "") + (seconds > 0L ? seconds + " sec" : ""), Level.INFO));
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        stats.add(new StatRecord(this.getName(), "Load average", "double", format.format(osBean.getSystemLoadAverage()), Level.INFO));
        stats.add(new StatRecord(this.getName(), "CPUs no", "int", osBean.getAvailableProcessors(), Level.FINEST));
        ThreadMXBean thBean = ManagementFactory.getThreadMXBean();
        stats.add(new StatRecord(this.getName(), "Threads count", "int", thBean.getThreadCount(), Level.FINEST));
        long cpuTime = 0L;
        for (long thid : thBean.getAllThreadIds()) {
            cpuTime += thBean.getThreadCpuTime(thid);
        }
        double cpuUsage = new Long(cpuTime).doubleValue() / 1000000.0 / new Long(uptime).doubleValue();
        format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(2);
        stats.add(new StatRecord(this.getName(), "CPU usage", "double", format.format(cpuUsage), Level.INFO));
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        format = NumberFormat.getIntegerInstance();
        if (format instanceof DecimalFormat) {
            DecimalFormat decf = (DecimalFormat)format;
            decf.applyPattern(decf.toPattern() + " KB");
        }
        stats.add(new StatRecord(this.getName(), "Max Heap mem", "long", format.format(heap.getMax() / 1024L), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Used Heap", "long", format.format(heap.getUsed() / 1024L), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Free Heap", "long", format.format((heap.getMax() - heap.getUsed()) / 1024L), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Max NonHeap mem", "long", format.format(nonHeap.getMax() / 1024L), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Used NonHeap", "long", format.format(nonHeap.getUsed() / 1024L), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Free NonHeap", "long", format.format((nonHeap.getMax() - nonHeap.getUsed()) / 1024L), Level.INFO));
        return stats;
    }
}

