/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Base64;
import tigase.util.JIDUtils;

public class TigaseAuth
implements UserAuthRepository {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.TigaseAuth");
    private static final String[] non_sasl_mechs = new String[]{"password"};
    private static final String[] sasl_mechs = new String[]{"PLAIN"};
    public static final String DERBY_CONNVALID_QUERY = "values 1";
    public static final String JDBC_CONNVALID_QUERY = "select 1";
    private String db_conn = null;
    private Connection conn = null;
    private CallableStatement init_db_sp = null;
    private CallableStatement add_user_plain_pw_sp = null;
    private CallableStatement remove_user_sp = null;
    private CallableStatement get_pass_sp = null;
    private CallableStatement update_pass_plain_pw_sp = null;
    private CallableStatement user_login_plain_pw_sp = null;
    private CallableStatement user_logout_sp = null;
    private PreparedStatement conn_valid_st = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean online_status = false;
    private boolean derby_mode = false;

    private void initPreparedStatements() throws SQLException {
        String query = this.derby_mode ? DERBY_CONNVALID_QUERY : JDBC_CONNVALID_QUERY;
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "{ call TigInitdb() }";
        this.init_db_sp = this.conn.prepareCall(query);
        query = "{ call TigAddUserPlainPw(?, ?) }";
        this.add_user_plain_pw_sp = this.conn.prepareCall(query);
        query = "{ call TigRemoveUser(?) }";
        this.remove_user_sp = this.conn.prepareCall(query);
        query = "{ call TigGetPassword(?) }";
        this.get_pass_sp = this.conn.prepareCall(query);
        query = "{ call TigUpdatePasswordPlainPw(?, ?) }";
        this.update_pass_plain_pw_sp = this.conn.prepareCall(query);
        query = "{ call TigUserLoginPlainPw(?, ?) }";
        this.user_login_plain_pw_sp = this.conn.prepareCall(query);
        query = "{ call TigUserLogout(?) }";
        this.user_logout_sp = this.conn.prepareCall(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    rs = this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPassword(String user) throws SQLException, UserNotFoundException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            CallableStatement callableStatement = this.get_pass_sp;
            synchronized (callableStatement) {
                this.get_pass_sp.setString(1, JIDUtils.getNodeID((String)user));
                rs = this.get_pass_sp.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                string = rs.getString(1);
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.conn = DriverManager.getConnection(this.db_conn);
            this.derby_mode = this.db_conn.startsWith("jdbc:derby");
            this.initPreparedStatements();
        }
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        this.db_conn = connection_str;
        try {
            this.initRepo();
            if (params != null && params.get("init-db") != null) {
                this.init_db_sp.executeQuery();
            }
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.user_login_plain_pw_sp;
            // MONITORENTER : callableStatement
            String user_id = JIDUtils.getNodeID((String)user);
            this.user_login_plain_pw_sp.setString(1, user_id);
            this.user_login_plain_pw_sp.setString(2, password);
            rs = this.user_login_plain_pw_sp.executeQuery();
            if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
            boolean auth_result_ok = user_id.equals(rs.getString(1));
            if (auth_result_ok) {
                boolean bl = true;
                // MONITOREXIT : callableStatement
                this.release(null, rs);
                return bl;
            }
            log.fine("Login failed, for user: '" + user_id + "'" + ", password: '" + password + "'" + ", from DB got: " + rs.getString(1));
            throw new UserNotFoundException("User does not exist: " + user);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        throw new AuthorizationException("Not supported.");
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals("PLAIN")) {
                return this.saslAuth(props);
            }
            throw new AuthorizationException("Mechanism is not supported: " + mech);
        }
        throw new AuthorizationException("Protocol is not supported: " + proto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.user_logout_sp;
            synchronized (callableStatement) {
                this.user_logout_sp.setString(1, JIDUtils.getNodeID((String)user));
                this.user_logout_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.add_user_plain_pw_sp;
            synchronized (callableStatement) {
                this.add_user_plain_pw_sp.setString(1, JIDUtils.getNodeID((String)user));
                this.add_user_plain_pw_sp.setString(2, password);
                rs = this.add_user_plain_pw_sp.executeQuery();
            }
            this.release(null, rs);
            return;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", e2);
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(String user, String password) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.update_pass_plain_pw_sp;
            synchronized (callableStatement) {
                this.update_pass_plain_pw_sp.setString(1, JIDUtils.getNodeID((String)user));
                this.update_pass_plain_pw_sp.setString(2, password);
                this.update_pass_plain_pw_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.remove_user_sp;
            synchronized (callableStatement) {
                this.remove_user_sp.setString(1, JIDUtils.getNodeID((String)user));
                this.remove_user_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    private String decodeString(byte[] source, int start_from) {
        int idx;
        for (idx = start_from; source[idx] != 0 && idx < source.length; ++idx) {
        }
        return new String(source, start_from, idx - start_from);
    }

    private boolean saslAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        int user_idx;
        int auth_idx;
        String data_str = (String)props.get("data");
        String domain = (String)props.get("realm");
        props.put("result", null);
        byte[] in_data = data_str != null ? Base64.decode((String)data_str) : new byte[]{};
        for (auth_idx = 0; in_data[auth_idx] != 0 && auth_idx < in_data.length; ++auth_idx) {
        }
        String authoriz = new String(in_data, 0, auth_idx);
        for (user_idx = ++auth_idx; in_data[user_idx] != 0 && user_idx < in_data.length; ++user_idx) {
        }
        String user_name = new String(in_data, auth_idx, user_idx - auth_idx);
        ++user_idx;
        String jid = user_name;
        if (JIDUtils.getNodeNick((String)user_name) == null) {
            jid = JIDUtils.getNodeID((String)user_name, (String)domain);
        }
        props.put("user-id", jid);
        String passwd = new String(in_data, user_idx, in_data.length - user_idx);
        return this.plainAuth(jid, passwd);
    }
}

