/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class Privacy {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Roster");
    protected static final String PRIVACY = "privacy";
    protected static final String LIST = "list";
    protected static final String ITEM = "item";
    protected static final String NAME = "name";
    protected static final String ORDER = "order";
    protected static final String TYPE = "type";
    protected static final String VALUE = "value";
    protected static final String ACTION = "action";
    protected static final String STANZAS = "stanzas";
    protected static final String DEFAULT = "default-list";
    protected static final String ACTIVE = "active-list";

    public static String[] getLists(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getDataGroups(PRIVACY);
    }

    public static String listNode(String list) {
        return "privacy/" + list;
    }

    public static void setDefaultList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (list.getAttribute(NAME) != null) {
            session.setData(PRIVACY, DEFAULT, list.getAttribute(NAME));
        } else {
            session.removeData(PRIVACY, DEFAULT);
        }
    }

    public static String getDefaultList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getData(PRIVACY, DEFAULT, null);
    }

    public static void setActiveList(XMPPResourceConnection session, String lName) throws NotAuthorizedException, TigaseDBException {
        if (lName != null) {
            Element list = Privacy.getList(session, lName);
            session.putSessionData(ACTIVE, list);
        } else {
            session.putSessionData(ACTIVE, null);
        }
    }

    public static Element getActiveList(XMPPResourceConnection session) throws NotAuthorizedException {
        return (Element)session.getSessionData(ACTIVE);
    }

    public static String getActiveListName(XMPPResourceConnection session) throws NotAuthorizedException {
        Element list = Privacy.getActiveList(session);
        if (list != null) {
            return list.getAttribute(NAME);
        }
        return null;
    }

    public static void addList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        String lNode = Privacy.listNode(list.getAttribute(NAME));
        session.removeDataGroup(lNode);
        if (list.getChildren() != null && list.getChildren().size() > 0) {
            for (Element item : list.getChildren()) {
                String iNode = lNode + "/" + item.getAttribute(ORDER);
                if (item.getAttribute(TYPE) != null) {
                    session.setData(iNode, TYPE, item.getAttribute(TYPE));
                }
                if (item.getAttribute(VALUE) != null) {
                    session.setData(iNode, VALUE, item.getAttribute(VALUE));
                }
                session.setData(iNode, ACTION, item.getAttribute(ACTION));
                List stanzas_list = item.getChildren();
                if (stanzas_list == null || stanzas_list.size() <= 0) continue;
                String[] stanzas = new String[stanzas_list.size()];
                int cnt = -1;
                for (Element stanza : stanzas_list) {
                    stanzas[++cnt] = stanza.getName();
                }
                session.setDataList(iNode, STANZAS, stanzas);
            }
        }
    }

    public static Element getList(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode = Privacy.listNode(list);
        String[] items = session.getDataGroups(lNode);
        if (items != null) {
            Element eList = new Element(LIST, new String[]{NAME}, new String[]{list});
            for (String item : items) {
                String iNode = lNode + "/" + item;
                String type = session.getData(iNode, TYPE, null);
                String value = session.getData(iNode, VALUE, null);
                String action = session.getData(iNode, ACTION, null);
                String[] stanzas = session.getDataList(iNode, STANZAS);
                Element eItem = new Element(ITEM, new String[]{ORDER, ACTION}, new String[]{item, action});
                if (type != null) {
                    eItem.addAttribute(TYPE, type);
                }
                if (value != null) {
                    eItem.addAttribute(VALUE, value);
                }
                if (stanzas != null) {
                    for (String stanza : stanzas) {
                        eItem.addChild(new Element(stanza));
                    }
                }
                eList.addChild(eItem);
            }
            return eList;
        }
        return null;
    }
}

