/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqVersion
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIQVersion");
    private static final String XMLNS = "jabber:iq:version";
    private static final String ID = "jabber:iq:version";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:version"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:version"})};

    @Override
    public String id() {
        return "jabber:iq:version";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        String id = session.getDomain();
        if (packet.getElemTo() != null) {
            id = JIDUtils.getNodeID((String)packet.getElemTo());
        }
        if (id == null || id.equals("") || id.equalsIgnoreCase(session.getDomain())) {
            StringBuilder reply = new StringBuilder();
            reply.append("<name>Tigase</name>");
            reply.append("<version>" + XMPPServer.getImplementationVersion() + "</version>");
            reply.append("<os>" + System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ", " + System.getProperty("java.vm.name") + "-" + System.getProperty("java.vm.version") + "-" + System.getProperty("java.vm.vendor") + "</os>");
            results.offer(packet.okResult(reply.toString(), 1));
            return;
        }
        try {
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
        }
    }
}

