/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.LoginHandler;
import tigase.auth.TigaseSaslProvider;
import tigase.conf.Configurable;
import tigase.db.DataOverwriteException;
import tigase.db.NonAuthUserRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.PacketFilter;
import tigase.server.xmppsession.SessionManagerConfig;
import tigase.stats.StatRecord;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.ProcessorFactory;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;

public class SessionManager
extends AbstractMessageReceiver
implements Configurable,
XMPPService,
LoginHandler {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.SessionManager");
    protected static final String SESSION_PACKETS = "session-packets";
    private UserRepository user_repository = null;
    private UserAuthRepository auth_repository = null;
    private NonAuthUserRepository naUserRepository = null;
    private PacketFilter filter = null;
    private String[] hostnames = new String[]{"localhost"};
    private String[] admins = new String[]{"admin@localhost"};
    private String[] trusted = new String[]{"admin@localhost"};
    private Map<String, XMPPSession> sessionsByNodeId = new ConcurrentSkipListMap<String, XMPPSession>();
    private Map<String, XMPPResourceConnection> connectionsByFrom = new ConcurrentSkipListMap<String, XMPPResourceConnection>();
    private Map<String, XMPPPreprocessorIfc> preProcessors = new ConcurrentSkipListMap<String, XMPPPreprocessorIfc>();
    private Map<String, ProcessorThread> processors = new ConcurrentSkipListMap<String, ProcessorThread>();
    private Map<String, XMPPPostprocessorIfc> postProcessors = new ConcurrentSkipListMap<String, XMPPPostprocessorIfc>();
    private Map<String, XMPPStopListenerIfc> stopListeners = new ConcurrentSkipListMap<String, XMPPStopListenerIfc>();
    private Map<String, Map<String, Object>> plugin_config = new ConcurrentSkipListMap<String, Map<String, Object>>();
    private Set<String> anonymous_domains = new HashSet<String>();
    private XMPPResourceConnection serverSession = null;
    private ServiceEntity serviceEntity = null;
    private long closedConnections = 0L;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "sm", "Session manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "sm", "Session manager"));
    }

    private void debug_packet(String msg, Packet packet, String to) {
        if (packet.getElemTo().equals(to)) {
            log.finest(msg + ", packet: " + packet.getStringData());
        }
    }

    protected XMPPResourceConnection getXMPPResourceConnection(String connId) {
        return this.connectionsByFrom.get(connId);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        XMPPResourceConnection conn = null;
        if (p.getFrom() != null && (conn = this.connectionsByFrom.get(p.getFrom())) != null) {
            return conn.getConnectionStatus() == ConnectionStatus.TEMP ? null : conn;
        }
        String to = p.getElemTo();
        if (to != null) {
            conn = this.getResourceConnection(to);
            if (conn != null && conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                conn = null;
            }
        } else {
            log.info("Message without TO attribute set, don't know what to do wih this: " + p.getStringData());
        }
        return conn;
    }

    protected boolean isBrokenPacket(Packet p) {
        if (!p.getFrom().equals(p.getElemFrom()) && (!p.isCommand() || p.isCommand() && p.getCommand() == Command.OTHER)) {
            log.info("Broken packet: " + p.toString());
            try {
                Packet error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(p, "Service not available.", true);
                error.setTo(p.getFrom());
                this.fastAddOutPacket(error);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    protected void processPacket(Packet packet, XMPPResourceConnection conn) {
        packet.setTo(this.getComponentId());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processing packet: " + packet.toString());
        }
        LinkedList<Packet> results = new LinkedList<Packet>();
        boolean stop = false;
        if (!stop && this.filter.preprocess(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet preprocessed: " + packet.toString());
                if (results.size() > 0) {
                    for (Packet p : results) {
                        log.finest("Preprocess result: " + p.toString());
                    }
                }
            }
            this.addOutPackets(results);
            return;
        }
        if (!stop) {
            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                stop |= preproc.preProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && this.filter.forward(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet forwarded: " + packet.toString());
            }
            this.addOutPackets(results);
            return;
        }
        if (!stop) {
            this.walk(packet, conn, packet.getElement(), results);
        }
        if (!stop) {
            for (XMPPPostprocessorIfc postproc : this.postProcessors.values()) {
                postproc.postProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && !packet.wasProcessed() && !this.isInRoutings(packet.getElemTo()) && this.filter.process(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-process");
        }
        this.setPermissions(conn, results);
        this.addOutPackets(results);
        if (!packet.wasProcessed()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet not processed: " + packet.toString());
            }
            Packet error = null;
            if (stop || conn == null && packet.getElemFrom() != null && packet.getElemTo() != null && packet.getElemTo() != this.getComponentId() && (packet.getElemName().equals("iq") || packet.getElemName().equals("message"))) {
                try {
                    error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e + ", packet: " + packet.toString());
                }
            } else if (packet.getElemFrom() != null || conn != null) {
                try {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e + ", packet: " + packet.toString());
                }
            }
            if (error != null) {
                if (error.getElemTo() != null) {
                    conn = this.getResourceConnection(error.getElemTo());
                }
                if (conn != null) {
                    error.setTo(conn.getConnectionId());
                }
                this.addOutPacket(error);
            }
        } else {
            log.finest("Packet processed by: " + packet.getProcessorsIds().toString());
        }
    }

    private void setPermissions(XMPPResourceConnection conn, Queue<Packet> results) {
        Permissions perms = Permissions.NONE;
        if (conn != null) {
            perms = Permissions.LOCAL;
            if (conn.isAuthorized()) {
                perms = Permissions.AUTH;
                if (conn.isAnonymous()) {
                    perms = Permissions.ANONYM;
                } else {
                    try {
                        String id = conn.getUserId();
                        if (this.isTrusted(id)) {
                            perms = Permissions.TRUSTED;
                        }
                        if (this.isAdmin(id)) {
                            perms = Permissions.ADMIN;
                        }
                    }
                    catch (NotAuthorizedException e) {
                        perms = Permissions.NONE;
                    }
                }
            }
        }
        for (Packet res : results) {
            res.setPermissions(perms);
        }
    }

    protected String[] getVHosts() {
        return this.hostnames;
    }

    private boolean isAdmin(String jid) {
        for (String adm : this.admins) {
            if (!adm.equals(JIDUtils.getNodeID((String)jid))) continue;
            return true;
        }
        return false;
    }

    private boolean isTrusted(String jid) {
        for (String trust : this.trusted) {
            if (!trust.equals(JIDUtils.getNodeID((String)jid))) continue;
            return true;
        }
        return this.isAdmin(jid);
    }

    protected boolean processAdminsOrDomains(Packet packet) {
        String to = packet.getElemTo();
        if (this.isInRoutings(to)) {
            if (packet.getElemName().equals("message")) {
                log.finer("Packet for admin: " + packet.getStringData());
                this.sendToAdmins(packet);
            } else {
                log.finer("Packet for hostname: " + packet.getStringData());
                Packet host_pac = new Packet(packet.getElement().clone());
                host_pac.getElement().setAttribute("to", this.getComponentId());
                host_pac.getElement().setAttribute("oldto", packet.getElemTo());
                this.processPacket(host_pac);
            }
            return true;
        }
        return false;
    }

    protected void sendToAdmins(Packet packet) {
        for (String admin : this.admins) {
            log.finer("Sending packet to admin: " + admin);
            Packet admin_pac = new Packet(packet.getElement().clone());
            admin_pac.getElement().setAttribute("to", admin);
            this.processPacket(admin_pac);
        }
    }

    protected XMPPSession getSession(String jid) {
        return this.sessionsByNodeId.get(JIDUtils.getNodeID((String)jid));
    }

    private XMPPResourceConnection getResourceConnection(String jid) {
        XMPPSession session = this.getSession(jid);
        if (session != null) {
            return session.getResourceConnection(jid);
        }
        return null;
    }

    private String getConnectionId(String jid) {
        XMPPResourceConnection res = this.getResourceConnection(jid);
        if (res != null) {
            return res.getConnectionId();
        }
        return null;
    }

    private void walk(Packet packet, XMPPResourceConnection connection, Element elem, Queue<Packet> results) {
        for (ProcessorThread proc_t : this.processors.values()) {
            String xmlns = elem.getXMLNS();
            if (xmlns == null) {
                xmlns = "jabber:client";
            }
            if (!proc_t.processor.isSupporting(elem.getName(), xmlns)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XMPPProcessorIfc: " + proc_t.processor.getClass().getSimpleName() + " (" + proc_t.processor.id() + ")" + "\n Request: " + elem.toString() + (connection != null ? ", " + connection.getConnectionId() : " null"));
            }
            if (proc_t.addItem(packet, connection)) {
                packet.processedBy(proc_t.processor.id());
                continue;
            }
            log.warning("Can not add packet: " + packet.toString() + " to processor: " + proc_t.getName() + " internal queue");
        }
        List children = elem.getChildren();
        if (children != null) {
            for (Element child : children) {
                this.walk(packet, connection, child, results);
            }
        }
    }

    protected XMPPResourceConnection createUserSession(String conn_id, String domain, String user_jid) {
        XMPPResourceConnection connection = new XMPPResourceConnection(conn_id, this.user_repository, this.auth_repository, this, false);
        connection.setDomain(domain);
        connection.setSessionId("session-id");
        this.connectionsByFrom.put(conn_id, connection);
        this.registerNewSession(JIDUtils.getNodeID((String)user_jid), connection);
        try {
            connection.setResource(JIDUtils.getNodeResource((String)user_jid));
        }
        catch (NotAuthorizedException e) {
            log.warning("Something wrong with authorization: " + e + ", for user: " + user_jid);
        }
        return connection;
    }

    @Override
    protected Integer getDefMaxQueueSize() {
        return new Integer(10000);
    }

    protected boolean processCommand(Packet pc) {
        boolean processing_result = false;
        log.finer(pc.getCommand().toString() + " command from: " + pc.getFrom());
        XMPPResourceConnection connection = this.connectionsByFrom.get(pc.getFrom());
        switch (pc.getCommand()) {
            case STREAM_OPENED: {
                if (connection == null) {
                    log.finer("Adding resource connection for: " + pc.getFrom());
                    String hostname = Command.getFieldValue(pc, "hostname");
                    connection = new XMPPResourceConnection(pc.getFrom(), this.user_repository, this.auth_repository, this, this.anonymous_domains.contains(hostname));
                    if (hostname != null) {
                        log.finest("Setting hostname " + hostname + " for connection: " + connection.getConnectionId());
                        connection.setDomain(hostname);
                    } else {
                        connection.setDomain(this.getDefHostName());
                    }
                    this.connectionsByFrom.put(pc.getFrom(), connection);
                } else {
                    log.finest("Stream opened for existing session, authorized: " + connection.isAuthorized());
                }
                connection.setSessionId(Command.getFieldValue(pc, "session-id"));
                connection.setDefLang(Command.getFieldValue(pc, "xml:lang"));
                log.finest("Setting session-id " + connection.getSessionId() + " for connection: " + connection.getConnectionId());
                processing_result = true;
                break;
            }
            case GETFEATURES: {
                if (pc.getType() == StanzaType.get) {
                    List<Element> features = this.getFeatures(this.connectionsByFrom.get(pc.getFrom()));
                    Packet result = pc.commandResult(null);
                    Command.setData(result, features);
                    this.addOutPacket(result);
                }
                processing_result = true;
                break;
            }
            case STREAM_CLOSED: {
                this.closeConnection(pc.getFrom(), false);
                processing_result = true;
                break;
            }
            case BROADCAST_TO_ONLINE: {
                String from = pc.getFrom();
                boolean trusted = false;
                try {
                    trusted = from != null && this.isTrusted(from) || connection != null && this.isTrusted(connection.getUserId());
                }
                catch (NotAuthorizedException e) {
                    trusted = false;
                }
                try {
                    if (trusted) {
                        List<Element> packets = Command.getData(pc);
                        if (packets != null) {
                            for (XMPPResourceConnection conn : this.connectionsByFrom.values()) {
                                if (!conn.isAuthorized()) continue;
                                try {
                                    for (Element el_pack : packets) {
                                        Element el_copy = el_pack.clone();
                                        el_copy.setAttribute("to", conn.getJID());
                                        Packet out_packet = new Packet(el_copy);
                                        out_packet.setTo(conn.getConnectionId());
                                        this.addOutPacket(out_packet);
                                    }
                                }
                                catch (NotAuthorizedException e) {
                                    log.warning("Something wrong, connection is authenticated but NoAuthorizedException is thrown.");
                                }
                            }
                        } else {
                            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(pc, "Missing packets for broadcast.", true));
                        }
                    } else {
                        this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(pc, "You don't have enough permission to brodcast packet.", true));
                    }
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e + ", packet: " + pc.toString());
                }
                processing_result = true;
                break;
            }
            case USER_STATUS: {
                try {
                    if (this.isTrusted(pc.getElemFrom()) || this.isTrusted(JIDUtils.getNodeHost((String)pc.getElemFrom()))) {
                        boolean available;
                        String av = Command.getFieldValue(pc, "available");
                        boolean bl = available = av == null || !av.equalsIgnoreCase("false");
                        if (available) {
                            Packet presence = null;
                            Element p = pc.getElement().getChild("command").getChild("presence");
                            if (p != null) {
                                Element elem = p.clone();
                                elem.setXMLNS("jabber:client");
                                presence = new Packet(elem);
                            }
                            if ((connection = this.connectionsByFrom.get(pc.getElemFrom())) == null) {
                                String user_jid = Command.getFieldValue(pc, "jid");
                                String hostname = JIDUtils.getNodeHost((String)user_jid);
                                connection = this.createUserSession(pc.getElemFrom(), hostname, user_jid);
                                connection.setSessionId("USER_STATUS");
                                this.user_repository.setData(JIDUtils.getNodeID((String)user_jid), "tokens", "USER_STATUS", "USER_STATUS");
                                connection.loginToken("USER_STATUS", "USER_STATUS");
                                this.handleLogin(user_jid, connection);
                                connection.putSessionData("jingle", "active");
                                this.addOutPacket(pc.okResult((String)null, 0));
                                if (presence == null) {
                                    presence = new Packet(new Element("presence", new Element[]{new Element("priority", "-1"), new Element("c", new String[]{"node", "ver", "ext", "xmlns"}, new String[]{"http://www.google.com/xmpp/client/caps", XMPPServer.getImplementationVersion(), "voice-v1", "http://jabber.org/protocol/caps"})}, null, null));
                                }
                            } else {
                                log.finest("USER_STATUS set to true for user who is already available: " + pc.toString());
                            }
                            if (presence != null) {
                                presence.setFrom(pc.getElemFrom());
                                presence.setTo(this.getComponentId());
                                this.addOutPacket(presence);
                            }
                        } else {
                            connection = this.connectionsByFrom.remove(pc.getElemFrom());
                            if (connection != null) {
                                this.closeSession(connection, false);
                                this.addOutPacket(pc.okResult((String)null, 0));
                            } else {
                                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(pc, "The user resource you want to remove does not exist.", true));
                                log.info("Can not find resource connection for packet: " + pc.toString());
                            }
                        }
                    } else {
                        try {
                            this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(pc, "Only trusted entity can do it.", true));
                        }
                        catch (PacketErrorTypeException e) {
                            log.warning("Packet error type when not expected: " + pc.toString());
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        this.addOutPacket(Authorization.UNDEFINED_CONDITION.getResponseMessage(pc, "Unexpected error occured during the request: " + e, true));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    log.log(Level.WARNING, "USER_STATUS session creation error: ", e);
                }
                processing_result = true;
                break;
            }
            case REDIRECT: {
                if (connection != null) {
                    String action = Command.getFieldValue(pc, "action");
                    if (action.equals("close")) {
                        log.fine("Closing redirected connections: " + pc.getFrom());
                        this.sendAllOnHold(connection);
                        this.closeConnection(pc.getFrom(), true);
                    } else {
                        log.fine("Activating redirected connections: " + pc.getFrom());
                    }
                } else {
                    log.fine("Redirect for non-existen connection: " + pc.toString());
                }
                processing_result = true;
                break;
            }
            case OTHER: {
                log.info("Other command found: " + pc.getStrCommand());
                break;
            }
        }
        return processing_result;
    }

    protected void sendAllOnHold(XMPPResourceConnection conn) {
        String remote_smId = (String)conn.getSessionData("redirect-to");
        LinkedList packets = (LinkedList)conn.getSessionData(SESSION_PACKETS);
        if (remote_smId == null) {
            log.finest("No address for remote SM to redirect packets, processing locally.");
            if (packets != null) {
                Packet sess_pack = null;
                while ((sess_pack = (Packet)packets.poll()) != null) {
                    this.processPacket(sess_pack);
                }
            }
            return;
        }
        conn.setConnectionStatus(ConnectionStatus.REDIRECT);
        if (packets != null) {
            Packet sess_pack = null;
            while ((sess_pack = (Packet)packets.poll()) != null) {
                sess_pack.setTo(remote_smId);
                this.fastAddOutPacket(sess_pack);
            }
        }
    }

    protected void closeConnection(String connectionId, boolean closeOnly) {
        log.fine("Stream closed from: " + connectionId);
        ++this.closedConnections;
        XMPPResourceConnection connection = this.connectionsByFrom.remove(connectionId);
        if (connection != null) {
            this.closeSession(connection, closeOnly);
        } else {
            log.info("Can not find resource connection for packet: " + connectionId);
        }
    }

    private void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (!closeOnly) {
            LinkedList<Packet> results = new LinkedList<Packet>();
            for (XMPPStopListenerIfc stopProc : this.stopListeners.values()) {
                stopProc.stopped(conn, results, this.plugin_config.get(stopProc.id()));
            }
            this.addOutPackets(results);
        }
        try {
            if (conn.isAuthorized() || conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                String userId = conn.getUserId();
                log.info("Closing connection for: " + userId);
                XMPPSession session = conn.getParentSession();
                if (session != null) {
                    log.info("Found parent session for: " + userId);
                    if (session.getActiveResourcesSize() <= 1) {
                        session = this.sessionsByNodeId.remove(userId);
                        if (session == null) {
                            log.info("UPS can't remove session, not found in map: " + userId);
                        } else {
                            log.finer("Number of user sessions: " + this.sessionsByNodeId.size());
                        }
                        this.auth_repository.logout(userId);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (XMPPResourceConnection res_con : session.getActiveResources()) {
                            sb.append(", res=" + res_con.getResource() + " (" + (Object)((Object)res_con.getConnectionStatus()) + ")");
                        }
                        log.finer("Number of connections is " + session.getActiveResourcesSize() + " for the user: " + userId + sb.toString());
                    }
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.info("Closed not authorized session: " + e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception closing session... ", e);
        }
        conn.streamClosed();
    }

    protected boolean checkOutPacket(Packet packet) {
        if (packet.getPermissions() == Permissions.ANONYM && packet.getElemTo() != null && !this.anonymous_domains.contains(JIDUtils.getNodeHost((String)packet.getElemTo()))) {
            try {
                this.addPacket(Authorization.FORBIDDEN.getResponseMessage(packet, "Anonymous user can only send local messages.", true));
            }
            catch (PacketErrorTypeException e) {
                log.log(Level.INFO, "Error for error packet: " + packet.toString(), e);
            }
            return false;
        }
        String oldto = packet.getAttribute("oldto");
        if (oldto != null) {
            packet.getElement().setAttribute("from", oldto);
            packet.getElement().removeAttribute("oldto");
        }
        return true;
    }

    @Override
    protected boolean addOutPacket(Packet packet) {
        if (this.checkOutPacket(packet)) {
            return super.addOutPacket(packet);
        }
        return false;
    }

    protected boolean fastAddOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet packet = null;
        while ((packet = packets.poll()) != null) {
            this.addOutPacket(packet);
        }
        return true;
    }

    private XMPPSession getXMPPSession(Packet p) {
        return this.connectionsByFrom.get(p.getFrom()).getParentSession();
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (ProcessorThread proc_t : this.processors.values()) {
            Element[] features = proc_t.processor.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        SessionManagerConfig.getDefaults(props, params);
        return props;
    }

    private void addPlugin(String comp_id) {
        XMPPStopListenerIfc stoplist;
        XMPPPostprocessorIfc postproc;
        XMPPPreprocessorIfc preproc;
        System.out.println("Loading plugin: " + comp_id + " ...");
        XMPPProcessorIfc proc = ProcessorFactory.getProcessor(comp_id);
        boolean loaded = false;
        if (proc != null) {
            ProcessorThread pt = new ProcessorThread(proc);
            pt.setDaemon(true);
            pt.setName(proc.id());
            pt.start();
            this.processors.put(comp_id, pt);
            log.config("Added processor: " + proc.getClass().getSimpleName() + " for plugin id: " + comp_id);
            loaded = true;
        }
        if ((preproc = ProcessorFactory.getPreprocessor(comp_id)) != null) {
            this.preProcessors.put(comp_id, preproc);
            log.config("Added preprocessor: " + preproc.getClass().getSimpleName() + " for plugin id: " + comp_id);
            loaded = true;
        }
        if ((postproc = ProcessorFactory.getPostprocessor(comp_id)) != null) {
            this.postProcessors.put(comp_id, postproc);
            log.config("Added postprocessor: " + postproc.getClass().getSimpleName() + " for plugin id: " + comp_id);
            loaded = true;
        }
        if ((stoplist = ProcessorFactory.getStopListener(comp_id)) != null) {
            this.stopListeners.put(comp_id, stoplist);
            log.config("Added stopped processor: " + stoplist.getClass().getSimpleName() + " for plugin id: " + comp_id);
            loaded = true;
        }
        if (!loaded) {
            log.warning("No implementation found for plugin id: " + comp_id);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String res_uri;
        String cls_name;
        super.setProperties(props);
        Security.insertProviderAt(new TigaseSaslProvider(), 6);
        this.filter = new PacketFilter();
        LinkedHashMap<String, String> user_repo_params = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> auth_repo_params = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String[] nodes;
            if (entry.getKey().startsWith("user-repo-params") && (nodes = entry.getKey().split("/")).length > 1) {
                user_repo_params.put(nodes[1], entry.getValue().toString());
            }
            if (!entry.getKey().startsWith("auth-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
            auth_repo_params.put(nodes[1], entry.getValue().toString());
        }
        try {
            cls_name = (String)props.get("user-repo-class");
            res_uri = (String)props.get("user-repo-url");
            this.user_repository = RepositoryFactory.getUserRepository(this.getName(), cls_name, res_uri, user_repo_params);
            log.config("Initialized " + cls_name + " as user repository: " + res_uri);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize user repository: ", e);
        }
        try {
            cls_name = (String)props.get("auth-repo-class");
            res_uri = (String)props.get("auth-repo-url");
            this.auth_repository = RepositoryFactory.getAuthRepository(this.getName(), cls_name, res_uri, auth_repo_params);
            log.config("Initialized " + cls_name + " as auth repository: " + res_uri);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize auth repository: ", e);
        }
        this.naUserRepository = new NARepository(this.user_repository);
        String[] plugins = (String[])props.get("plugins");
        this.processors.clear();
        for (String comp_id : plugins) {
            if (comp_id.equals("presence")) {
                log.warning("Your configuration is outdated! Note 'presence' and 'jaber:iq:roster' plugins are no longer exist. Use 'roster-presence' plugin instead, loading automaticly...");
                comp_id = "roster-presence";
            }
            this.addPlugin(comp_id);
            ConcurrentSkipListMap<String, Object> plugin_settings = new ConcurrentSkipListMap<String, Object>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes;
                if (!entry.getKey().startsWith("plugins-conf") || (nodes = entry.getKey().split("/")).length <= 2) continue;
                Object[] ids = nodes[1].split(",");
                Arrays.sort(ids);
                if (Arrays.binarySearch(ids, comp_id) < 0) continue;
                plugin_settings.put(nodes[2], entry.getValue());
            }
            if (plugin_settings.size() <= 0) continue;
            log.finest(((Object)plugin_settings).toString());
            this.plugin_config.put(comp_id, plugin_settings);
        }
        this.hostnames = (String[])props.get("hostnames");
        this.clearRoutings();
        for (String host : this.hostnames) {
            this.addRouting(host);
        }
        this.addRouting(this.getComponentId());
        this.serverSession = this.createUserSession("NULL", this.getDefHostName(), this.getComponentId() + "/server");
        this.anonymous_domains.clear();
        this.anonymous_domains.addAll(Arrays.asList((String[])props.get("anonymous-domains")));
        this.admins = (String[])props.get("admins");
        this.trusted = (String[])props.get("trusted");
    }

    protected void registerNewSession(String userId, XMPPResourceConnection conn) {
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session == null) {
            session = new XMPPSession(JIDUtils.getNodeNick((String)userId));
            this.sessionsByNodeId.put(userId, session);
            log.finest("Created new XMPPSession for: " + userId);
        }
        session.addResourceConnection(conn);
    }

    @Override
    public void handleLogin(String userName, XMPPResourceConnection conn) {
        log.finest("handleLogin called for: " + userName);
        String userId = JIDUtils.getNodeID((String)userName, (String)conn.getDomain());
        this.registerNewSession(userId, conn);
    }

    @Override
    public void handleLogout(String userName, XMPPResourceConnection conn) {
        String domain = conn.getDomain();
        this.addOutPacket(Command.CLOSE.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId()));
        String userId = JIDUtils.getNodeID((String)userName, (String)domain);
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session != null && session.getActiveResourcesSize() <= 1) {
            this.sessionsByNodeId.remove(userId);
        }
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            Element query = this.serviceEntity.getDiscoInfo(node);
            for (ProcessorThread proc_t : this.processors.values()) {
                Element[] discoFeatures = proc_t.processor.supDiscoFeatures(null);
                if (discoFeatures == null) continue;
                query.addChildren(Arrays.asList(discoFeatures));
            }
            return query;
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        LinkedList<Element> features = new LinkedList<Element>();
        for (ProcessorThread proc_t : this.processors.values()) {
            Element[] discoFeatures = proc_t.processor.supDiscoFeatures(null);
            if (discoFeatures == null) continue;
            features.addAll(Arrays.asList(discoFeatures));
        }
        return features;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoItems(node, jid);
        }
        return null;
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        stats.add(new StatRecord(this.getName(), "Open connections", "int", this.connectionsByFrom.size(), Level.FINE));
        stats.add(new StatRecord(this.getName(), "Registered accounts", "long", this.user_repository.getUsersCount(), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Open authorized sessions", "int", this.sessionsByNodeId.size(), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Closed connections", "long", this.closedConnections, Level.FINER));
        return stats;
    }

    static /* synthetic */ int access$100(SessionManager x0) {
        return x0.maxQueueSize;
    }

    private static class NARepository
    implements NonAuthUserRepository {
        UserRepository rep = null;

        NARepository(UserRepository userRep) {
            this.rep = userRep;
        }

        private String calcNode(String base, String subnode) {
            if (subnode == null) {
                return base;
            }
            return base + "/" + subnode;
        }

        @Override
        public String getPublicData(String user, String subnode, String key, String def) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getData(user, this.calcNode("public", subnode), key, def) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public String[] getPublicDataList(String user, String subnode, String key) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getDataList(user, this.calcNode("public", subnode), key) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public void addOfflineDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException {
            try {
                if (!this.rep.userExists(user)) {
                    throw new UserNotFoundException("User: " + user + " has not been found inthe repository.");
                }
                this.rep.addDataList(user, this.calcNode("offline", subnode), key, list);
            }
            catch (UserNotFoundException e) {
                log.warning("User not found in repository: " + user);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }

        @Override
        public void addOfflineData(String user, String subnode, String key, String value) throws UserNotFoundException, DataOverwriteException {
            String node = this.calcNode("offline", subnode);
            try {
                String data = this.rep.getData(user, node, key);
                if (data != null) {
                    throw new DataOverwriteException("Not authorized attempt to overwrite data.");
                }
                this.rep.setData(user, node, key, value);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }
    }

    private class ProcessorThread
    extends Thread {
        private boolean stopped = false;
        private XMPPProcessorIfc processor = null;
        private LinkedList<Packet> local_results = new LinkedList();
        private LinkedBlockingQueue<QueueItem> in_queue = new LinkedBlockingQueue(SessionManager.access$100(SessionManager.this));

        public ProcessorThread(XMPPProcessorIfc processor) {
            this.processor = processor;
        }

        public boolean addItem(Packet packet, XMPPResourceConnection conn) {
            QueueItem item = new QueueItem();
            item.packet = packet;
            item.conn = conn;
            return this.in_queue.offer(item);
        }

        @Override
        public void run() {
            QueueItem item = null;
            while (!this.stopped) {
                try {
                    item = this.in_queue.take();
                    if (item.conn != null) {
                        this.processor.process(item.packet, item.conn, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                        SessionManager.this.setPermissions(item.conn, this.local_results);
                    } else {
                        this.processor.process(item.packet, null, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                    }
                    SessionManager.this.addOutPackets(this.local_results);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception during packet processing: " + item.packet.toString(), e);
                }
            }
        }
    }

    private class QueueItem {
        Packet packet;
        XMPPResourceConnection conn;

        private QueueItem() {
        }
    }
}

