/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Queue;
import tigase.server.Packet;
import tigase.server.sreceiver.AbstractReceiverTask;
import tigase.xmpp.StanzaType;

public class TesterTask
extends AbstractReceiverTask {
    private static final String TASK_TYPE = "Tester Task";
    private static final String TASK_HELP = "This task pretends to be a user. Allows you to [un]subscribe to its roster, send a message and perform some other actions. Roster of this task is stored in memory only and is cleared on server restart. Full list of supported actions will be sent to you as a response to //help message. The purpose of this task is testing of the Tigase server and the task should not be normally loaded on to live system.";

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    private String commandsHelp() {
        return "Available commands are:\n//help - display this help info\n For now you can only subsribe to and unsubscribe from task roster and send a message to task as it was a user. The task will always respond to your messages with following text:\n This is response to your message: [your message included here]";
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCData("/message/body");
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void runCommand(Packet packet, Queue<Packet> results) {
        String body = packet.getElemCData("/message/body");
        String[] body_split = body.split(" |\n|\r");
        command comm = command.valueOf(body_split[0].substring(2));
        switch (comm) {
            case help: {
                results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.chat, this.commandsHelp(), "Commands description", null));
            }
        }
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        } else {
            String body = packet.getElemCData("/message/body");
            results.offer(Packet.getMessage(packet.getElemFrom(), packet.getElemTo(), StanzaType.normal, "This is response to your message: [" + body + "]", "Response", null));
        }
    }

    private static enum command {
        help;

    }
}

