/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Arrays;
import tigase.server.sreceiver.DefaultValues;

public class PropertyItem {
    private String name = null;
    private String display_name = null;
    private Object value = null;
    private String[] possible_values = null;
    private String description = null;

    public PropertyItem(String name, String display_name, Object def_value, String[] possible_values, String description) {
        this.name = name;
        this.display_name = display_name;
        this.value = def_value;
        this.description = description;
        if (possible_values != null) {
            this.possible_values = Arrays.copyOf(possible_values, possible_values.length);
        } else if (this.value != null) {
            this.guessPossibleValues();
        }
    }

    public PropertyItem(String name, Object def_value) {
        this.name = name;
        this.value = def_value;
        if (this.value != null) {
            this.guessPossibleValues();
        }
    }

    public PropertyItem(String name, String display_name, Object def_value) {
        this.name = name;
        this.display_name = display_name;
        this.value = def_value;
        if (this.value != null) {
            this.guessPossibleValues();
        }
    }

    private void guessPossibleValues() {
        if (this.value instanceof DefaultValues) {
            DefaultValues en_val = (DefaultValues)this.value;
            this.possible_values = en_val.strValues();
        }
        if (this.value instanceof Boolean) {
            this.possible_values = new String[]{"true", "false"};
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public String getDisplay_name() {
        return this.display_name != null ? this.display_name : this.name;
    }

    public void setDisplay_name(String argDisplay_name) {
        this.display_name = argDisplay_name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object argValue) {
        this.value = argValue;
    }

    public String[] getPossible_values() {
        return this.possible_values != null ? Arrays.copyOf(this.possible_values, this.possible_values.length) : null;
    }

    public void setPossible_values(String[] argPossible_values) {
        this.possible_values = argPossible_values != null ? Arrays.copyOf(argPossible_values, argPossible_values.length) : null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String argDescription) {
        this.description = argDescription;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "";
    }
}

