/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.db.DBInitException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;

public class RepositoryFactory {
    private static ConcurrentMap<String, ConcurrentMap<String, UserRepository>> user_repos = new ConcurrentHashMap<String, ConcurrentMap<String, UserRepository>>();
    private static ConcurrentMap<String, ConcurrentMap<String, UserAuthRepository>> auth_repos = new ConcurrentHashMap<String, ConcurrentMap<String, UserAuthRepository>>();

    public static UserRepository getUserRepository(String comp_name, String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        UserRepository rep;
        ConcurrentHashMap<String, UserRepository> repo_map;
        if (class_name.equals("tigase.db.xml.XMLRepository")) {
            comp_name = resource;
        }
        if ((repo_map = (ConcurrentHashMap<String, UserRepository>)user_repos.get(comp_name)) == null) {
            repo_map = new ConcurrentHashMap<String, UserRepository>();
            user_repos.put(comp_name, repo_map);
        }
        if ((rep = (UserRepository)repo_map.get(resource)) == null) {
            rep = (UserRepository)Class.forName(class_name).newInstance();
            rep.initRepository(resource, params);
            repo_map.put(resource, rep);
        }
        return rep;
    }

    public static UserAuthRepository getAuthRepository(String comp_name, String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        UserAuthRepository rep;
        ConcurrentHashMap<String, UserAuthRepository> repo_map;
        if (class_name.equals("tigase.db.xml.XMLRepository")) {
            comp_name = resource;
        }
        if ((repo_map = (ConcurrentHashMap<String, UserAuthRepository>)auth_repos.get(comp_name)) == null) {
            repo_map = new ConcurrentHashMap<String, UserAuthRepository>();
            auth_repos.put(comp_name, repo_map);
        }
        if ((rep = (UserAuthRepository)repo_map.get(resource)) == null) {
            rep = RepositoryFactory.tryCastUserRepository(comp_name, resource);
            if (rep != null && !rep.getClass().getName().equals(class_name)) {
                rep = null;
            }
            if (rep == null) {
                rep = (UserAuthRepository)Class.forName(class_name).newInstance();
                rep.initRepository(resource, params);
                repo_map.put(resource, rep);
            }
        }
        return rep;
    }

    private static UserAuthRepository tryCastUserRepository(String comp_name, String resource) {
        UserRepository rep;
        ConcurrentHashMap repo_map = (ConcurrentHashMap)user_repos.get(comp_name);
        if (repo_map == null) {
            repo_map = new ConcurrentHashMap();
            user_repos.put(comp_name, repo_map);
        }
        if ((rep = (UserRepository)repo_map.get(resource)) != null) {
            try {
                return (UserAuthRepository)((Object)rep);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

