/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class ClusterController
extends AbstractComponentRegistrator<ClusteredComponent>
implements XMPPService {
    private static final Logger log = Logger.getLogger("tigase.cluster.ClusterController");
    private ServiceEntity serviceEntity = null;
    private Level statsLevel = Level.INFO;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "load", "Server clustering");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "load", "Server clustering"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
    }

    @Override
    public void componentAdded(ClusteredComponent component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof ClusteredComponent;
    }

    @Override
    public void componentRemoved(ClusteredComponent component) {
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoItems(node, jid);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, JIDUtils.getNodeID((String)this.getName(), (String)jid)));
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (packet.getElement().getName() == "cluster") {
            ClusterElement clem = new ClusterElement(packet.getElement());
            if (ClusterMethods.UPDATE_NODES.toString().equals(clem.getMethodName())) {
                String connected_nodes = clem.getMethodParam("connected");
                String disconnected_nodes = clem.getMethodParam("disconnected");
                for (ClusteredComponent comp : this.components.values()) {
                    if (connected_nodes != null) {
                        comp.nodesConnected(new LinkedHashSet<String>(Arrays.asList(connected_nodes.split(","))));
                    }
                    if (disconnected_nodes == null) continue;
                    comp.nodesDisconnected(new LinkedHashSet<String>(Arrays.asList(disconnected_nodes.split(","))));
                }
            }
        }
    }
}

