/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.xep0136;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import tigase.util.JDBCAbstract;
import tigase.util.JIDUtils;
import tigase.util.SimpleCache;
import tigase.xml.Element;

public class MessageArchiveDB
extends JDBCAbstract {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.xep0136.MessageArchiveDB");
    private static final long LONG_NULL = 0L;
    private PreparedStatement save_message_st = null;
    private PreparedStatement get_msg_for_jid_st = null;
    private PreparedStatement get_jid_id_st = null;
    private PreparedStatement get_jids_id_st = null;
    private PreparedStatement add_jid_st = null;
    private PreparedStatement add_thread_st = null;
    private PreparedStatement get_thread_id_st = null;
    private PreparedStatement add_subject_st = null;
    private PreparedStatement get_subject_id_st = null;
    private int cacheSize = 10000;
    private long cacheTime = 3600000L;
    private Map<String, Object> cache = null;

    protected void initPreparedStatements() throws SQLException {
        super.initPreparedStatements();
        String query = "insert into tig_ma_jid (jid) values (?);";
        this.add_jid_st = this.prepareStatement(query);
        query = "select ma_j_id from tig_ma_jid where jid = ?;";
        this.get_jid_id_st = this.prepareStatement(query);
        query = "select * from tig_ma_jid where (jid = ?) or (jid = ?);";
        this.get_jids_id_st = this.prepareStatement(query);
        query = "insert into tig_ma_thread (thread) values (?);";
        this.add_thread_st = this.prepareStatement(query);
        query = "select ma_t_id from tig_ma_thread where (thread = ?);";
        this.get_thread_id_st = this.prepareStatement(query);
        query = "insert into tig_ma_subject (subject) values (?);";
        this.add_subject_st = this.prepareStatement(query);
        query = "select ma_s_id from tig_ma_subject where (subject = ?);";
        this.get_subject_id_st = this.prepareStatement(query);
    }

    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        this.setResourceUri(conn_str);
        this.cache = Collections.synchronizedMap(new SimpleCache(10000, 60000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long[] getJidsIds(String ... jids) throws SQLException {
        long[] lArray;
        ResultSet rs;
        block17: {
            long[] results;
            block15: {
                PreparedStatement preparedStatement;
                block16: {
                    rs = null;
                    this.checkConnection();
                    results = new long[jids.length];
                    for (int i = 0; i < results.length; ++i) {
                        results[i] = 0L;
                    }
                    if (jids.length != 1) break block15;
                    preparedStatement = this.get_jid_id_st;
                    // MONITORENTER : preparedStatement
                    this.get_jid_id_st.setString(1, jids[0]);
                    rs = this.get_jid_id_st.executeQuery();
                    if (!rs.next()) break block16;
                    results[0] = rs.getLong("ma_j_id");
                    long[] lArray2 = results;
                    // MONITOREXIT : preparedStatement
                    this.release(null, rs);
                    return lArray2;
                }
                // MONITOREXIT : preparedStatement
                preparedStatement = null;
                this.release(null, rs);
                return preparedStatement;
            }
            try {
                PreparedStatement preparedStatement = this.get_jids_id_st;
                // MONITORENTER : preparedStatement
                for (int i = 0; i < jids.length; ++i) {
                    this.get_jids_id_st.setString(i + 1, jids[i]);
                }
                rs = this.get_jids_id_st.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    String db_jid = rs.getString("jid");
                    for (int i = 0; i < jids.length; ++i) {
                        if (!db_jid.equals(jids[i])) continue;
                        results[i] = rs.getLong("ma_j_id");
                        ++cnt;
                    }
                }
                if (cnt <= 0) break block17;
                lArray = results;
                // MONITOREXIT : preparedStatement
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
            this.release(null, rs);
            return lArray;
        }
        lArray = null;
        // MONITOREXIT : preparedStatement
        this.release(null, rs);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidID(String jid) throws SQLException {
        this.checkConnection();
        PreparedStatement preparedStatement = this.add_jid_st;
        synchronized (preparedStatement) {
            this.add_jid_st.setString(1, jid);
            this.add_jid_st.executeUpdate();
        }
        long[] jid_ids = this.getJidsIds(jid);
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.warning("I have just added new jid but it was not found.... " + jid);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getThreadID(String thread) throws SQLException {
        ResultSet rs;
        block7: {
            long l;
            rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.get_thread_id_st;
                synchronized (preparedStatement) {
                    this.get_thread_id_st.setString(1, thread);
                    rs = this.get_thread_id_st.executeQuery();
                    if (rs.next()) {
                        l = rs.getLong("ma_t_id");
                    }
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
            this.release(null, rs);
            return l;
        }
        this.release(null, rs);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSubjectID(String subject) throws SQLException {
        ResultSet rs;
        block7: {
            long l;
            rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.get_subject_id_st;
                synchronized (preparedStatement) {
                    this.get_subject_id_st.setString(1, subject);
                    rs = this.get_subject_id_st.executeQuery();
                    if (rs.next()) {
                        l = rs.getLong("ma_s_id");
                    }
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
            this.release(null, rs);
            return l;
        }
        this.release(null, rs);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addThreadID(String thread) throws SQLException {
        long result = this.getThreadID(thread);
        if (result != 0L) {
            return result;
        }
        PreparedStatement preparedStatement = this.add_thread_st;
        synchronized (preparedStatement) {
            this.add_thread_st.setString(1, thread);
            this.add_thread_st.executeUpdate();
        }
        result = this.getThreadID(thread);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addSubjectID(String subject) throws SQLException {
        long result = this.getSubjectID(subject);
        if (result != 0L) {
            return result;
        }
        PreparedStatement preparedStatement = this.add_subject_st;
        synchronized (preparedStatement) {
            this.add_subject_st.setString(1, subject);
            this.add_subject_st.executeUpdate();
        }
        result = this.getSubjectID(subject);
        return result;
    }

    public void saveMessage(Element message, boolean full_content, String defLang) throws SQLException {
        String from_str = JIDUtils.getNodeID((String)message.getAttribute("from"));
        String to_str = JIDUtils.getNodeID((String)message.getAttribute("to"));
        long[] ids = this.getJidsIds(from_str, to_str);
        long from_id = ids[0] != 0L ? ids[0] : this.addJidID(from_str);
        long to_id = ids[1] != 0L ? ids[1] : this.addJidID(to_str);
        String thread = message.getCData("/message/thread");
        long thread_id = 0L;
        String subject = message.getCData("/message/subject");
        long subject_id = 0L;
        if (thread != null && !thread.trim().isEmpty()) {
            thread_id = this.addThreadID(thread);
        }
        if (subject != null && !subject.trim().isEmpty()) {
            subject_id = this.addSubjectID(subject);
        }
    }

    public void getMessages(String jid, String with_jid, Date timestamp, int limit) {
    }
}

