/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.Roster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;

public class RosterFlat
extends RosterAbstract {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterFlat");
    private static final SimpleParser parser = SingletonFactory.getParserInstance();

    private Map<String, RosterElement> loadUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedHashMap<String, RosterElement> roster = new LinkedHashMap<String, RosterElement>();
        session.putSessionData("roster", roster);
        String roster_str = session.getData(null, "roster", null);
        log.finest("Loaded user roster: " + roster_str);
        if (roster_str != null && !roster_str.isEmpty()) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, roster_str.toCharArray(), 0, roster_str.length());
            Queue elems = domHandler.getParsedElements();
            if (elems != null && elems.size() > 0) {
                for (Element elem : elems) {
                    RosterElement relem = new RosterElement(elem);
                    roster.put(relem.getJid(), relem);
                }
            }
        } else {
            Roster oldRoster = new Roster();
            String[] buddies = oldRoster.getBuddies(session);
            if (buddies != null && buddies.length > 0) {
                for (String buddy : buddies) {
                    String name = oldRoster.getBuddyName(session, buddy);
                    RosterAbstract.SubscriptionType subscr = oldRoster.getBuddySubscription(session, buddy);
                    String[] groups = oldRoster.getBuddyGroups(session, buddy);
                    RosterElement relem = new RosterElement(buddy, name, groups);
                    relem.setSubscription(subscr);
                    roster.put(buddy, relem);
                }
                this.saveUserRoster(session);
            }
        }
        return roster;
    }

    private void saveUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        StringBuilder sb = new StringBuilder();
        for (RosterElement relem : roster.values()) {
            sb.append(relem.getRosterElement().toString());
        }
        log.finest("Saving user roster: " + sb.toString());
        session.setData(null, "roster", sb.toString());
    }

    private Map<String, RosterElement> getUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = (Map<String, RosterElement>)session.getSessionData("roster");
        if (roster == null) {
            roster = this.loadUserRoster(session);
        }
        return roster;
    }

    private RosterElement getRosterElement(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        return roster.get(JIDUtils.getNodeID((String)buddy));
    }

    @Override
    public String[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        return roster.keySet().toArray(new String[0]);
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getName();
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, String buddy, String name) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            log.finest("Setting name: '" + name + "' for buddy: " + buddy);
            relem.setName(name);
            this.saveUserRoster(session);
        } else {
            log.warning("Setting buddy name for non-existen contact: " + buddy);
        }
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        relem.setSubscription(subscription);
        this.saveUserRoster(session);
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getSubscription();
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, String jid) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        roster.remove(jid);
        this.saveUserRoster(session);
        return true;
    }

    @Override
    public void addBuddy(XMPPResourceConnection session, String jid, String name, String[] groups) throws NotAuthorizedException, TigaseDBException {
        Map<String, RosterElement> roster = this.getUserRoster(session);
        String buddy = JIDUtils.getNodeID((String)jid);
        RosterElement relem = new RosterElement(buddy, name, groups);
        roster.put(buddy, relem);
        this.saveUserRoster(session);
        log.finest("Added buddy to roster: " + jid);
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getGroups();
    }
}

