/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.auth.LoginHandler;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.RepositoryAccess;
import tigase.xmpp.XMPPSession;

public class XMPPResourceConnection
extends RepositoryAccess {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPResourceConnection");
    private LoginHandler loginHandler = null;
    private XMPPSession parentSession = null;
    private String sessionId = null;
    private String defLang = "en";
    private String resource = null;
    private long lastAccessed = 0L;
    private long creationTime = 0L;
    private long authenticationTime = 0L;
    private String domain = null;
    private String connectionId = null;
    private int priority = 0;
    private String userJid = null;
    private String userId = null;
    private long id_counter = 0L;
    private ConnectionStatus connectionStatus = ConnectionStatus.INIT;
    private Map<String, Object> sessionData = null;

    public XMPPResourceConnection(String connectionId, UserRepository rep, UserAuthRepository authRepo, LoginHandler loginHandler, boolean anon_allowed) {
        super(rep, authRepo, anon_allowed);
        this.connectionId = connectionId;
        this.loginHandler = loginHandler;
        this.creationTime = System.currentTimeMillis();
        this.sessionData = new HashMap<String, Object>();
    }

    public void setConnectionStatus(ConnectionStatus status) {
        this.connectionStatus = status;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public final void putSessionData(String key, Object value) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.put(key, value);
    }

    public final Object getSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        return this.sessionData.get(key);
    }

    public final void removeSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.remove(key);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void streamClosed() {
        if (this.parentSession != null) {
            this.parentSession.streamClosed(this);
        }
        this.parentSession = null;
        this.resource = null;
        this.sessionId = null;
    }

    public void setParentSession(XMPPSession parent) {
        this.parentSession = parent;
        if (this.parentSession != null) {
            this.userId = JIDUtils.getNodeID((String)this.parentSession.getUserName(), (String)this.domain);
            this.userJid = this.userId + (this.resource != null ? "/" + this.resource : "/" + this.sessionId);
        }
    }

    public XMPPSession getParentSession() {
        return this.parentSession;
    }

    public final String getJID() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid;
    }

    @Override
    public final String getUserId() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userId;
    }

    @Override
    public final String getUserName() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getUserName();
    }

    public List<XMPPResourceConnection> getActiveSessions() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getActiveResources();
    }

    public String[] getAllResourcesJIDs() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getJIDs();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String argSessionId) {
        this.sessionId = argSessionId;
    }

    public String getDefLang() {
        return this.defLang;
    }

    public void setDefLang(String lang) {
        this.defLang = lang;
    }

    public boolean isResourceSet() {
        return this.resource != null;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String argResource) throws NotAuthorizedException {
        this.resource = argResource;
        this.parentSession.resourceSet(this);
        this.userJid = this.getUserId() + (this.resource != null ? "/" + this.resource : "/" + this.sessionId);
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long argLastAccessed) {
        this.lastAccessed = argLastAccessed;
    }

    public String getConnectionId() {
        this.lastAccessed = System.currentTimeMillis();
        return this.connectionId;
    }

    public String getConnectionId(String jid) {
        return this.parentSession == null || jid == null ? this.connectionId : this.parentSession.getResourceConnection(jid).getConnectionId();
    }

    @Override
    public final void logout() throws NotAuthorizedException {
        this.loginHandler.handleLogout(this.getUserName(), this);
        this.streamClosed();
        super.logout();
    }

    @Override
    protected void login() {
        this.authenticationTime = System.currentTimeMillis();
    }

    public long getAuthTime() {
        return this.authenticationTime - this.creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Authorization unregister(String name_param) throws NotAuthorizedException, TigaseDBException {
        Authorization auth_res = super.unregister(name_param);
        return auth_res;
    }

    @Override
    public final Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginPlain(user, password);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginDigest(user, digest, id, alg);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginOther(props);
        if (result == Authorization.AUTHORIZED) {
            String user = (String)props.get("user-id");
            log.finest("UserAuthRepository.USER_ID_KEY: " + user);
            String nick = JIDUtils.getNodeNick((String)user);
            if (nick == null) {
                nick = user;
            }
            this.loginHandler.handleLogin(nick, this);
        }
        return result;
    }

    public String nextStanzaId() {
        return "tig" + ++this.id_counter;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        super.queryAuth(authProps);
    }
}

