/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.JIDUtils;

public class TigaseCustomAuth
implements UserAuthRepository {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.TigaseCustomAuth");
    public static final String DEF_CONNVALID_KEY = "conn-valid-query";
    public static final String DEF_INITDB_KEY = "init-db-query";
    public static final String DEF_ADDUSER_KEY = "add-user-query";
    public static final String DEF_DELUSER_KEY = "del-user-query";
    public static final String DEF_GETPASSWORD_KEY = "get-password-query";
    public static final String DEF_UPDATEPASSWORD_KEY = "update-password-query";
    public static final String DEF_USERLOGIN_KEY = "user-login-query";
    public static final String DEF_USERLOGOUT_KEY = "user-logout-query";
    public static final String DEF_NONSASL_MECHS_KEY = "non-sasl-mechs";
    public static final String DEF_SASL_MECHS_KEY = "sasl-mechs";
    public static final String DEF_CONNVALID_QUERY = "select 1";
    public static final String DEF_INITDB_QUERY = "{ call TigInitdb() }";
    public static final String DEF_ADDUSER_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    public static final String DEF_DELUSER_QUERY = "{ call TigRemoveUser(?) }";
    public static final String DEF_GETPASSWORD_QUERY = "{ call TigGetPassword(?) }";
    public static final String DEF_UPDATEPASSWORD_QUERY = "{ call TigUpdatePasswordPlainPwRev(?, ?) }";
    public static final String DEF_USERLOGIN_QUERY = "{ call TigUserLoginPlainPw(?, ?) }";
    public static final String DEF_USERLOGOUT_QUERY = "{ call TigUserLogout(?) }";
    public static final String DEF_NONSASL_MECHS = "password";
    public static final String DEF_SASL_MECHS = "PLAIN";
    public static final String SP_STARTS_WITH = "{ call";
    private String convalid_query = "select 1";
    private String initdb_query = "{ call TigInitdb() }";
    private String adduser_query = "{ call TigAddUserPlainPw(?, ?) }";
    private String deluser_query = "{ call TigRemoveUser(?) }";
    private String getpassword_query = "{ call TigGetPassword(?) }";
    private String updatepassword_query = "{ call TigUpdatePasswordPlainPwRev(?, ?) }";
    private String userlogin_query = "{ call TigUserLoginPlainPw(?, ?) }";
    private String userlogout_query = "{ call TigUserLogout(?) }";
    private String[] nonsasl_mechs = "password".split(",");
    private String[] sasl_mechs = "PLAIN".split(",");
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement init_db = null;
    private PreparedStatement add_user = null;
    private PreparedStatement remove_user = null;
    private PreparedStatement get_pass = null;
    private PreparedStatement update_pass = null;
    private PreparedStatement user_login = null;
    private PreparedStatement user_logout = null;
    private PreparedStatement conn_valid_st = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean online_status = false;
    private boolean userlogin_active = false;

    private PreparedStatement prepareQuery(String query) throws SQLException {
        if (query.startsWith(SP_STARTS_WITH)) {
            return this.conn.prepareCall(query);
        }
        return this.conn.prepareStatement(query);
    }

    private void initPreparedStatements() throws SQLException {
        this.conn_valid_st = this.prepareQuery(this.convalid_query);
        this.init_db = this.prepareQuery(this.initdb_query);
        this.add_user = this.prepareQuery(this.adduser_query);
        this.remove_user = this.prepareQuery(this.deluser_query);
        this.get_pass = this.prepareQuery(this.getpassword_query);
        this.update_pass = this.prepareQuery(this.updatepassword_query);
        this.user_login = this.prepareQuery(this.userlogin_query);
        this.user_logout = this.prepareQuery(this.userlogout_query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    rs = this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPassword(String user) throws TigaseDBException, UserNotFoundException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            PreparedStatement preparedStatement = this.get_pass;
            synchronized (preparedStatement) {
                this.get_pass.setString(1, JIDUtils.getNodeID((String)user));
                rs = this.get_pass.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                string = rs.getString(1);
            }
            this.release(null, rs);
            return string;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving user password.", e);
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", this.nonsasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", this.sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.conn = DriverManager.getConnection(this.db_conn);
            this.initPreparedStatements();
        }
    }

    private String getParamWithDef(Map<String, String> params, String key, String def) {
        if (params == null) {
            return def;
        }
        String result = params.get(key);
        if (result != null) {
            log.config("Custom query loaded for '" + key + "': '" + result + "'");
        } else {
            log.config("Default query loaded for '" + key + "': '" + def + "'");
        }
        return result != null ? result.trim() : def;
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        this.db_conn = connection_str;
        this.convalid_query = this.getParamWithDef(params, DEF_CONNVALID_KEY, DEF_CONNVALID_QUERY);
        this.initdb_query = this.getParamWithDef(params, DEF_INITDB_KEY, DEF_INITDB_QUERY);
        this.adduser_query = this.getParamWithDef(params, DEF_ADDUSER_KEY, DEF_ADDUSER_QUERY);
        this.deluser_query = this.getParamWithDef(params, DEF_DELUSER_KEY, DEF_DELUSER_QUERY);
        this.getpassword_query = this.getParamWithDef(params, DEF_GETPASSWORD_KEY, DEF_GETPASSWORD_QUERY);
        this.updatepassword_query = this.getParamWithDef(params, DEF_UPDATEPASSWORD_KEY, DEF_UPDATEPASSWORD_QUERY);
        if (params != null && params.get(DEF_USERLOGIN_KEY) != null) {
            this.userlogin_query = this.getParamWithDef(params, DEF_USERLOGIN_KEY, DEF_USERLOGIN_QUERY);
            this.userlogin_active = true;
        }
        this.userlogout_query = this.getParamWithDef(params, DEF_USERLOGOUT_KEY, DEF_USERLOGOUT_QUERY);
        this.nonsasl_mechs = this.getParamWithDef(params, DEF_NONSASL_MECHS_KEY, DEF_NONSASL_MECHS).split(",");
        this.sasl_mechs = this.getParamWithDef(params, DEF_SASL_MECHS_KEY, DEF_SASL_MECHS).split(",");
        try {
            this.initRepo();
            if (params != null && params.get("init-db") != null) {
                this.init_db.executeQuery();
            }
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean userLoginAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.user_login;
            // MONITORENTER : preparedStatement
            String user_id = JIDUtils.getNodeID((String)user);
            this.user_login.setString(1, user_id);
            this.user_login.setString(2, password);
            rs = this.user_login.executeQuery();
            if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
            boolean auth_result_ok = user_id.equals(rs.getString(1));
            if (auth_result_ok) {
                boolean bl = true;
                // MONITOREXIT : preparedStatement
                this.release(null, rs);
                return bl;
            }
            log.fine("Login failed, for user: '" + user_id + "'" + ", password: '" + password + "'" + ", from DB got: " + rs.getString(1));
            throw new UserNotFoundException("User does not exist: " + user);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            return this.userLoginAuth(user, password);
        }
        String db_password = this.getPassword(user);
        return password != null && db_password != null && db_password.equals(password);
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            throw new AuthorizationException("Not supported.");
        }
        String db_password = this.getPassword(user);
        try {
            String digest_db_pass = Algorithms.hexDigest((String)id, (String)db_password, (String)alg);
            log.finest("Comparing passwords, given: " + digest + ", db: " + digest_db_pass);
            return digest.equals(digest_db_pass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("No such algorithm.", e);
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals(DEF_SASL_MECHS)) {
                return this.saslPlainAuth(props);
            }
            return this.saslAuth(props);
        }
        throw new AuthorizationException("Protocol is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.user_logout;
            synchronized (preparedStatement) {
                this.user_logout.setString(1, JIDUtils.getNodeID((String)user));
                this.user_logout.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.add_user;
            synchronized (preparedStatement) {
                this.add_user.setString(1, JIDUtils.getNodeID((String)user));
                this.add_user.setString(2, password);
                boolean is_result = this.add_user.execute();
                if (is_result) {
                    rs = this.add_user.getResultSet();
                }
            }
            this.release(null, rs);
            return;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", e2);
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(String user, String password) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.update_pass;
            synchronized (preparedStatement) {
                this.update_pass.setString(1, password);
                this.update_pass.setString(2, JIDUtils.getNodeID((String)user));
                this.update_pass.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.remove_user;
            synchronized (preparedStatement) {
                this.remove_user.setString(1, JIDUtils.getNodeID((String)user));
                this.remove_user.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    private String decodeString(byte[] source, int start_from) {
        int idx;
        for (idx = start_from; source[idx] != 0 && idx < source.length; ++idx) {
        }
        return new String(source, start_from, idx - start_from);
    }

    private boolean saslPlainAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        int user_idx;
        int auth_idx;
        String data_str = (String)props.get("data");
        String domain = (String)props.get("realm");
        props.put("result", null);
        byte[] in_data = data_str != null ? Base64.decode((String)data_str) : new byte[]{};
        for (auth_idx = 0; in_data[auth_idx] != 0 && auth_idx < in_data.length; ++auth_idx) {
        }
        String authoriz = new String(in_data, 0, auth_idx);
        for (user_idx = ++auth_idx; in_data[user_idx] != 0 && user_idx < in_data.length; ++user_idx) {
        }
        String user_name = new String(in_data, auth_idx, user_idx - auth_idx);
        ++user_idx;
        String jid = user_name;
        if (JIDUtils.getNodeNick((String)user_name) == null) {
            jid = JIDUtils.getNodeID((String)user_name, (String)domain);
        }
        props.put("user-id", jid);
        String passwd = new String(in_data, user_idx, in_data.length - user_idx);
        return this.plainAuth(jid, passwd);
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            log.finest("response: " + new String(in_data));
            byte[] challenge = ss.evaluateResponse(in_data);
            log.finest("challenge: " + (challenge != null ? new String(challenge) : "null"));
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                log.finest("Callback: " + callbacks[i].getClass().getSimpleName());
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    log.finest("RealmCallback: " + realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = JIDUtils.getNodeID((String)user_name, (String)((String)this.options.get("realm")));
                    this.options.put("user-id", jid);
                    log.finest("NameCallback: " + user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = TigaseCustomAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        log.finest("PasswordCallback: " + passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    log.finest("AuthorizeCallback: authenId: " + authenId);
                    String authorId = authCallback.getAuthorizationID();
                    log.finest("AuthorizeCallback: authorId: " + authorId);
                    if (!authenId.equals(authorId)) continue;
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

