/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class Roster {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Roster");
    protected static final String ROSTER_XMLNS = "jabber:iq:roster";
    protected static final String ROSTER = "roster";
    protected static final String GROUPS = "groups";
    protected static final String NAME = "name";
    protected static final String SUBSCRIPTION = "subscription";
    protected static final EnumSet<SubscriptionType> TO_SUBSCRIBED = EnumSet.of(SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.both);
    protected static final EnumSet<SubscriptionType> FROM_SUBSCRIBED = EnumSet.of(SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.both);
    protected static final EnumSet<StanzaType> INITIAL_PRESENCES = EnumSet.of(StanzaType.available, StanzaType.unavailable);
    protected static final EnumSet<SubscriptionType> PENDING_IN = EnumSet.of(SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.to_pending_in);
    private static EnumMap<SubscriptionType, StateTransition> subsToStateMap = new EnumMap(SubscriptionType.class);

    public static SubscriptionType getStateTransition(SubscriptionType subscription, PresenceType presence) {
        return subsToStateMap.get((Object)subscription).getStateTransition(presence);
    }

    public static PresenceType getPresenceType(XMPPResourceConnection session, Packet packet) throws NotAuthorizedException {
        StanzaType type;
        String to = packet.getElemTo();
        if (to != null) {
            to = JIDUtils.getNodeID((String)to);
        }
        if ((type = packet.getType()) == null) {
            type = StanzaType.available;
        } else if (type == StanzaType.error) {
            return PresenceType.error;
        }
        if (to == null || !to.equals(session.getUserId())) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.out_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.out_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.out_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.out_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.out_unsubscribed;
            }
        }
        if (to != null && to.equals(session.getUserId())) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.in_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.in_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.in_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.in_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.in_unsubscribed;
            }
            if (type == StanzaType.probe) {
                return PresenceType.in_probe;
            }
        }
        return null;
    }

    public static boolean isPendingIn(XMPPResourceConnection session, String jid) throws NotAuthorizedException {
        SubscriptionType subscr = Roster.getBuddySubscription(session, jid);
        return PENDING_IN.contains((Object)subscr);
    }

    public static boolean isSubscribedTo(XMPPResourceConnection session, String jid) throws NotAuthorizedException {
        SubscriptionType subscr = Roster.getBuddySubscription(session, jid);
        return TO_SUBSCRIBED.contains((Object)subscr);
    }

    public static boolean isSubscribedFrom(XMPPResourceConnection session, String jid) throws NotAuthorizedException {
        SubscriptionType subscr = Roster.getBuddySubscription(session, jid);
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public static boolean isSubscribedFrom(SubscriptionType subscr) {
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public static String groupNode(String buddy) {
        return "roster/" + JIDUtils.getNodeID((String)buddy);
    }

    public static String[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException {
        return session.getDataGroups(ROSTER);
    }

    public static String[] getBuddies(XMPPResourceConnection session, EnumSet<SubscriptionType> subscrs) throws NotAuthorizedException {
        String[] allBuddies = Roster.getBuddies(session);
        if (allBuddies == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String buddy : allBuddies) {
            SubscriptionType subs = Roster.getBuddySubscription(session, buddy);
            if (!subscrs.contains((Object)subs)) continue;
            list.add(buddy);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getBuddyName(XMPPResourceConnection session, String buddy) throws NotAuthorizedException {
        return session.getData(Roster.groupNode(buddy), NAME, null);
    }

    public static void setBuddyName(XMPPResourceConnection session, String buddy, String name) throws NotAuthorizedException {
        session.setData(Roster.groupNode(buddy), NAME, name);
    }

    public static void setBuddySubscription(XMPPResourceConnection session, SubscriptionType subscription, String buddy) throws NotAuthorizedException {
        session.setData(Roster.groupNode(buddy), SUBSCRIPTION, subscription.toString());
    }

    public static SubscriptionType getBuddySubscription(XMPPResourceConnection session, String buddy) throws NotAuthorizedException {
        String subscr = session.getData(Roster.groupNode(buddy), SUBSCRIPTION, null);
        if (subscr != null) {
            return SubscriptionType.valueOf(subscr);
        }
        return null;
    }

    public static boolean removeBuddy(XMPPResourceConnection session, String jid) throws NotAuthorizedException {
        session.removeDataGroup(Roster.groupNode(jid));
        return true;
    }

    public static void addBuddy(XMPPResourceConnection session, String jid) throws NotAuthorizedException {
        String nick = JIDUtils.getNodeNick((String)jid);
        if (nick == null) {
            nick = jid;
        }
        session.setData(Roster.groupNode(jid), NAME, nick);
        session.setData(Roster.groupNode(jid), SUBSCRIPTION, SubscriptionType.none.toString());
    }

    public static boolean updateBuddySubscription(XMPPResourceConnection session, PresenceType presence, String jid) throws NotAuthorizedException {
        SubscriptionType current_subscription = Roster.getBuddySubscription(session, jid);
        log.finest("current_subscription=" + (Object)((Object)current_subscription) + " for jid=" + jid);
        if (current_subscription == null) {
            Roster.addBuddy(session, jid);
            current_subscription = SubscriptionType.none;
        }
        SubscriptionType new_subscription = Roster.getStateTransition(current_subscription, presence);
        log.finest("new_subscription=" + (Object)((Object)new_subscription) + " for presence=" + (Object)((Object)presence));
        if (current_subscription != new_subscription) {
            Roster.setBuddySubscription(session, new_subscription, jid);
            return true;
        }
        return false;
    }

    public static String[] getBuddyGroups(XMPPResourceConnection session, String buddy) throws NotAuthorizedException {
        return session.getDataList(Roster.groupNode(buddy), GROUPS);
    }

    public static Element getBuddyItem(XMPPResourceConnection session, String buddy) throws NotAuthorizedException {
        String[] groups;
        SubscriptionType subscr = Roster.getBuddySubscription(session, buddy);
        if (subscr == null) {
            subscr = SubscriptionType.none;
            Roster.setBuddySubscription(session, subscr, buddy);
        }
        Element item = new Element("item");
        item.setAttribute("jid", JIDUtils.getNodeID((String)buddy));
        item.addAttributes(subscr.getSubscriptionAttr());
        String name = Roster.getBuddyName(session, buddy);
        if (name != null) {
            item.setAttribute(NAME, XMLUtils.escape((String)name));
        }
        if ((groups = Roster.getBuddyGroups(session, buddy)) != null) {
            for (String gr : groups) {
                Element group = new Element("group");
                group.setCData(XMLUtils.escape((String)gr));
                item.addChild(group);
            }
        }
        return item;
    }

    public static void updateBuddyChange(XMPPResourceConnection session, Queue<Packet> results, Element item) throws NotAuthorizedException {
        Element update = new Element("iq");
        update.setAttribute("type", StanzaType.set.toString());
        Element query = new Element("query");
        query.setXMLNS(ROSTER_XMLNS);
        query.addChild(item);
        update.addChild(query);
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            Element conn_update = update.clone();
            conn_update.setAttribute("to", conn.getJID());
            conn_update.setAttribute("id", "rst" + session.nextStanzaId());
            Packet pack_update = new Packet(conn_update);
            pack_update.setTo(conn.getConnectionId());
            pack_update.setFrom(session.getJID());
            results.offer(pack_update);
        }
    }

    static {
        subsToStateMap.put(SubscriptionType.none, StateTransition.none);
        subsToStateMap.put(SubscriptionType.none_pending_out, StateTransition.none_pending_out);
        subsToStateMap.put(SubscriptionType.none_pending_in, StateTransition.none_pending_in);
        subsToStateMap.put(SubscriptionType.none_pending_out_in, StateTransition.none_pending_out_in);
        subsToStateMap.put(SubscriptionType.to, StateTransition.to);
        subsToStateMap.put(SubscriptionType.to_pending_in, StateTransition.to_pending_in);
        subsToStateMap.put(SubscriptionType.from, StateTransition.from);
        subsToStateMap.put(SubscriptionType.from_pending_out, StateTransition.from_pending_out);
        subsToStateMap.put(SubscriptionType.both, StateTransition.both);
    }

    public static enum StateTransition {
        none(SubscriptionType.none, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_out(SubscriptionType.none_pending_out, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_in(SubscriptionType.from, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        none_pending_out_in(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        to(SubscriptionType.to, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to, SubscriptionType.none, SubscriptionType.to, SubscriptionType.none),
        to_pending_in(SubscriptionType.both, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in),
        from(SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        from_pending_out(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.both, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        both(SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.from, SubscriptionType.both, SubscriptionType.from);

        private EnumMap<PresenceType, SubscriptionType> stateTransition = new EnumMap(PresenceType.class);

        private StateTransition(SubscriptionType out_subscribed, SubscriptionType out_unsubscribed, SubscriptionType in_subscribe, SubscriptionType in_unsubscribe, SubscriptionType in_subscribed, SubscriptionType in_unsubscribed, SubscriptionType out_subscribe, SubscriptionType out_unsubscribe) {
            this.stateTransition.put(PresenceType.out_subscribed, out_subscribed);
            this.stateTransition.put(PresenceType.out_unsubscribed, out_unsubscribed);
            this.stateTransition.put(PresenceType.in_subscribe, in_subscribe);
            this.stateTransition.put(PresenceType.in_unsubscribe, in_unsubscribe);
            this.stateTransition.put(PresenceType.in_subscribed, in_subscribed);
            this.stateTransition.put(PresenceType.in_unsubscribed, in_unsubscribed);
            this.stateTransition.put(PresenceType.out_subscribe, out_subscribe);
            this.stateTransition.put(PresenceType.out_unsubscribe, out_unsubscribe);
        }

        public SubscriptionType getStateTransition(PresenceType pres_type) {
            SubscriptionType res = this.stateTransition.get((Object)pres_type);
            log.finest("this=" + this.toString() + ", pres_type=" + (Object)((Object)pres_type) + ", res=" + (Object)((Object)res));
            return res;
        }
    }

    public static enum SubscriptionType {
        none("none", null),
        none_pending_out("none", "subscribe"),
        none_pending_in("none", null),
        none_pending_out_in("none", "subscribe"),
        to("to", null),
        to_pending_in("to", null),
        from("from", null),
        from_pending_out("from", "subscribe"),
        both("both", null),
        remove("remove", null);

        private Map<String, String> attrs = new LinkedHashMap<String, String>();

        private SubscriptionType(String subscr, String ask) {
            this.attrs.put(Roster.SUBSCRIPTION, subscr);
            if (ask != null) {
                this.attrs.put("ask", ask);
            }
        }

        public Map<String, String> getSubscriptionAttr() {
            return this.attrs;
        }
    }

    public static enum PresenceType {
        out_initial,
        out_subscribe,
        out_unsubscribe,
        out_subscribed,
        out_unsubscribed,
        in_initial,
        in_subscribe,
        in_unsubscribe,
        in_subscribed,
        in_unsubscribed,
        in_probe,
        error;

    }
}

