/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.Roster;

public abstract class Presence {
    private static final String PRESENCE_KEY = "user-presence";
    private static final String DIRECT_PRESENCE = "direct-presences";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Presence");
    protected static final String XMLNS = "jabber:client";
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            Element pres = (Element)session.getSessionData(PRESENCE_KEY);
            if (pres == null || pres.getAttribute("type") == null || !pres.getAttribute("type").equals("unavailable")) {
                try {
                    Presence.sendPresenceBroadcast(StanzaType.unavailable, session, Roster.FROM_SUBSCRIBED, results, null, settings);
                    Presence.updateOfflineChange(session, results);
                }
                catch (NotAuthorizedException e) {
                    // empty catch block
                }
            }
        }
    }

    protected static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<Roster.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings) throws NotAuthorizedException {
        Set direct_presences;
        String[] buddies = Roster.getBuddies(session, subscrs);
        if ((buddies = DynamicRoster.addBuddies(session, settings, buddies)) != null) {
            for (String buddy : buddies) {
                Presence.sendPresence(t, buddy, session.getJID(), results, pres);
            }
        }
        if ((direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE)) != null) {
            for (String buddy : direct_presences) {
                log.finest("Updating direct presence for: " + buddy);
                Presence.sendPresence(t, buddy, session.getJID(), results, pres);
            }
        }
    }

    protected static void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        String[] buddies = Roster.getBuddies(session, Roster.PENDING_IN);
        if (buddies != null) {
            for (String buddy : buddies) {
                Element presence = new Element("presence");
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setAttribute("from", buddy);
                Presence.updatePresenceChange(presence, session, results);
            }
        }
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            if (conn != session && conn.getResource() != null && !conn.getResource().equals(session.getResource())) {
                Element pres_update = new Element("presence");
                pres_update.setAttribute("from", session.getJID());
                pres_update.setAttribute("to", conn.getJID());
                pres_update.setAttribute("type", StanzaType.unavailable.toString());
                Packet pack_update = new Packet(pres_update);
                pack_update.setTo(conn.getConnectionId());
                results.offer(pack_update);
                continue;
            }
            log.finer("Skipping presence update to: " + conn.getJID());
        }
    }

    protected static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            if (conn != session) {
                Element pres_update = presence.clone();
                pres_update.setAttribute("from", session.getJID());
                pres_update.setAttribute("to", conn.getJID());
                Packet pack_update = new Packet(pres_update);
                pack_update.setTo(conn.getConnectionId());
                results.offer(pack_update);
                Element presence_el = (Element)conn.getSessionData(PRESENCE_KEY);
                if (presence_el == null) continue;
                pres_update = presence_el.clone();
                pres_update.setAttribute("to", session.getJID());
                pres_update.setAttribute("from", conn.getJID());
                pack_update = new Packet(pres_update);
                pack_update.setTo(session.getConnectionId());
                results.offer(pack_update);
                continue;
            }
            log.finer("Skipping presence update to: " + conn.getJID());
        }
    }

    protected static void updatePresenceChange(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            Element pres_update = presence.clone();
            pres_update.setAttribute("to", conn.getJID());
            Packet pack_update = new Packet(pres_update);
            pack_update.setTo(conn.getConnectionId());
            results.offer(pack_update);
        }
    }

    protected static void forwardPresence(Queue<Packet> results, Packet packet, String from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from);
        log.finest("\n\nFORWARD presence: " + result.toString());
        results.offer(new Packet(result));
    }

    protected static void sendPresence(StanzaType t, String to, String from, Queue<Packet> results, Element pres) {
        Element presence = null;
        if (pres == null) {
            presence = new Element("presence");
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to);
        presence.setAttribute("from", from);
        Packet packet = new Packet(presence);
        log.finest("Sending presence info: " + packet.getStringData());
        results.offer(packet);
    }

    protected static void addDirectPresenceJID(String jid, XMPPResourceConnection session) {
        HashSet<String> direct_presences = (HashSet<String>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new HashSet<String>();
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        direct_presences.add(jid);
        log.finest("Added direct presence jid: " + jid);
    }

    protected static void removeDirectPresenceJID(String jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        log.finest("Added direct presence jid: " + jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                String jid = session.getJID();
                Roster.PresenceType pres_type = Roster.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.warning("Invalid presence found: " + packet.toString());
                    return;
                }
                StanzaType type = packet.getType();
                if (type == null) {
                    type = StanzaType.available;
                }
                log.finest((Object)((Object)pres_type) + " presence found: " + packet.toString());
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getElemFrom() == null) {
                            log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet.toString());
                            return;
                        }
                        if (!JIDUtils.getNodeID((String)packet.getElemFrom()).equals(session.getUserId())) break;
                        log.fine("'in' subscription to myself, not allowed, returning error for packet: " + packet.toString());
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                        return;
                    }
                }
                boolean subscr_changed = false;
                switch (pres_type) {
                    case out_initial: {
                        if (packet.getElemTo() != null) {
                            Element result = packet.getElement().clone();
                            results.offer(new Packet(result));
                            if (packet.getType() != null && packet.getType() == StanzaType.unavailable) {
                                Presence.removeDirectPresenceJID(packet.getElemTo(), session);
                                break;
                            }
                            Presence.addDirectPresenceJID(packet.getElemTo(), session);
                            break;
                        }
                        boolean first = false;
                        if (session.getSessionData(PRESENCE_KEY) == null) {
                            first = true;
                        }
                        session.putSessionData(PRESENCE_KEY, packet.getElement());
                        String priority = packet.getElemCData("/presence/priority");
                        if (priority != null) {
                            int pr = 1;
                            try {
                                pr = Integer.decode(priority);
                            }
                            catch (NumberFormatException e) {
                                log.finer("Incorrect priority value: " + priority + ", setting 1 as default.");
                                pr = 1;
                            }
                            session.setPriority(pr);
                        }
                        if (first && type == StanzaType.available) {
                            Presence.sendPresenceBroadcast(StanzaType.probe, session, Roster.TO_SUBSCRIBED, results, null, settings);
                            Presence.resendPendingInRequests(session, results);
                        }
                        Presence.sendPresenceBroadcast(type, session, Roster.FROM_SUBSCRIBED, results, packet.getElement(), settings);
                        Presence.updateUserResources(packet.getElement(), session, results);
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: {
                        Roster.SubscriptionType current_subscription;
                        if (pres_type == Roster.PresenceType.out_subscribe && (current_subscription = Roster.getBuddySubscription(session, packet.getElemTo())) == null) {
                            Roster.addBuddy(session, packet.getElemTo());
                        }
                        if (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemTo())) {
                            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemTo()));
                        }
                        Presence.forwardPresence(results, packet, session.getUserId());
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemTo());
                        if (subscr_changed) {
                            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemTo()));
                            Presence.forwardPresence(results, packet, session.getUserId());
                            if (pres_type == Roster.PresenceType.out_subscribed) {
                                Element presence = (Element)session.getSessionData(PRESENCE_KEY);
                                if (presence != null) {
                                    Presence.sendPresence(null, packet.getElemTo(), session.getJID(), results, presence);
                                    break;
                                }
                                Presence.sendPresence(StanzaType.available, packet.getElemTo(), session.getJID(), results, null);
                                break;
                            }
                            Presence.sendPresence(StanzaType.unavailable, packet.getElemTo(), session.getJID(), results, null);
                        }
                        break;
                    }
                    case in_initial: {
                        if (packet.getElemFrom() == null) {
                            log.warning("Initial presence without from attribute set: " + packet.toString());
                            return;
                        }
                        if (Roster.isSubscribedTo(session, packet.getElemFrom()) || DynamicRoster.getBuddyItem(session, settings, packet.getElemFrom()) != null) {
                            Presence.updatePresenceChange(packet.getElement(), session, results);
                            break;
                        }
                        Element elem = packet.getElement().clone();
                        Packet result = new Packet(elem);
                        result.setTo(session.getConnectionId());
                        result.setFrom(packet.getTo());
                        results.offer(result);
                        break;
                    }
                    case in_subscribe: {
                        if (Roster.isSubscribedFrom(session, packet.getElemFrom())) {
                            Presence.sendPresence(StanzaType.subscribed, packet.getElemFrom(), session.getJID(), results, null);
                            break;
                        }
                        Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub == null) {
                            curr_sub = Roster.SubscriptionType.none;
                            Roster.addBuddy(session, packet.getElemFrom());
                        }
                        Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom());
                        Presence.updatePresenceChange(packet.getElement(), session, results);
                        break;
                    }
                    case in_unsubscribe: {
                        subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom());
                        if (subscr_changed) {
                            Presence.sendPresence(StanzaType.unsubscribed, packet.getElemFrom(), session.getJID(), results, null);
                            Presence.updatePresenceChange(packet.getElement(), session, results);
                            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_subscribed: {
                        Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub == null) {
                            curr_sub = Roster.SubscriptionType.none;
                            Roster.addBuddy(session, packet.getElemFrom());
                        }
                        if (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom())) {
                            Presence.updatePresenceChange(packet.getElement(), session, results);
                            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_unsubscribed: {
                        Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub != null && (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom()))) {
                            Presence.updatePresenceChange(packet.getElement(), session, results);
                            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_probe: {
                        Roster.SubscriptionType buddy_subscr = Roster.getBuddySubscription(session, packet.getElemFrom());
                        if (DynamicRoster.getBuddyItem(session, settings, packet.getElemFrom()) != null) {
                            buddy_subscr = Roster.SubscriptionType.both;
                        }
                        if (buddy_subscr == null) {
                            buddy_subscr = Roster.SubscriptionType.none;
                        }
                        switch (buddy_subscr) {
                            case none: 
                            case none_pending_out: 
                            case to: {
                                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, "Presence information is forbidden.", false));
                                break;
                            }
                            case none_pending_in: 
                            case none_pending_out_in: 
                            case to_pending_in: {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to get presence information.", false));
                                break;
                            }
                        }
                        if (Roster.isSubscribedFrom(buddy_subscr)) {
                            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                                Element pres = (Element)conn.getSessionData(PRESENCE_KEY);
                                Presence.sendPresence(null, packet.getElemFrom(), conn.getJID(), results, pres);
                            }
                        }
                        break;
                    }
                    case error: {
                        Element elem = packet.getElement().clone();
                        Packet result = new Packet(elem);
                        result.setTo(session.getConnectionId());
                        result.setFrom(packet.getTo());
                        results.offer(result);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.warning("Can not access user Roster, user session is not authorized yet: " + packet.getStringData());
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
        }
    }
}

