/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class OfflineMessages
extends XMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.OfflineMessage");
    private static final String ID = "msgoffline";
    private static final String XMLNS = "jabber:client";
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private SimpleParser parser = SingletonFactory.getParserInstance();
    private SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (conn == null) {
            return;
        }
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            String priority_str = packet.getElemCData("/presence/priority");
            int priority = 0;
            if (priority_str != null) {
                try {
                    priority = Integer.decode(priority_str);
                }
                catch (NumberFormatException e) {
                    priority = 0;
                }
            }
            if (priority >= 0) {
                try {
                    Queue<Packet> packets = this.restorePacketForOffLineUser(conn);
                    if (packets != null) {
                        log.finer("Sending off-line messages: " + packets.size());
                        results.addAll(packets);
                    }
                }
                catch (NotAuthorizedException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> queue) {
        if (conn == null) {
            try {
                if (this.savePacketForOffLineUser(packet, repo)) {
                    packet.processedBy(ID);
                }
            }
            catch (UserNotFoundException e) {
                log.finest("UserNotFoundException at trying to save packet for off-line user." + packet.getStringData());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePacketForOffLineUser(Packet pac, NonAuthUserRepository repo) throws UserNotFoundException {
        StanzaType type = pac.getType();
        if (pac.getElemName().equals("message") && (type == null || type == StanzaType.normal || type == StanzaType.chat) || pac.getElemName().equals("presence") && (type == StanzaType.subscribe || type == StanzaType.subscribed || type == StanzaType.unsubscribe || type == StanzaType.unsubscribed)) {
            Element packet = pac.getElement().clone();
            String stamp = null;
            SimpleDateFormat simpleDateFormat = this.formater;
            synchronized (simpleDateFormat) {
                stamp = this.formater.format(new Date());
            }
            String from = JIDUtils.getNodeHost((String)pac.getElemTo());
            Element x = new Element("x", "Offline Storage", new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, "jabber:x:delay"});
            packet.addChild(x);
            String user_id = JIDUtils.getNodeID((String)pac.getElemTo());
            repo.addOfflineDataList(user_id, ID, "messages", new String[]{packet.toString()});
            return true;
        }
        return false;
    }

    public Queue<Packet> restorePacketForOffLineUser(XMPPResourceConnection conn) throws NotAuthorizedException {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        String[] msgs = conn.getOfflineDataList(ID, "messages");
        if (msgs != null && msgs.length > 0) {
            conn.removeOfflineDataGroup(ID);
            LinkedList<Packet> pacs = new LinkedList<Packet>();
            StringBuilder sb = new StringBuilder();
            for (String msg : msgs) {
                sb.append(msg);
            }
            char[] data = sb.toString().toCharArray();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue elems = domHandler.getParsedElements();
            Element elem = null;
            while ((elem = (Element)elems.poll()) != null) {
                pacs.offer(new Packet(elem));
            }
            try {
                Collections.sort(pacs, new StampComparator());
            }
            catch (NullPointerException e) {
                log.warning("Can not sort off line messages, " + e);
            }
            return pacs;
        }
        return null;
    }

    private class StampComparator
    implements Comparator<Packet> {
        private StampComparator() {
        }

        @Override
        public int compare(Packet p1, Packet p2) {
            String stamp1 = p1.getElement().getAttribute("/message/x", "stamp");
            String stamp2 = p2.getElement().getAttribute("/message/x", "stamp");
            return stamp1.compareTo(stamp2);
        }
    }
}

