/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.Roster;

public abstract class JabberIqRoster {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqRoster");
    protected static final String XMLNS = "jabber:iq:roster";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:roster"};
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster"})};

    private static void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        Element request = packet.getElement();
        String buddy = JIDUtils.getNodeID((String)request.getAttribute("/iq/query/item", "jid"));
        Element item = request.findChild("/iq/query/item");
        String subscription = item.getAttribute("subscription");
        if (subscription != null && subscription.equals("remove")) {
            Roster.SubscriptionType sub = Roster.getBuddySubscription(session, buddy);
            if (sub != null && sub != Roster.SubscriptionType.none) {
                Element pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribe");
                results.offer(new Packet(pres));
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribed");
                results.offer(new Packet(pres));
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getJID());
                pres.setAttribute("type", "unavailable");
                results.offer(new Packet(pres));
            }
            Element it = new Element("item");
            it.setAttribute("jid", buddy);
            it.setAttribute("subscription", "remove");
            Roster.updateBuddyChange(session, results, it);
            Roster.removeBuddy(session, buddy);
            results.offer(packet.okResult((String)null, 0));
        } else {
            List groups;
            String name = request.getAttribute("/iq/query/item", "name");
            if (name == null) {
                name = buddy;
            }
            Roster.setBuddyName(session, buddy, name);
            if (Roster.getBuddySubscription(session, buddy) == null) {
                Roster.setBuddySubscription(session, Roster.SubscriptionType.none, buddy);
            }
            if ((groups = item.getChildren()) != null && groups.size() > 0) {
                String[] gr = new String[groups.size()];
                int cnt = 0;
                for (Element group : groups) {
                    gr[cnt++] = group.getCData() == null ? "" : group.getCData();
                }
                session.setDataList(Roster.groupNode(buddy), "groups", gr);
            } else {
                session.removeData(Roster.groupNode(buddy), "groups");
            }
            results.offer(packet.okResult((String)null, 0));
            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, buddy));
        }
    }

    private static void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        String[] buddies = Roster.getBuddies(session);
        if (buddies != null) {
            Element query = new Element("query");
            query.setXMLNS(XMLNS);
            for (String buddy : buddies) {
                Element buddy_item = Roster.getBuddyItem(session, buddy);
                String item_group = buddy_item.getCData("/item/group");
                query.addChild(buddy_item);
            }
            if (query.getChildren() != null && query.getChildren().size() > 0) {
                results.offer(packet.okResult(query, 0));
            } else {
                results.offer(packet.okResult((String)null, 1));
            }
        } else {
            results.offer(packet.okResult((String)null, 1));
        }
        List<Element> its = DynamicRoster.getRosterItems(session, settings);
        if (its != null) {
            LinkedList<Element> items = new LinkedList<Element>(its);
            while (items.size() > 0) {
                Element iq = new Element("iq", new String[]{"type", "id", "to"}, new String[]{"set", "dr-" + items.size(), session.getJID()});
                Element query = new Element("query");
                query.setXMLNS(XMLNS);
                iq.addChild(query);
                query.addChild(items.poll());
                while (query.getChildren().size() < 20 && items.size() > 0) {
                    query.addChild(items.poll());
                }
                Packet rost_res = new Packet(iq);
                rost_res.setTo(session.getConnectionId());
                rost_res.setFrom(packet.getTo());
                results.offer(rost_res);
            }
        }
    }

    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        try {
            if (packet.getElemFrom() != null && !session.getUserId().equals(JIDUtils.getNodeID((String)packet.getElemFrom()))) {
                log.warning("Roster request 'from' attribute doesn't match session userid: " + session.getUserId() + ", request: " + packet.getStringData());
                return;
            }
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    JabberIqRoster.processGetRequest(packet, session, results, settings);
                    break;
                }
                case set: {
                    JabberIqRoster.processSetRequest(packet, session, results);
                    break;
                }
                case result: {
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received roster request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

