/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Privacy;
import tigase.xmpp.impl.Roster;

public class JabberIqPrivacy
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqPrivacy");
    private static final String XMLNS = "jabber:iq:privacy";
    private static final String ID = "jabber:iq:privacy";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:privacy"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:privacy"})};
    private static final Comparator<Element> compar = new Comparator<Element>(){

        @Override
        public int compare(Element el1, Element el2) {
            String or1 = el1.getAttribute("order");
            String or2 = el2.getAttribute("order");
            return or1.compareTo(or2);
        }
    };

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return "jabber:iq:privacy";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        block31: {
            if (session == null || !session.isAuthorized()) {
                return false;
            }
            try {
                Element list = Privacy.getActiveList(session);
                if (list == null && session.getSessionData("privacy-init") == null) {
                    String lName = Privacy.getDefaultList(session);
                    if (lName != null) {
                        Privacy.setActiveList(session, lName);
                        list = Privacy.getActiveList(session);
                    }
                    session.putSessionData("privacy-init", "");
                }
                if (list == null) break block31;
                List items = list.getChildren();
                Collections.sort(items, compar);
                for (Element item : items) {
                    boolean elem_matched;
                    boolean type_matched;
                    block33: {
                        ITEM_TYPE type;
                        block32: {
                            type_matched = false;
                            elem_matched = false;
                            type = ITEM_TYPE.all;
                            if (item.getAttribute("type") != null) {
                                type = ITEM_TYPE.valueOf(item.getAttribute("type"));
                            }
                            String value = item.getAttribute("value");
                            String from = packet.getElemFrom();
                            if (from == null) break block32;
                            block1 : switch (type) {
                                case jid: {
                                    type_matched = from.contains(value);
                                    break;
                                }
                                case group: {
                                    String[] groups = Roster.getBuddyGroups(session, from);
                                    if (groups != null) {
                                        for (String group : groups) {
                                            type_matched = group.equals(value);
                                            if (type_matched) break block1;
                                        }
                                    }
                                    break block33;
                                }
                                case subscription: {
                                    ITEM_SUBSCRIPTIONS subscr = ITEM_SUBSCRIPTIONS.valueOf(value);
                                    switch (subscr) {
                                        case to: {
                                            type_matched = Roster.isSubscribedTo(session, from);
                                            break block1;
                                        }
                                        case from: {
                                            type_matched = Roster.isSubscribedFrom(session, from);
                                            break block1;
                                        }
                                        case none: {
                                            type_matched = !Roster.isSubscribedFrom(session, from) && !Roster.isSubscribedTo(session, from);
                                            break block1;
                                        }
                                        case both: {
                                            type_matched = Roster.isSubscribedFrom(session, from) && Roster.isSubscribedTo(session, from);
                                            break block1;
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    type_matched = true;
                                }
                            }
                            break block33;
                        }
                        if (type == ITEM_TYPE.all) {
                            type_matched = true;
                        }
                    }
                    if (type_matched) {
                        List elems = item.getChildren();
                        if (elems == null || elems.size() == 0) {
                            elem_matched = true;
                        } else {
                            for (Element elem : elems) {
                                if (elem.getName().equals("presence-in")) {
                                    if (!packet.getElemName().equals("presence") || packet.getType() != null && packet.getType() != StanzaType.unavailable) continue;
                                    elem_matched = true;
                                    break;
                                }
                                if (!elem.getName().equals(packet.getElemName())) continue;
                                elem_matched = true;
                                break;
                            }
                        }
                        if (elem_matched) {
                            ITEM_ACTION action = ITEM_ACTION.valueOf(item.getAttribute("action"));
                            switch (action) {
                                case allow: {
                                    return false;
                                }
                                case deny: {
                                    return true;
                                }
                            }
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (NotAuthorizedException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    this.processGetRequest(packet, session, results);
                    break;
                }
                case set: {
                    this.processSetRequest(packet, session, results);
                    break;
                }
                case result: {
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received privacy request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    private void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException {
        List<Element> children = packet.getElemChildren("/iq/query");
        if (children != null && children.size() == 1) {
            Element child = children.get(0);
            if (child.getName().equals("list")) {
                String name = child.getAttribute("name");
                if (name == null || name.length() == 0) {
                    child.setAttribute("name", "default");
                }
                Privacy.addList(session, child);
                results.offer(packet.okResult((String)null, 0));
            }
            if (child.getName().equals("default")) {
                Privacy.setDefaultList(session, child);
                results.offer(packet.okResult((String)null, 0));
            }
            if (child.getName().equals("active")) {
                Privacy.setActiveList(session, child.getAttribute("name"));
                results.offer(packet.okResult((String)null, 0));
            }
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Only 1 element is allowed in privacy set request.", true));
        }
    }

    private void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException {
        List<Element> children = packet.getElemChildren("/iq/query");
        if (children == null || children.size() == 0) {
            String[] lists = Privacy.getLists(session);
            if (lists != null) {
                StringBuilder sblists = new StringBuilder();
                for (String list : lists) {
                    sblists.append("<list name=\"" + list + "\"/>");
                }
                String list = Privacy.getDefaultList(session);
                if (list != null) {
                    sblists.append("<default name=\"" + list + "\"/>");
                }
                if ((list = Privacy.getActiveListName(session)) != null) {
                    sblists.append("<active name=\"" + list + "\"/>");
                }
                results.offer(packet.okResult(sblists.toString(), 1));
            } else {
                results.offer(packet.okResult((String)null, 1));
            }
        } else if (children.size() > 1) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "You can retrieve only one list at a time.", true));
        } else {
            Element eList = Privacy.getList(session, children.get(0).getAttribute("name"));
            if (eList != null) {
                results.offer(packet.okResult(eList, 1));
            } else {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Requested list not found.", true));
            }
        }
    }

    private static enum ITEM_SUBSCRIPTIONS {
        both,
        to,
        from,
        none;

    }

    private static enum ITEM_ACTION {
        allow,
        deny;

    }

    private static enum ITEM_TYPE {
        jid,
        group,
        subscription,
        all;

    }
}

