/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRosterIfc;

public abstract class DynamicRoster {
    private static final String DYNAMIC_ROSTERS = "dynamic-rosters";
    private static final String DYNAMIC_ROSTERS_CLASSES = "dynamic-roster-classes";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.DynamicRoster");

    public static void init_settings(Map<String, Object> settings) {
        DynamicRosterIfc[] dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        if (dynr == null) {
            log.info("Initializing dynamic rosters...");
            String dynclss = (String)settings.get(DYNAMIC_ROSTERS_CLASSES);
            if (dynclss != null) {
                String[] dyncls = dynclss.split(",");
                ArrayList<DynamicRosterIfc> al = new ArrayList<DynamicRosterIfc>();
                for (String cls : dyncls) {
                    try {
                        DynamicRosterIfc dri = (DynamicRosterIfc)Class.forName(cls).newInstance();
                        if (settings.get(cls + ".init") != null) {
                            dri.init((String)settings.get(cls + ".init"));
                        } else {
                            dri.init(settings);
                        }
                        al.add(dri);
                        log.info("Initialized dynamic roster: " + cls);
                    }
                    catch (Exception e) {
                        log.warning("Problem initializing dynmic roster class: " + cls + ", " + e);
                    }
                }
                if (al.size() > 0) {
                    settings.put(DYNAMIC_ROSTERS, al.toArray(new DynamicRosterIfc[al.size()]));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Element> getRosterItems(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = null;
        if (settings != null) {
            Map<String, Object> map = settings;
            synchronized (map) {
                log.finest("Initializing settings.");
                DynamicRoster.init_settings(settings);
            }
            dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        } else {
            log.finest("Settings parameter is NULL");
        }
        if (dynr != null) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (DynamicRosterIfc dri : dynr) {
                List<Element> items = dri.getRosterItems(session);
                if (items == null) continue;
                result.addAll(items);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getBuddyItem(XMPPResourceConnection session, Map<String, Object> settings, String buddy) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = null;
        if (settings != null) {
            Map<String, Object> map = settings;
            synchronized (map) {
                log.finest("Initializing settings.");
                DynamicRoster.init_settings(settings);
            }
            dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        } else {
            log.finest("Settings parameter is NULL");
        }
        if (dynr != null) {
            for (void var7_8 : dynr) {
                Element item = var7_8.getBuddyItem(session, buddy);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getBuddiesList(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = null;
        if (settings != null) {
            Map<String, Object> map = settings;
            synchronized (map) {
                log.finest("Initializing settings.");
                DynamicRoster.init_settings(settings);
            }
            dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        } else {
            log.finest("Settings parameter is NULL");
        }
        if (dynr != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (DynamicRosterIfc dri : dynr) {
                String[] buddies = dri.getBuddies(session);
                if (buddies == null) continue;
                result.addAll(Arrays.asList(buddies));
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return null;
    }

    public static String[] getBuddies(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        List<String> result = DynamicRoster.getBuddiesList(session, settings);
        if (result != null && result.size() > 0) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public static String[] addBuddies(XMPPResourceConnection session, Map<String, Object> settings, String[] buddies) throws NotAuthorizedException {
        List<String> result = DynamicRoster.getBuddiesList(session, settings);
        if (buddies != null) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.addAll(Arrays.asList(buddies));
        }
        if (result != null && result.size() > 0) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }
}

