/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class BindResource
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String RESOURCE_KEY = "Resource-Binded";
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-bind";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.BindResource");
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-bind";
    private static final String[] ELEMENTS = new String[]{"bind"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-bind"};
    private static final Element[] FEATURES = new Element[]{new Element("bind", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private static int resGenerator = 0;

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-bind";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null) {
            return null;
        }
        if (session.getSessionData(RESOURCE_KEY) != null || !session.isAuthorized()) {
            return null;
        }
        return FEATURES;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            return;
        }
        Element request = packet.getElement();
        StanzaType type = packet.getType();
        try {
            switch (type) {
                case set: {
                    String resource = request.getChildCData("/iq/bind/resource");
                    if (resource == null || resource.equals("")) {
                        session.setResource("tigase-" + ++resGenerator);
                    } else {
                        session.setResource(resource);
                    }
                    session.putSessionData(RESOURCE_KEY, "true");
                    results.offer(packet.okResult("<jid>" + session.getJID() + "</jid>", 1));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bind type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
        }
    }
}

